/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.ui.dialogs;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;

public class ConnectionProfileSummaryDialog
extends Dialog {
    private static final int WIDTH = 700;
    private static final int HEIGHT = 400;
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ConnectionProfileSummaryDialog.class);
    private static final String TITLE = ConnectionProfileSummaryDialog.getString("title");
    private Properties properties;
    private String modelName;
    private TableViewer propsViewer;
    private TableContentProvider propertiesContentProvider;

    private static String getString(String id) {
        return DatatoolsUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object value) {
        return DatatoolsUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, value);
    }

    public ConnectionProfileSummaryDialog(Shell parent, String modelName, Properties props) {
        super(parent, TITLE);
        this.modelName = modelName;
        this.properties = props;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainPanel = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        mainPanel.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gd = new GridData(1808);
        gd.widthHint = 700;
        gd.heightHint = 400;
        mainPanel.setLayoutData((Object)gd);
        Group messageGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)ConnectionProfileSummaryDialog.getString("messageGroup.label"), (int)1808, (int)1, (int)1);
        StyledText msg = new StyledText((Composite)messageGroup, 0);
        GridData gdt = new GridData(1808);
        gdt.widthHint = 400;
        msg.setLayoutData((Object)gdt);
        msg.setEditable(false);
        msg.setWordWrap(true);
        msg.setText(ConnectionProfileSummaryDialog.getString("messageGroup.message", this.modelName));
        Group propsGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)ConnectionProfileSummaryDialog.getString("propsGroup.label"), (int)1808, (int)2, (int)2);
        GridData propertiesGridData = new GridData(1808);
        propertiesGridData.horizontalSpan = 2;
        propertiesGridData.heightHint = 220;
        propertiesGridData.minimumHeight = 220;
        propertiesGridData.grabExcessVerticalSpace = true;
        propsGroup.setLayoutData((Object)propertiesGridData);
        int tableStyle = 68096;
        this.propsViewer = new TableViewer((Composite)propsGroup, tableStyle);
        Table table = this.propsViewer.getTable();
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(ConnectionProfileSummaryDialog.getString("properties.name"));
        column1.setWidth(200);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(ConnectionProfileSummaryDialog.getString("properties.value"));
        column2.setWidth(50);
        table.pack();
        GridData columnData = new GridData(1808);
        table.setLayoutData((Object)columnData);
        this.propertiesContentProvider = new TableContentProvider();
        this.propsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.propsViewer.setLabelProvider((IBaseLabelProvider)this.propertiesContentProvider);
        if (this.properties != null && !this.properties.isEmpty()) {
            ArrayList<StringKeyValuePair> propsColl = new ArrayList<StringKeyValuePair>();
            for (Object key : this.properties.keySet()) {
                String keyStr = (String)key;
                String value = this.properties.getProperty((String)key);
                propsColl.add(new StringKeyValuePair(keyStr, value));
            }
            this.propsViewer.setInput(propsColl);
        }
        return mainPanel;
    }

    public void create() {
        super.create();
        this.setOkEnabled(true);
    }

    public void setOkEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    class StringKeyValuePair {
        private String key;
        private String value;

        public StringKeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    class TableContentProvider
    implements ITableLabelProvider {
        TableContentProvider() {
        }

        public Image getColumnImage(Object theElement, int theIndex) {
            return null;
        }

        public String getColumnText(Object theElement, int theColumnIndex) {
            if (theElement instanceof StringKeyValuePair) {
                StringKeyValuePair prop = (StringKeyValuePair)theElement;
                if (theColumnIndex == 0) {
                    return prop.getKey();
                }
                return prop.getValue();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }
}

