/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.ui.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.datatools.connection.ConnectionInfoProviderFactory;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.datatools.ui.DatatoolsUiPlugin;
import org.teiid.designer.datatools.ui.dialogs.ConnectionProfileSummaryDialog;
import org.teiid.designer.ui.actions.IConnectionAction;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ViewConnectionProfileAction
extends SortableSelectionAction
implements IConnectionAction {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ViewConnectionProfileAction.class);
    private static final String TITLE = ViewConnectionProfileAction.getString("title");
    private ConnectionInfoProviderFactory providerFactory;

    private static String getString(String id) {
        return DatatoolsUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object value) {
        return DatatoolsUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, value);
    }

    public ViewConnectionProfileAction() {
        super(TITLE, -1);
        this.setImageDescriptor(DatatoolsUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/view-connection.png"));
        this.providerFactory = new ConnectionInfoProviderFactory();
    }

    public boolean isValidSelection(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    public void run() {
        ModelResource modelResource = null;
        if (!this.getSelection().isEmpty()) {
            IFile modelFile = (IFile)SelectionUtilities.getSelectedObjects((ISelection)this.getSelection()).get(0);
            modelResource = ModelUtilities.getModelResource((Object)modelFile);
        }
        if (modelResource != null) {
            Properties props = this.getModelConnectionProperties(modelResource);
            if (props == null || props.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ViewConnectionProfileAction.getString("noInfo.title"), (String)ViewConnectionProfileAction.getString("noInfo.message", modelResource.getItemName()));
                return;
            }
            String name = modelResource.getItemName();
            ConnectionProfileSummaryDialog dialog = new ConnectionProfileSummaryDialog(this.getShell(), name, props);
            dialog.open();
        }
    }

    private Properties getModelConnectionProperties(ModelResource mr) {
        block8: {
            try {
                if (!ModelIdentifier.isRelationalSourceModel((ModelResource)mr)) break block8;
                IConnectionInfoProvider provider = null;
                try {
                    provider = this.getProvider(mr);
                }
                catch (Exception exception) {}
                if (provider != null) {
                    Properties properties = provider.getProfileProperties(mr);
                    Properties p2 = provider.getConnectionProperties(mr);
                    String translatorName = provider.getTranslatorName(mr);
                    for (Object key : p2.keySet()) {
                        properties.put(key, p2.get(key));
                    }
                    if (translatorName != null) {
                        properties.put(ViewConnectionProfileAction.getString("translatorKey"), translatorName);
                    }
                    if (properties != null && !properties.isEmpty()) {
                        return properties;
                    }
                }
            }
            catch (CoreException e) {
                DatatoolsUiConstants.UTIL.log((Throwable)e);
            }
        }
        return null;
    }

    public boolean isApplicable(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    private boolean sourceModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? ModelIdentifier.isRelationalSourceModel((IResource)((IFile)nextObj)) : false;
            }
        }
        return result;
    }

    public IConnectionInfoProvider getProvider(ModelResource modelResource) throws Exception {
        IConnectionInfoProvider provider = null;
        provider = this.providerFactory.getProvider(modelResource);
        if (provider == null) {
            throw new Exception(ViewConnectionProfileAction.getString("noConnectionInfoProvider.message"));
        }
        return provider;
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }
}

