/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.xml;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.designer.datatools.profiles.xml.XmlLocalFileConnectionProfileWizard;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class XmlLocalFileProfileDetailsWizardPage
extends ConnectionProfileDetailsPage
implements Listener,
DatatoolsUiConstants {
    private Composite scrolled;
    private Label profileLabel;
    private CLabel profileText;
    private Label descriptionLabel;
    private Text descriptionText;
    private Label localFileNameLabel;
    private Text localFilePathText;
    private Button fileSystemSourceBrowseButton;

    public XmlLocalFileProfileDetailsWizardPage(String pageName) {
        super(pageName, UTIL.getString("XmlLocalFileProfileDetailsWizardPage.Name", new Object[0]), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.teiid.designer.datatools.ui", (String)"icons/ldap.gif"));
    }

    public void createCustomControl(Composite parent) {
        Group group = WidgetFactory.createSimpleGroup((Composite)parent, (String)UTIL.getString("Common.Properties.Label", new Object[0]));
        this.scrolled = new Composite((Composite)group, 2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.scrolled.setLayout((Layout)gridLayout);
        this.profileLabel = new Label(this.scrolled, 0);
        this.profileLabel.setText(UTIL.getString("Common.Profile.Label", new Object[0]));
        this.profileText = WidgetFactory.createLabel((Composite)this.scrolled, (int)2052);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.profileText.setLayoutData((Object)gd);
        this.profileText.setText(((XmlLocalFileConnectionProfileWizard)this.getWizard()).getProfileName());
        this.descriptionLabel = new Label(this.scrolled, 0);
        this.descriptionLabel.setText(UTIL.getString("Common.Description.Label", new Object[0]));
        gd = new GridData();
        this.descriptionLabel.setLayoutData((Object)gd);
        this.descriptionText = WidgetFactory.createTextBox((Composite)this.scrolled, (int)2060, (int)4);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.descriptionText.setLayoutData((Object)gd);
        String description = ((XmlLocalFileConnectionProfileWizard)this.getWizard()).getProfileDescription();
        this.descriptionText.setText(description);
        this.descriptionText.setBackground(Display.getCurrent().getSystemColor(19));
        this.localFileNameLabel = new Label(this.scrolled, 0);
        this.localFileNameLabel.setText(UTIL.getString("Common.FileName", new Object[0]));
        gd = new GridData();
        this.localFileNameLabel.setLayoutData((Object)gd);
        this.localFilePathText = new Text(this.scrolled, 2052);
        gd = new GridData(768);
        this.localFilePathText.setLayoutData((Object)gd);
        this.fileSystemSourceBrowseButton = new Button(this.scrolled, 8);
        this.fileSystemSourceBrowseButton.setText(UTIL.getString("Common.BROWSE_BUTTON_LBL_UI_", new Object[0]));
        this.fileSystemSourceBrowseButton.setLayoutData((Object)new GridData(256));
        Group descriptionGroup = WidgetFactory.createGroup((Composite)this.scrolled, (String)UTIL.getString("Common.Description", new Object[0]), (int)768, (int)3);
        Text descriptionText = new Text((Composite)descriptionGroup, 72);
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 150;
        gd.widthHint = 300;
        descriptionText.setLayoutData((Object)gd);
        descriptionText.setText(UTIL.getString("XmlLocalFileProfileDetailsWizardPage.descriptionMessage", new Object[0]));
        descriptionText.setBackground(this.scrolled.getBackground());
        descriptionText.setForeground(Display.getCurrent().getSystemColor(10));
        this.setPingButtonVisible(false);
        this.setPingButtonEnabled(false);
        this.setAutoConnectOnFinishDefault(false);
        this.setCreateAutoConnectControls(false);
        this.setShowAutoConnect(false);
        this.setShowAutoConnectOnFinish(false);
        this.setPageComplete(false);
        this.addListeners();
    }

    private void addListeners() {
        this.localFilePathText.addListener(24, (Listener)this);
        this.fileSystemSourceBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XmlLocalFileProfileDetailsWizardPage.this.handleFileSystemSourceBrowseButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void handleFileSystemSourceBrowseButtonPressed() {
        int lastSeparatorIndex;
        String selectedFilePath = null;
        FileDialog dialog = new FileDialog(this.localFilePathText.getShell(), 4096);
        String currentSourceString = this.localFilePathText.getText();
        if (currentSourceString != null && (lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator)) != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        if ((selectedFilePath = dialog.open()) != null) {
            if (!selectedFilePath.equals(this.localFilePathText.getText())) {
                this.localFilePathText.setText(selectedFilePath);
            }
        } else {
            this.localFilePathText.setText("");
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.localFilePathText) {
            Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
            String fileUrl = this.localFilePathText.getText();
            properties.setProperty("LocalFilePath", this.localFilePathText.getText());
            Path fullPath = new Path(fileUrl);
            String directoryUrl = fullPath.removeLastSegments(1).toString();
            properties.setProperty("ParentDirectory", directoryUrl);
        }
        this.updateState();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateState();
    }

    void updateState() {
        this.setPingButtonVisible(false);
        this.setPingButtonEnabled(false);
        this.profileText.setText(((NewConnectionProfileWizard)this.getWizard()).getProfileName());
        this.descriptionText.setText(((NewConnectionProfileWizard)this.getWizard()).getProfileDescription());
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        if (properties.get("LocalFilePath") == null || properties.get("LocalFilePath").toString().isEmpty()) {
            this.setErrorMessage(UTIL.getString("Common.File.Error.Empty.Message", new Object[0]));
            return;
        }
        this.setErrorMessage(null);
        File localFile = new File(properties.get("LocalFilePath").toString());
        if (!localFile.exists()) {
            this.setErrorMessage(UTIL.getString("Common.File.Error.DoesNotExist.Message", (Object)localFile));
            return;
        }
        String urlString = properties.get("LocalFilePath").toString();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            File xmlFile = new File(urlString);
            dBuilder.parse(new FileInputStream(xmlFile));
        }
        catch (Exception ex) {
            this.setErrorMessage(UTIL.getString("XmlLocalProfileDetailsWizardPage.InvalidXml.Message", new Object[]{urlString, ex.getMessage()}));
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.setMessage(UTIL.getString("Click.Next.or.Finish", new Object[0]));
    }

    public boolean canFlipToNextPage() {
        return this.internalComplete(super.canFlipToNextPage());
    }

    private boolean internalComplete(boolean complete) {
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        if (complete && (properties.get("LocalFilePath") == null || properties.get("LocalFilePath").toString().isEmpty())) {
            complete = false;
        }
        return complete;
    }

    public List getSummaryData() {
        List result = super.getSummaryData();
        result.add(new String[]{UTIL.getString("Common.URL.Label", new Object[0]), this.localFilePathText.getText()});
        return result;
    }
}

