/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ws;

import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.core.util.URLHelper;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;

public class WSWizardUtils {
    private WSWizardUtils() {
    }

    public static Exception testURLConnection(IConnectionProfile connectionProfile, String propertyKey) {
        Properties connProperties = connectionProfile.getBaseProperties();
        String xmlFile = connProperties == null ? null : (String)connProperties.get(propertyKey);
        String responseType = "XML";
        if (connProperties != null && connProperties.get("responseType") != null) {
            responseType = (String)connProperties.get("responseType");
        }
        try {
            URL url = URLHelper.buildURL((String)xmlFile);
            boolean resolved = false;
            HashMap<String, String> connPropMap = new HashMap<String, String>();
            if (connProperties.get("Accept") != null) {
                connPropMap.put("Accept", (String)connProperties.get("Accept"));
            } else if (responseType.equalsIgnoreCase("JSON")) {
                connPropMap.put("Accept", "application/json");
            } else {
                connPropMap.put("Accept", "application/xml");
            }
            if (connProperties.get("Content-Type") != null) {
                connPropMap.put("Content-Type", (String)connProperties.get("Content-Type"));
            } else {
                connPropMap.put("Content-Type", "application/xml");
            }
            for (Object key : connPropMap.keySet()) {
                String keyStr = (String)key;
                if ("Authorization".equalsIgnoreCase(keyStr) || "AuthPassword".equalsIgnoreCase(keyStr) || "SecurityType".equalsIgnoreCase(keyStr) || "AuthUserName".equalsIgnoreCase(keyStr) || "EndPoint".equalsIgnoreCase(keyStr) || "Content-Type".equalsIgnoreCase(keyStr) || "Accept".equalsIgnoreCase(keyStr)) continue;
                connPropMap.put(keyStr, connProperties.getProperty(keyStr));
            }
            String userName = null;
            String password = null;
            userName = connProperties.getProperty("AuthUserName");
            resolved = URLHelper.resolveUrl((URL)url, (String)userName, (String)(password = connProperties.getProperty("AuthPassword")), connPropMap, (boolean)true);
            if (!resolved) {
                throw new Exception(DatatoolsUiConstants.UTIL.getString("WSWizardUtils.connectionFailureMessage", new Object[0]));
            }
        }
        catch (Exception ex) {
            return ex;
        }
        return null;
    }
}

