/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ldap;

import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.datatools.profiles.ldap.LdapConnectionProfileWizard;
import org.teiid.designer.datatools.profiles.ldap.widget.LdapAuthenticationWidget;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;

public class LdapProfileAuthenticationWizardPage
extends ConnectionProfileDetailsPage
implements IChangeListener,
DatatoolsUiConstants {
    private LdapAuthenticationWidget authWidget;

    public LdapProfileAuthenticationWizardPage(String pageName) {
        super(pageName, UTIL.getString("LdapProfileAuthenticationWizardPage.Name", new Object[0]), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.teiid.designer.datatools.ui", (String)"icons/ldap.gif"));
    }

    public void createCustomControl(Composite parent) {
        this.authWidget = new LdapAuthenticationWidget(parent, 0, ((LdapConnectionProfileWizard)this.getWizard()).getProfileProperties());
        this.authWidget.addChangeListener(this);
        this.setPingButtonVisible(false);
        this.setAutoConnectOnFinishDefault(false);
        this.setPingButtonEnabled(false);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateState();
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.updateState();
    }

    private boolean hasProperty(Properties properties, String key) {
        if (properties.get(key) == null) {
            return false;
        }
        String value = properties.getProperty(key);
        return !value.isEmpty();
    }

    private boolean hasUser(Properties properties) {
        return this.hasProperty(properties, "LdapAdminUserDN");
    }

    private boolean hasPassword(Properties properties) {
        return this.hasProperty(properties, "LdapAdminUserPassword");
    }

    private boolean hasAuth(Properties properties) {
        return this.hasProperty(properties, "LdapAuthenticationMethod");
    }

    private boolean isAuthNone(Properties properties) {
        if (!this.hasAuth(properties)) {
            return false;
        }
        return "none".equals(properties.getProperty("LdapAuthenticationMethod"));
    }

    private boolean isAuthSimple(Properties properties) {
        if (!this.hasAuth(properties)) {
            return false;
        }
        return "simple".equals(properties.getProperty("LdapAuthenticationMethod"));
    }

    void updateState() {
        this.setErrorMessage(null);
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        boolean authSimple = this.isAuthSimple(properties);
        boolean hasPassword = this.hasPassword(properties);
        boolean hasUser = this.hasUser(properties);
        if (authSimple && !hasPassword) {
            this.setErrorMessage(UTIL.getString("Common.Password.Error.Message", new Object[0]));
        } else if (authSimple && !hasUser) {
            this.setErrorMessage(UTIL.getString("Common.Username.Error.Message", new Object[0]));
        } else {
            this.setErrorMessage(null);
        }
        boolean pageComplete = authSimple ? hasUser && hasPassword : true;
        this.setPingButtonEnabled(pageComplete);
        this.setPageComplete(pageComplete);
        this.setMessage(UTIL.getString("Click.Next.or.Finish", new Object[0]));
    }

    public boolean canFlipToNextPage() {
        return this.internalComplete(super.canFlipToNextPage());
    }

    private boolean internalComplete(boolean complete) {
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        if (!this.hasAuth(properties)) {
            properties.setProperty("LdapAuthenticationMethod", "none");
        }
        if (this.isAuthNone(properties)) {
            return complete;
        }
        if (this.isAuthSimple(properties)) {
            if (complete && !this.hasUser(properties)) {
                complete = false;
            }
            if (complete && !this.hasPassword(properties)) {
                complete = false;
            }
        }
        return complete;
    }

    public void testConnection() {
        super.testConnection();
    }

    public List getSummaryData() {
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        List result = super.getSummaryData();
        result.add(new String[]{UTIL.getString("LdapAuthenticationWidget.Auth.Label", new Object[0]), properties.getProperty("LdapAuthenticationMethod")});
        result.add(new String[]{UTIL.getString("LdapAuthenticationWidget.User.Label", new Object[0]), properties.getProperty("LdapAdminUserDN")});
        result.add(new String[]{UTIL.getString("LdapAuthenticationWidget.Password.Label", new Object[0]), properties.getProperty("LdapAdminUserPassword")});
        return result;
    }
}

