/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.wizards;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.UiConstants;
import org.teiid.designer.extension.ui.wizards.CurrentModelExtensionDefnsPage;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizard;

public class ManageModelExtensionDefnsWizard
extends AbstractWizard {
    protected CurrentModelExtensionDefnsPage currentModelExtensionDefnsPage;
    private MultiStatus status;
    private IWizardPage[] wizardPageArray;
    public ModelResource selectedModelResource;

    public ManageModelExtensionDefnsWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), Messages.manageMedsWizardTitle, null);
        this.setNeedsProgressMonitor(false);
    }

    public void addPages() {
        this.currentModelExtensionDefnsPage = new CurrentModelExtensionDefnsPage(this.selectedModelResource);
        this.addPage((IWizardPage)this.currentModelExtensionDefnsPage);
    }

    public boolean finish() {
        boolean success;
        block9: {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    ManageModelExtensionDefnsWizard.this.doFinish(monitor);
                }
            };
            success = false;
            boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)this.getWindowTitle(), (Object)((Object)this));
            try {
                try {
                    new ProgressMonitorDialog(this.getShell()).run(false, false, op);
                    success = true;
                }
                catch (Throwable err) {
                    ModelerCore.Util.log(4, err, err.getMessage());
                    if (startedTxn) {
                        ModelerCore.commitTxn();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (startedTxn) {
                    ModelerCore.commitTxn();
                }
                throw throwable;
            }
            if (startedTxn) {
                ModelerCore.commitTxn();
            }
        }
        MultiStatus status = this.getStatus();
        if (!success || !status.isOK()) {
            WidgetUtil.showError((String)Messages.manageMedsWizardErrorMsg);
            return false;
        }
        return true;
    }

    public void doFinish(IProgressMonitor monitor) {
        boolean hasErrors = false;
        if (this.currentModelExtensionDefnsPage == null) {
            this.addStatus(4, Messages.manageMedsWizardInitError, null);
            return;
        }
        ModelResource modelResource = this.currentModelExtensionDefnsPage.getSelectedModelResource();
        if (modelResource == null) {
            this.addStatus(4, Messages.manageMedsWizardInitError, null);
            return;
        }
        monitor.beginTask(Messages.manageMedsWizardUpdateMedsMsg, 400);
        List<String> namespacesToRemove = this.currentModelExtensionDefnsPage.getNamespacesToRemove();
        if (namespacesToRemove.size() > 0) {
            for (String namespacePrefix : namespacesToRemove) {
                try {
                    monitor.subTask(Messages.manageMedsWizardRemoveMedsMsg);
                    ModelExtensionAssistant assistant = ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(namespacePrefix);
                    if (assistant == null) {
                        assistant = ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant(namespacePrefix);
                    }
                    assert (assistant instanceof ModelObjectExtensionAssistant) : "ModelExtensionAssistant is not a ModelObjectExtensionAssistant";
                    ((ModelObjectExtensionAssistant)assistant).removeModelExtensionDefinition((Object)modelResource);
                }
                catch (Exception e) {
                    hasErrors = true;
                    this.addStatus(4, Messages.manageMedsWizardRemoveMedsError, e);
                    ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                }
            }
        }
        monitor.worked(100);
        List<ModelExtensionDefinition> medsToAdd = this.currentModelExtensionDefnsPage.getModelExtensionDefnsToAdd();
        if (medsToAdd.size() > 0) {
            for (ModelExtensionDefinition med : medsToAdd) {
                try {
                    monitor.subTask(Messages.manageMedsWizardAddMedsMsg);
                    ModelExtensionAssistant assistant = med.getModelExtensionAssistant();
                    assert (assistant instanceof ModelObjectExtensionAssistant) : "assistant is not a model object assistant";
                    ((ModelObjectExtensionAssistant)assistant).saveModelExtensionDefinition((Object)modelResource);
                }
                catch (Exception e) {
                    hasErrors = true;
                    this.addStatus(4, Messages.manageMedsWizardAddMedsError, e);
                    ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                }
            }
        }
        monitor.worked(100);
        List<String> namespacesToUpdate = this.currentModelExtensionDefnsPage.getNamespacesToUpdate();
        if (!namespacesToUpdate.isEmpty()) {
            monitor.subTask(Messages.manageMedsWizardUpdateMedsMsg);
            ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
            for (String namespacePrefix : namespacesToUpdate) {
                ModelExtensionAssistant assistant = registry.getModelExtensionAssistant(namespacePrefix);
                if (assistant == null) {
                    assistant = ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant(namespacePrefix);
                }
                if (assistant instanceof ModelObjectExtensionAssistant) {
                    try {
                        ((ModelObjectExtensionAssistant)assistant).saveModelExtensionDefinition((Object)modelResource);
                    }
                    catch (Exception e) {
                        hasErrors = true;
                        this.addStatus(4, Messages.manageMedsWizardUpdateMedsError, e);
                        ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                    }
                    continue;
                }
                ModelerCore.Util.log(4, Messages.manageMedsWizardModelObjectExtensionAssistantNotFound);
            }
        }
        monitor.worked(100);
        try {
            monitor.subTask(Messages.manageMedsWizardSaveModelMsg);
            modelResource.save((IProgressMonitor)new NullProgressMonitor(), true);
        }
        catch (ModelWorkspaceException e) {
            hasErrors = true;
            this.addStatus(4, Messages.manageMedsWizardSaveModelError, e);
            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
        }
        monitor.worked(100);
        monitor.done();
        if (!hasErrors) {
            this.addStatus(0, Messages.manageMedsWizardSuccessMsg, null);
        }
    }

    public MultiStatus getStatus() {
        if (this.status == null) {
            this.status = new MultiStatus(UiConstants.PLUGIN_ID, 0, Messages.manageMedsWizardResult, null);
        }
        return this.status;
    }

    private void addStatus(int severity, String message, Throwable ex) {
        Status sts = new Status(severity, UiConstants.PLUGIN_ID, 0, message, ex);
        this.getStatus().add((IStatus)sts);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            this.selectedModelResource = (ModelResource)SelectionUtilities.getSelectedObjects((ISelection)selection).get(0);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.currentModelExtensionDefnsPage) {
            return null;
        }
        int i = 0;
        while (i < this.wizardPageArray.length) {
            if (this.wizardPageArray[i] == page && i + 1 < this.wizardPageArray.length) {
                return this.wizardPageArray[i + 1];
            }
            ++i;
        }
        return null;
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.currentModelExtensionDefnsPage) {
            result = currentPage.isPageComplete();
        } else {
            boolean lastPage = currentPage == this.wizardPageArray[this.wizardPageArray.length - 1];
            result = lastPage && currentPage.isPageComplete();
        }
        return result;
    }

    public int getPageCount() {
        if (this.wizardPageArray != null) {
            return this.wizardPageArray.length + 1;
        }
        return 1;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.wizardPageArray == null || page == this.currentModelExtensionDefnsPage) {
            return null;
        }
        if (page == this.wizardPageArray[0]) {
            return this.currentModelExtensionDefnsPage;
        }
        int i = 1;
        while (i < this.wizardPageArray.length) {
            if (page == this.wizardPageArray[i]) {
                return this.wizardPageArray[i - 1];
            }
            ++i;
        }
        return null;
    }
}

