/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.editors;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.definition.MedStatus;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionValidator;
import org.teiid.designer.extension.definition.ValidationStatus;
import org.teiid.designer.extension.ui.Activator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.UiConstants;
import org.teiid.designer.extension.ui.editors.ErrorMessage;
import org.teiid.designer.extension.ui.editors.MedEditorPage;
import org.teiid.designer.extension.ui.editors.MedSelectionProvider;
import org.teiid.designer.extension.ui.editors.MedSelectionSynchronizer;
import org.teiid.designer.extension.ui.editors.ModelExtensionDefinitionEditor;
import org.teiid.designer.extension.ui.model.MedModelNode;
import org.teiid.designer.ui.forms.MessageFormDialog;

public final class OverviewEditorPage
extends MedEditorPage {
    private Text txtNamespacePrefix;
    private Text txtNamespaceUri;
    private CCombo cbxMetamodelUris;
    private Text txtDescription;
    private Text txtVersion;
    private TableViewer modelTypesViewer;
    private final ErrorMessage descriptionError = new ErrorMessage();
    private final ErrorMessage metamodelUriError;
    private final ErrorMessage modelTypesError;
    private final ErrorMessage namespacePrefixError;
    private final ErrorMessage namespaceUriError;

    public OverviewEditorPage(ModelExtensionDefinitionEditor medEditor) {
        super(medEditor, UiConstants.EditorIds.MED_OVERVIEW_PAGE, Messages.medEditorOverviewPageTitle);
        this.validateDescription();
        this.metamodelUriError = new ErrorMessage();
        this.validateMetamodelUri();
        this.modelTypesError = new ErrorMessage();
        this.validateModelTypes();
        this.namespacePrefixError = new ErrorMessage();
        this.validateNamespacePrefix();
        this.namespaceUriError = new ErrorMessage();
        this.validateNamespaceUri();
    }

    MedEditorPage accessPage() {
        return this;
    }

    @Override
    protected void createBody(Composite body, FormToolkit toolkit) {
        body.setLayout((Layout)new GridLayout());
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        Section section = toolkit.createSection(body, 12544);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        Section finalSection = section;
        Composite container = toolkit.createComposite((Composite)finalSection);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        finalSection.setClient((Control)container);
        Composite finalContainer = container;
        toolkit.createLabel(finalContainer, Messages.namespacePrefixLabel);
        this.txtNamespacePrefix = toolkit.createText(finalContainer, "", 2048);
        this.txtNamespacePrefix.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtNamespacePrefix.setToolTipText(Messages.medNamespacePrefixTooltip);
        this.refreshNamespacePrefixControl();
        this.txtNamespacePrefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OverviewEditorPage.this.handleNamespacePrefixChanged(((Text)e.widget).getText());
            }
        });
        this.namespacePrefixError.setControl((Control)this.txtNamespacePrefix);
        toolkit.createLabel(finalContainer, Messages.namespaceUriLabel);
        this.txtNamespaceUri = toolkit.createText(finalContainer, "", 2048);
        this.txtNamespaceUri.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtNamespaceUri.setToolTipText(Messages.medNamespaceUriTooltip);
        this.refreshNamespaceUriControl();
        this.txtNamespaceUri.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OverviewEditorPage.this.handleNamespaceUriChanged(((Text)e.widget).getText());
            }
        });
        this.namespaceUriError.setControl((Control)this.txtNamespaceUri);
        toolkit.createLabel(finalContainer, Messages.extendedMetamodelUriLabel);
        this.cbxMetamodelUris = new CCombo(finalContainer, 0x800808);
        toolkit.adapt((Control)this.cbxMetamodelUris, true, false);
        this.cbxMetamodelUris.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.cbxMetamodelUris.getLayoutData()).heightHint = this.cbxMetamodelUris.getItemHeight() + 4;
        Set<String> metamodelNames = Activator.getDefault().getExtendableMetamodelNames();
        this.cbxMetamodelUris.setItems(metamodelNames.toArray(new String[metamodelNames.size()]));
        this.cbxMetamodelUris.setToolTipText(Messages.medMetamodelClassTooltip);
        this.refreshMetamodelUriControl();
        this.cbxMetamodelUris.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OverviewEditorPage.this.handleMetamodelUriChanged(((CCombo)e.widget).getText());
            }
        });
        this.metamodelUriError.setControl((Control)this.cbxMetamodelUris);
        Label label = toolkit.createLabel(finalContainer, Messages.modelTypesLabel);
        label.setLayoutData((Object)new GridData(1, 128, false, false));
        Table table = toolkit.createTable(finalContainer, 2818);
        table.setLayoutData((Object)new GridLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * 4;
        table.setToolTipText(Messages.medModelTypesToolTip);
        this.modelTypesError.setControl((Control)table);
        this.modelTypesViewer = new TableViewer(table);
        this.modelTypesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return OverviewEditorPage.this.getAvailableModelTypes();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.modelTypesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String modelType = (String)element;
                return Activator.getDefault().getModelTypeName(modelType);
            }
        });
        this.modelTypesViewer.setInput((Object)this);
        this.refreshModelTypesControl();
        this.modelTypesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OverviewEditorPage.this.handleModelTypeSelected();
            }
        });
        toolkit.createLabel(finalContainer, Messages.versionLabel);
        this.txtVersion = toolkit.createText(finalContainer, "", 2056);
        this.txtVersion.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtVersion.setToolTipText(Messages.medVersionTooltip);
        this.refreshVersionControl();
        label = toolkit.createLabel(finalContainer, Messages.descriptionLabel);
        label.setLayoutData((Object)new GridData(1, 128, false, false));
        this.txtDescription = toolkit.createText(finalContainer, "", 2882);
        this.txtDescription.setLayoutData((Object)new GridData(4, 4, true, true));
        this.txtDescription.setToolTipText(Messages.medDescriptionToolTip);
        this.refreshDescriptionControl();
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OverviewEditorPage.this.handleDescriptionChanged(((Text)e.widget).getText());
            }
        });
        this.descriptionError.setControl((Control)this.txtDescription);
        MedSelectionSynchronizer selectionSynchronizer = this.getMedEditor().getSelectionSynchronizer();
        selectionSynchronizer.addSelectionProvider(new HeaderSelectionProvider((Control)this.txtNamespacePrefix, (Control)this.txtNamespaceUri, (Control)this.cbxMetamodelUris, this.modelTypesViewer.getControl(), (Control)this.txtVersion, (Control)this.txtDescription));
        IMessageManager msgMgr = ((ModelExtensionDefinitionEditor)this.getEditor()).getMessageManager();
        msgMgr.removeMessage(this.descriptionError.getKey());
        msgMgr.removeMessage(this.metamodelUriError.getKey());
        msgMgr.removeMessage(this.namespacePrefixError.getKey());
        msgMgr.removeMessage(this.namespaceUriError.getKey());
    }

    Object[] getAvailableModelTypes() {
        String metamodelUri = this.getMed().getMetamodelUri();
        if (CoreStringUtil.isEmpty((String)metamodelUri)) {
            return CoreStringUtil.Constants.EMPTY_STRING_ARRAY;
        }
        return Activator.getDefault().getModelTypes(metamodelUri).toArray();
    }

    public String getTitleToolTip() {
        return Messages.medEditorOverviewPageToolTip;
    }

    void handleDescriptionChanged(String newDescription) {
        this.getMed().setDescription(newDescription);
    }

    @Override
    public void handleMedReloaded() {
        if (this.txtNamespacePrefix != null) {
            this.refreshNamespacePrefixControl();
            this.refreshNamespaceUriControl();
            this.refreshMetamodelUriControl();
            this.refreshModelTypesControl();
            this.refreshVersionControl();
            this.refreshDescriptionControl();
        }
    }

    void handleMetamodelUriChanged(String newMetamodelName) {
        String oldUri = this.getMed().getMetamodelUri();
        String newMetamodelUri = Activator.getDefault().getMetamodelUri(newMetamodelName);
        if (CoreStringUtil.valuesAreEqual((String)newMetamodelUri, (String)oldUri)) {
            return;
        }
        boolean doIt = true;
        if (!CoreStringUtil.isEmpty((String)oldUri) && this.getMed().getExtendedMetaclasses().length != 0 && !MessageFormDialog.openQuestion((Shell)this.getShell(), (String)Messages.changeMetamodelDialogTitle, (Image)Activator.getDefault().getImage("icons/model-extension-definition-editor.png"), (String)Messages.changeMetamodelDialogMsg)) {
            doIt = false;
        }
        if (doIt) {
            this.getMed().setMetamodelUri(newMetamodelUri);
            this.refreshModelTypesControl();
        } else if (!CoreStringUtil.isEmpty((String)oldUri)) {
            String oldMetamodelName = Activator.getDefault().getMetamodelName(oldUri);
            this.cbxMetamodelUris.setText(oldMetamodelName);
        }
    }

    void handleModelTypeSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.modelTypesViewer.getSelection();
        Set modelTypes = this.getMed().getSupportedModelTypes();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedModelType = objectArray[n2];
            if (!modelTypes.contains(selectedModelType)) {
                this.getMed().addModelType((String)selectedModelType);
            }
            ++n2;
        }
        ArrayList supportedModelTypes = new ArrayList(this.getMed().getSupportedModelTypes());
        for (String modelType : supportedModelTypes) {
            boolean found = false;
            Object[] objectArray2 = selection.toArray();
            int n3 = objectArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Object selectedModelType = objectArray2[n4];
                if (modelType.equals(selectedModelType)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            if (found) continue;
            this.getMed().removeModelType(modelType);
        }
    }

    void handleNamespacePrefixChanged(String newNamespacePrefix) {
        this.getMed().setNamespacePrefix(newNamespacePrefix);
    }

    void handleNamespaceUriChanged(String newNamespaceUri) {
        this.getMed().setNamespaceUri(newNamespaceUri);
    }

    @Override
    protected void handlePropertyChanged(PropertyChangeEvent e) {
        String propName = e.getPropertyName();
        if (ModelExtensionDefinition.PropertyName.DESCRIPTION.toString().equals(propName)) {
            this.validateDescription();
        } else if (ModelExtensionDefinition.PropertyName.METAMODEL_URI.toString().equals(propName)) {
            this.validateMetamodelUri();
        } else if (ModelExtensionDefinition.PropertyName.NAMESPACE_PREFIX.toString().equals(propName)) {
            this.validateNamespacePrefix();
        } else if (ModelExtensionDefinition.PropertyName.NAMESPACE_URI.toString().equals(propName)) {
            this.validateNamespaceUri();
        }
    }

    private void refreshDescriptionControl() {
        String description = this.getMed().getDescription();
        if (!CoreStringUtil.valuesAreEqual((String)this.txtDescription.getText(), (String)description)) {
            this.txtDescription.setText(description == null ? "" : description);
            this.validateDescription();
        }
    }

    private void refreshModelTypesControl() {
        this.modelTypesViewer.refresh();
        Set supportedModelTypes = this.getMed().getSupportedModelTypes();
        if (supportedModelTypes.isEmpty()) {
            this.modelTypesViewer.getTable().selectAll();
        } else {
            this.modelTypesViewer.setSelection((ISelection)new StructuredSelection(supportedModelTypes.toArray()), true);
        }
    }

    private void refreshMetamodelUriControl() {
        String metamodelUri = this.getMed().getMetamodelUri();
        int currentIndex = this.cbxMetamodelUris.getSelectionIndex();
        int newIndex = -1;
        if (!CoreStringUtil.isEmpty((String)metamodelUri)) {
            String name = Activator.getDefault().getMetamodelName(metamodelUri);
            if (!CoreStringUtil.isEmpty((String)name)) {
                newIndex = this.cbxMetamodelUris.indexOf(name);
            }
            if (newIndex == -1) {
                UiConstants.UTIL.log((Object)NLS.bind((String)Messages.overviewPageInvalidMetamodelUriMsg, (Object)metamodelUri));
            }
        }
        if (newIndex != currentIndex) {
            if (newIndex == -1) {
                this.cbxMetamodelUris.setText("");
            } else {
                this.cbxMetamodelUris.select(newIndex);
            }
            this.validateMetamodelUri();
        }
    }

    private void refreshNamespacePrefixControl() {
        String namespacePrefix = this.getMed().getNamespacePrefix();
        if (!CoreStringUtil.valuesAreEqual((String)this.txtNamespacePrefix.getText(), (String)namespacePrefix)) {
            this.txtNamespacePrefix.setText(namespacePrefix == null ? "" : namespacePrefix);
            this.validateNamespacePrefix();
        }
    }

    private void refreshNamespaceUriControl() {
        String namespaceUri = this.getMed().getNamespaceUri();
        if (!CoreStringUtil.valuesAreEqual((String)this.txtNamespaceUri.getText(), (String)namespaceUri)) {
            this.txtNamespaceUri.setText(namespaceUri == null ? "" : namespaceUri);
            this.validateNamespaceUri();
        }
    }

    private void refreshVersionControl() {
        String version = Integer.toString(this.getMed().getVersion());
        if (!CoreStringUtil.valuesAreEqual((String)this.txtVersion.getText(), (String)version)) {
            this.txtVersion.setText(version);
        }
    }

    @Override
    protected void setResourceReadOnly(boolean readOnly) {
        if (this.cbxMetamodelUris == null) {
            return;
        }
        this.cbxMetamodelUris.setEnabled(!readOnly);
        this.txtDescription.setEnabled(!readOnly);
        this.txtNamespacePrefix.setEnabled(!readOnly);
        this.txtNamespaceUri.setEnabled(!readOnly);
        this.txtVersion.setEnabled(!readOnly);
        this.modelTypesViewer.getTable().setEnabled(!readOnly);
    }

    @Override
    protected void updateAllMessages() {
        this.validateDescription();
        this.validateMetamodelUri();
        this.validateNamespacePrefix();
        this.validateNamespaceUri();
    }

    private void validateDescription() {
        this.descriptionError.setStatus(ModelExtensionDefinitionValidator.validateDescription((String)this.getMed().getDescription()));
        this.updateMessage(this.descriptionError);
    }

    private void validateMetamodelUri() {
        this.metamodelUriError.setStatus(ModelExtensionDefinitionValidator.validateMetamodelUri((String)this.getMed().getMetamodelUri(), (Collection)this.getRegistry().getExtendableMetamodelUris()));
        this.updateMessage(this.metamodelUriError);
    }

    private void validateModelTypes() {
        String metamodelUri = this.getMed().getMetamodelUri();
        Set<Object> validModelTypes = CoreStringUtil.isEmpty((String)metamodelUri) ? Collections.emptySet() : Activator.getDefault().getModelTypes(metamodelUri);
        this.modelTypesError.setStatus(ModelExtensionDefinitionValidator.validateModelTypes((Collection)this.getMed().getSupportedModelTypes(), validModelTypes));
        this.updateMessage(this.modelTypesError);
    }

    private void validateNamespacePrefix() {
        if (this.getMed().isBuiltIn() || this.getMed().isImported()) {
            this.namespacePrefixError.setStatus((MedStatus)ValidationStatus.OK_STATUS);
        } else {
            this.namespacePrefixError.setStatus(ModelExtensionDefinitionValidator.validateNamespacePrefix((String)this.getMed().getNamespacePrefix(), (Collection)this.getRegistry().getAllNamespacePrefixes()));
        }
        this.updateMessage(this.namespacePrefixError);
    }

    private void validateNamespaceUri() {
        if (this.getMed().isBuiltIn() || this.getMed().isImported()) {
            this.namespaceUriError.setStatus((MedStatus)ValidationStatus.OK_STATUS);
        } else {
            this.namespaceUriError.setStatus(ModelExtensionDefinitionValidator.validateNamespaceUri((String)this.getMed().getNamespaceUri(), (Collection)this.getRegistry().getAllNamespaceUris()));
        }
        this.updateMessage(this.namespaceUriError);
    }

    class HeaderSelectionProvider
    implements MedSelectionProvider {
        private final Map<ModelExtensionDefinition.PropertyName, Control> controls;
        private ISelectionChangedListener listener;
        private ISelection currentSelection = StructuredSelection.EMPTY;

        public HeaderSelectionProvider(Control ctrlNamespacePrefix, Control ctrlNamespaceUri, Control ctrlMetamodelUri, Control ctrlModelTypes, Control ctrlVersion, Control ctrlDescription) {
            this.controls = new HashMap<ModelExtensionDefinition.PropertyName, Control>(5);
            MedSelectionSynchronizer selectionSynchronizer = OverviewEditorPage.this.getMedEditor().getSelectionSynchronizer();
            this.hookListener(ModelExtensionDefinition.PropertyName.NAMESPACE_PREFIX, ctrlNamespacePrefix, selectionSynchronizer);
            this.hookListener(ModelExtensionDefinition.PropertyName.NAMESPACE_URI, ctrlNamespaceUri, selectionSynchronizer);
            this.hookListener(ModelExtensionDefinition.PropertyName.METAMODEL_URI, ctrlMetamodelUri, selectionSynchronizer);
            this.hookListener(ModelExtensionDefinition.PropertyName.MODEL_TYPES, ctrlModelTypes, selectionSynchronizer);
            this.hookListener(ModelExtensionDefinition.PropertyName.VERSION, ctrlVersion, selectionSynchronizer);
            this.hookListener(ModelExtensionDefinition.PropertyName.DESCRIPTION, ctrlDescription, selectionSynchronizer);
        }

        ISelectionProvider accessThis() {
            return this;
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            assert (listener instanceof MedSelectionSynchronizer && this.listener == null) : "listener is not a MedSelectionSynchronizer";
            this.listener = listener;
        }

        ISelection createSelection(ModelExtensionDefinition.PropertyName propName, MedSelectionSynchronizer selectionSynchronizer) {
            MedModelNode medNode = null;
            if (ModelExtensionDefinition.PropertyName.NAMESPACE_PREFIX == propName) {
                medNode = selectionSynchronizer.getNamespacePrefixNode();
            } else if (ModelExtensionDefinition.PropertyName.NAMESPACE_URI == propName) {
                medNode = selectionSynchronizer.getNamespaceUriNode();
            } else if (ModelExtensionDefinition.PropertyName.METAMODEL_URI == propName) {
                medNode = selectionSynchronizer.getMetamodelUriNode();
            } else if (ModelExtensionDefinition.PropertyName.MODEL_TYPES == propName) {
                medNode = selectionSynchronizer.getModelTypesNode();
            } else if (ModelExtensionDefinition.PropertyName.DESCRIPTION == propName) {
                medNode = selectionSynchronizer.getDescriptionNode();
            } else if (ModelExtensionDefinition.PropertyName.VERSION == propName) {
                medNode = selectionSynchronizer.getVersionNode();
            }
            assert (medNode != null) : "medNode is null";
            return new StructuredSelection((Object)medNode);
        }

        @Override
        public MedEditorPage getMedEditorPage() {
            return OverviewEditorPage.this.accessPage();
        }

        @Override
        public MedModelNode getSelectedNode(MedModelNode.ModelType type) {
            if (!this.currentSelection.isEmpty()) {
                MedModelNode modelNode = (MedModelNode)((IStructuredSelection)this.currentSelection).getFirstElement();
                if (modelNode.getType() == type) {
                    return modelNode;
                }
                if (MedModelNode.ModelType.MODEL_EXTENSION_DEFINITION == type) {
                    return modelNode.getMedNode();
                }
            }
            return null;
        }

        ISelectionChangedListener getSelectionListener() {
            return this.listener;
        }

        public ISelection getSelection() {
            return this.currentSelection;
        }

        private void hookListener(final ModelExtensionDefinition.PropertyName propName, Control control, final MedSelectionSynchronizer selectionSynchronizer) {
            this.controls.put(propName, control);
            control.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (HeaderSelectionProvider.this.getSelectionListener() != null) {
                        HeaderSelectionProvider.this.getSelectionListener().selectionChanged(new SelectionChangedEvent(HeaderSelectionProvider.this.accessThis(), HeaderSelectionProvider.this.createSelection(propName, selectionSynchronizer)));
                    }
                }
            });
            if (control.isFocusControl()) {
                this.currentSelection = this.createSelection(propName, selectionSynchronizer);
            }
        }

        @Override
        public boolean isApplicable(IStructuredSelection selection) {
            MedModelNode modelNode;
            Object selectedObject;
            return !selection.isEmpty() && (selectedObject = selection.getFirstElement()) instanceof MedModelNode && ((modelNode = (MedModelNode)selectedObject).isMed() || modelNode.isNamespacePrefix() || modelNode.isNamespaceUri() || modelNode.isDescription() || modelNode.isMetamodelUri() || modelNode.isVersion());
        }

        @Override
        public void refresh() {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listener = null;
        }

        public void setSelection(ISelection selection) {
            Object selectedObject;
            if (!selection.isEmpty() && selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof MedModelNode) {
                MedModelNode modelNode = (MedModelNode)selectedObject;
                if (modelNode.isNamespacePrefix() || modelNode.isMed()) {
                    OverviewEditorPage.this.ensureVisible(this.controls.get(ModelExtensionDefinition.PropertyName.NAMESPACE_PREFIX));
                } else if (modelNode.isNamespaceUri()) {
                    OverviewEditorPage.this.ensureVisible(this.controls.get(ModelExtensionDefinition.PropertyName.NAMESPACE_URI));
                } else if (modelNode.isDescription()) {
                    OverviewEditorPage.this.ensureVisible(this.controls.get(ModelExtensionDefinition.PropertyName.DESCRIPTION));
                } else if (modelNode.isMetamodelUri()) {
                    OverviewEditorPage.this.ensureVisible(this.controls.get(ModelExtensionDefinition.PropertyName.METAMODEL_URI));
                } else if (modelNode.isModelTypes()) {
                    OverviewEditorPage.this.ensureVisible(this.controls.get(ModelExtensionDefinition.PropertyName.MODEL_TYPES));
                } else if (modelNode.isVersion()) {
                    OverviewEditorPage.this.ensureVisible(this.controls.get(ModelExtensionDefinition.PropertyName.VERSION));
                }
            }
        }
    }
}

