/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.editors;

import java.beans.PropertyChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.extension.ui.editors.ErrorMessage;
import org.teiid.designer.extension.ui.editors.ModelExtensionDefinitionEditor;

public abstract class MedEditorPage
extends FormPage {
    protected MedEditorPage(ModelExtensionDefinitionEditor medEditor, String id, String title) {
        super((FormEditor)medEditor, id, title);
    }

    protected abstract void createBody(Composite var1, FormToolkit var2);

    protected final void createFormContent(IManagedForm managedForm) {
        this.createBody(managedForm.getForm().getBody(), managedForm.getToolkit());
        this.setResourceReadOnly(this.isReadonly());
        this.updateAllMessages();
    }

    protected void ensureVisible(Control c) {
        FormToolkit.ensureVisible((Control)c);
    }

    protected ModelExtensionDefinition getMed() {
        return this.getMedEditor().getMed();
    }

    protected ModelExtensionDefinitionEditor getMedEditor() {
        return (ModelExtensionDefinitionEditor)this.getEditor();
    }

    protected ModelExtensionRegistry getRegistry() {
        return ExtensionPlugin.getInstance().getRegistry();
    }

    protected IFile getFile() {
        return this.getMedEditor().getFile();
    }

    protected Shell getShell() {
        return this.getSite().getShell();
    }

    public abstract void handleMedReloaded();

    protected abstract void handlePropertyChanged(PropertyChangeEvent var1);

    protected boolean isReadonly() {
        return this.getMedEditor().isReadOnly();
    }

    public void setFocus() {
        super.setFocus();
        if (this.getManagedForm() != null) {
            this.getManagedForm().refresh();
        }
    }

    protected abstract void setResourceReadOnly(boolean var1);

    protected abstract void updateAllMessages();

    protected void updateMessage(ErrorMessage errorMessage) {
        assert (errorMessage != null) : "errorMessage is null";
        IMessageManager msgMgr = ((ModelExtensionDefinitionEditor)this.getEditor()).getMessageManager();
        if (errorMessage.getControl() == null) {
            if (errorMessage.isOk()) {
                msgMgr.removeMessage(errorMessage.getKey());
            } else {
                msgMgr.addMessage(errorMessage.getKey(), errorMessage.getMessage(), errorMessage.getData(), errorMessage.getMessageType());
            }
        } else {
            errorMessage.update(msgMgr);
        }
    }
}

