/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.core.status;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.teiid.designer.advisor.ui.core.status.IStatusRowProvider;

public class StatusRow {
    private IStatusRowProvider rowProvider;
    private Label image;
    private Label label;
    private ImageHyperlink link;
    private Color dimFGColor;
    private Color defFGColor;

    public StatusRow(IStatusRowProvider rowProvider, FormToolkit toolkit, Composite body, IHyperlinkListener listener) {
        this.rowProvider = rowProvider;
        this.image = toolkit.createLabel(body, null);
        this.image.setImage(rowProvider.getImage(null));
        this.label = toolkit.createLabel(body, rowProvider.getText(null), 0);
        this.link = toolkit.createImageHyperlink(body, 64);
        this.link.setImage(rowProvider.getLinkImage(null));
        this.link.addHyperlinkListener(listener);
        this.link.setData((Object)rowProvider.getId());
        this.dimFGColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER");
        this.defFGColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_FG");
    }

    public void update(IStatus status) {
        if (this.isNotDisposed()) {
            this.image.setImage(this.rowProvider.getImage(status));
            this.image.setToolTipText(this.rowProvider.getImageTooltip(status));
            this.label.setText(this.rowProvider.getText(status));
            this.label.setToolTipText(this.rowProvider.getTextTooltip(status));
            this.link.setImage(this.rowProvider.getLinkImage(status));
            this.link.setToolTipText(this.rowProvider.getLinkTooltip(status));
            this.redraw();
        }
    }

    public void dim() {
        if (this.isNotDisposed()) {
            this.label.setForeground(this.dimFGColor);
        }
    }

    public void brighten() {
        if (this.isNotDisposed()) {
            this.label.setForeground(this.defFGColor);
        }
    }

    public void redraw() {
        if (this.isNotDisposed()) {
            this.image.redraw();
            this.label.redraw();
            this.link.redraw();
        }
    }

    private boolean isNotDisposed() {
        return !this.image.isDisposed() && !this.label.isDisposed() && !this.link.isDisposed();
    }
}

