/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.datatools.views;

import java.io.IOException;
import java.io.StringReader;
import java.util.Stack;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.datatools.connectivity.ui.Activator;
import org.teiid.datatools.connectivity.ui.Messages;
import org.teiid.datatools.views.ExecutionPlan;
import org.teiid.datatools.views.PlanAttribute;
import org.teiid.datatools.views.PlanElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class ExecutionPlanParser {
    public static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    public static final String VALUE_ELEM = "value";
    public static final String PROPERTY_ELEM = "property";
    public static final String NODE_ELEM = "node";
    public static final String NAME_ATTR = "name";
    private ExecutionPlan executionPlan;

    public IStatus parse(String xmlString) {
        InputSource inputSource = new InputSource(new StringReader(xmlString));
        return this.internalParse(inputSource);
    }

    private IStatus internalParse(InputSource inputSource) {
        String message;
        boolean parseError = false;
        this.executionPlan = null;
        Handler contentHandler = new Handler();
        SAXParser reader = new SAXParser();
        reader.setErrorHandler(null);
        reader.setContentHandler(contentHandler);
        try {
            reader.setFeature(VALIDATION_FEATURE, true);
            reader.parse(inputSource);
        }
        catch (SAXNotRecognizedException e) {
            parseError = true;
            String message2 = Messages.getString("ExecutionPlanParser.parseError");
            Status status = new Status(4, "org.teiid.datatools.connectivity.ui", message2, (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        catch (SAXNotSupportedException e) {
            parseError = true;
            String message3 = Messages.getString("ExecutionPlanParser.parseError");
            Status status = new Status(4, "org.teiid.datatools.connectivity.ui", message3, (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        catch (IOException e) {
            parseError = true;
            String message4 = Messages.getString("ExecutionPlanParser.ioError");
            Status status = new Status(4, "org.teiid.datatools.connectivity.ui", message4, (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        catch (SAXException e) {
            parseError = true;
            String message5 = Messages.getString("ExecutionPlanParser.parseError");
            Status status = new Status(4, "org.teiid.datatools.connectivity.ui", message5, (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        if (parseError) {
            this.executionPlan = new ExecutionPlan(null);
            message = Messages.getString("ExecutionPlanParser.parseError");
            return new Status(4, "org.teiid.datatools.connectivity.ui", message);
        }
        this.executionPlan = new ExecutionPlan(contentHandler.getRootElement());
        message = Messages.getString("ExecutionPlanParser.parseSuccessful");
        return new Status(0, "org.teiid.datatools.connectivity.ui", message);
    }

    public ExecutionPlan getExecutionPlan() {
        return this.executionPlan;
    }

    class Handler
    extends DefaultHandler {
        private static final String VALUE_ELEM = "value";
        private StringBuffer sbuffer = new StringBuffer();
        private Stack<String> elements = new Stack();
        private PlanElement rootElement;
        private PlanElement parentElement;

        public Handler() {
            this.setDocumentLocator(new LocatorImpl());
        }

        @Override
        public void startElement(String uri, String lName, String qName, Attributes attributes) throws SAXException {
            this.elements.push(qName);
            if (this.rootElement == null) {
                this.rootElement = new PlanElement(qName);
                this.rootElement.setRoot(true);
                if (attributes != null) {
                    int attributeLength = attributes.getLength();
                    int i = 0;
                    while (i < attributeLength) {
                        String value = attributes.getValue(i);
                        String localName = attributes.getLocalName(i);
                        this.rootElement.addChildAttribute(new PlanAttribute(localName, value));
                        ++i;
                    }
                }
                this.parentElement = this.rootElement;
            } else {
                PlanElement newElement = new PlanElement(qName);
                if (attributes != null) {
                    int attributeLength = attributes.getLength();
                    int i = 0;
                    while (i < attributeLength) {
                        String value = attributes.getValue(i);
                        String localName = attributes.getLocalName(i);
                        newElement.addChildAttribute(new PlanAttribute(localName, value));
                        ++i;
                    }
                }
                this.parentElement.addChildElement(newElement);
                this.parentElement = newElement;
            }
            this.sbuffer.setLength(0);
            super.startElement(uri, lName, qName, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String currentElem = this.getCurrentElement();
            if ("value".equals(currentElem)) {
                this.parentElement.setValue(this.sbuffer.toString());
            }
            this.parentElement = this.parentElement.getParent();
            this.elements.pop();
            super.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.sbuffer.append(ch, start, length);
            super.characters(ch, start, length);
        }

        private String getCurrentElement() {
            if (this.elements.empty()) {
                return null;
            }
            return this.elements.peek();
        }

        public PlanElement getRootElement() {
            return this.rootElement;
        }
    }
}

