/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.workspace.ModelWorkspaceNotification;
import org.teiid.designer.core.workspace.ResourceChangeUtilities;

public class ModelWorkspaceNotificationImpl
extends NotificationImpl
implements ModelWorkspaceNotification {
    protected final IResourceDelta delta;
    protected final Object notifier;
    protected final IResourceChangeEvent event;
    private boolean isRename = false;

    public ModelWorkspaceNotificationImpl(int eventType, IResourceDelta delta, IResourceChangeEvent event) {
        super(eventType, null, (Object)delta);
        CoreArgCheck.isNotNull((Object)event);
        this.delta = delta;
        this.event = event;
        this.notifier = delta != null ? delta.getResource() : event.getResource();
    }

    public IResourceChangeEvent getChangeEvent() {
        return this.event;
    }

    @Override
    public IResourceDelta getDelta() {
        return this.delta;
    }

    @Override
    public boolean isRename() {
        return this.isRename;
    }

    public void setIsRename(boolean isRename) {
        this.isRename = isRename;
    }

    @Override
    public boolean isAutoBuild() {
        return ResourceChangeUtilities.isAutoBuild(this.event);
    }

    @Override
    public boolean isPreAutoBuild() {
        return ResourceChangeUtilities.isPreAutoBuild(this.event);
    }

    public Object getNotifier() {
        return this.notifier;
    }

    @Override
    public boolean isPostAutoBuild() {
        return ResourceChangeUtilities.isPostAutoBuild(this.event);
    }

    @Override
    public boolean isPostChange() {
        return ResourceChangeUtilities.isPostChange(this.event);
    }

    @Override
    public boolean isPreClose() {
        return ResourceChangeUtilities.isPreClose(this.event);
    }

    @Override
    public boolean isPreDelete() {
        return ResourceChangeUtilities.isPreDelete(this.event);
    }

    @Override
    public boolean isOpen() {
        return ResourceChangeUtilities.isOpened(this.delta);
    }

    @Override
    public boolean isClose() {
        return this.getEventType() == 52;
    }

    @Override
    public boolean isPreNotification() {
        return ResourceChangeUtilities.isPreEvent(this.event);
    }

    @Override
    public boolean isFile() {
        return ResourceChangeUtilities.isFile(this.delta);
    }

    @Override
    public boolean isFolder() {
        return ResourceChangeUtilities.isFolder(this.delta);
    }

    @Override
    public boolean isProject() {
        return ResourceChangeUtilities.isProject(this.delta) || this.notifier instanceof IProject;
    }

    public String toString() {
        String typeString = this.getNotificationTypePhrase();
        String resourceType = " ";
        if (this.delta != null && this.delta.getResource() != null) {
            if (this.delta.getResource() instanceof IProject) {
                resourceType = " Project Notification: ";
            } else if (this.delta.getResource() instanceof IFile) {
                resourceType = " File Notification: ";
            } else if (this.delta.getResource() instanceof IFolder) {
                resourceType = " Folder Notification: ";
            }
        }
        StringBuffer toString = new StringBuffer(typeString);
        toString.append(resourceType);
        toString.append(" on ");
        toString.append(this.getNotifier());
        toString.append("\nisPreAutoBuild = " + this.isPreAutoBuild());
        toString.append("\nisPostAutoBuild = " + this.isPostAutoBuild());
        toString.append("\nisAutoBuild = " + this.isAutoBuild());
        toString.append("\nisRename = " + this.isRename());
        toString.append("\nisClose = " + this.isClose());
        toString.append("\nisOpen = " + this.isOpen());
        toString.append("\nisFile = " + this.isFile());
        toString.append("\nisFolder = " + this.isFolder());
        toString.append("\nisProject = " + this.isProject());
        toString.append("\nisPostChange = " + this.isPostChange());
        return toString.toString();
    }

    public String getNotificationTypePhrase() {
        String typeString = null;
        int type = this.getEventType();
        switch (type) {
            case 3: {
                typeString = "Add";
                break;
            }
            case 50: {
                typeString = "Change";
                break;
            }
            case 7: {
                typeString = "Move";
                break;
            }
            case 4: {
                typeString = "Remove";
                break;
            }
            case 1: {
                typeString = "Set";
                break;
            }
            case 52: {
                typeString = "Closing";
                break;
            }
            case 51: {
                typeString = "Open";
                break;
            }
            default: {
                typeString = "Unknown Type";
            }
        }
        return typeString;
    }
}

