/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.IOperation;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.search.ModelWorkspaceSearch;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.util.TransactionUtil;
import org.teiid.designer.core.workspace.DeltaProcessor;
import org.teiid.designer.core.workspace.ModelBufferManager;
import org.teiid.designer.core.workspace.ModelFolderImpl;
import org.teiid.designer.core.workspace.ModelFolderInfo;
import org.teiid.designer.core.workspace.ModelMarkerManager;
import org.teiid.designer.core.workspace.ModelProject;
import org.teiid.designer.core.workspace.ModelProjectImpl;
import org.teiid.designer.core.workspace.ModelProjectInfo;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelResourceImpl;
import org.teiid.designer.core.workspace.ModelResourceReloadVetoListener;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceCache;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceImpl;
import org.teiid.designer.core.workspace.ModelWorkspaceIndexManager;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceItemImpl;
import org.teiid.designer.core.workspace.ModelWorkspaceItemInfo;
import org.teiid.designer.core.workspace.ModelWorkspaceNotification;
import org.teiid.designer.core.workspace.ModelWorkspaceNotificationImpl;
import org.teiid.designer.core.workspace.ModelWorkspaceNotificationListener;
import org.teiid.designer.core.workspace.Openable;
import org.teiid.designer.core.workspace.SearchIndexResourceVisitor;
import org.teiid.designer.core.xmi.XMIHeader;

public class ModelWorkspaceManager
implements ModelUtil.XmiHeaderCache {
    public static boolean VERBOSE = false;
    public static boolean ZIP_ACCESS_VERBOSE = false;
    private static ModelWorkspaceManager manager;
    private final ModelWorkspaceImpl modelWorkspace = new ModelWorkspaceImpl();
    private final DeltaProcessor deltaProcessor;
    protected ModelWorkspaceCache cache = new ModelWorkspaceCache();
    protected Container container;
    private final Collection workspaceListeners = new ArrayList();
    private final Collection resourceReloadVetoListeners = new ArrayList();
    protected Map perProjectInfo = new HashMap(5);
    private int indexType = 0;
    private final ModelMarkerManager markerManager = new ModelMarkerManager();
    private final Map FileToxmlHeaderMap = Collections.synchronizedMap(new HashMap());
    private final ModelWorkspaceSearch modelWorkspaceSearch = new ModelWorkspaceSearch();
    private final ModelWorkspaceIndexManager indexManager = new ModelWorkspaceIndexManager();

    public static ModelResource create(IFile file, ModelProject project) {
        if (file == null || !ModelerCore.hasModelNature(file.getProject())) {
            return null;
        }
        if (project == null) {
            project = manager.getModelWorkspace().getModelProject((IResource)file);
        }
        if (file.getFileExtension() != null && ModelUtil.isModelFile((IResource)file)) {
            try {
                ModelResource resource = (ModelResource)project.findModelWorkspaceItem((IResource)file);
                if (resource != null) {
                    return resource;
                }
                resource = (ModelResource)ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem((IResource)file, true);
                return resource;
            }
            catch (ModelWorkspaceException modelWorkspaceException) {
                return null;
            }
        }
        return null;
    }

    public static ModelWorkspaceItem create(IFolder folder, ModelProject project) {
        if (project == null) {
            project = manager.getModelWorkspace().getModelProject((IResource)folder);
        }
        try {
            ModelWorkspaceItem folderItem = project.findModelWorkspaceItem((IResource)folder);
            if (folderItem != null) {
                return folderItem;
            }
            folderItem = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem((IResource)folder, true);
            return folderItem;
        }
        catch (ModelWorkspaceException modelWorkspaceException) {
            return null;
        }
    }

    public static ModelWorkspaceItem create(IResource resource, ModelProject project) {
        if (resource == null || resource.getProject() != null && !ModelerCore.hasModelNature(resource.getProject())) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return ModelerCore.create((IProject)resource);
            }
            case 1: {
                return ModelWorkspaceManager.create((IFile)resource, project);
            }
            case 2: {
                return ModelWorkspaceManager.create((IFolder)resource, project);
            }
            case 8: {
                return ModelerCore.create((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public static final ModelWorkspaceManager getModelWorkspaceManager() {
        if (manager == null) {
            manager = new ModelWorkspaceManager();
            try {
                IWorkspace workspace = ModelerCore.getWorkspace();
                workspace.addResourceChangeListener((IResourceChangeListener)manager.getDeltaProcessor(), 31);
                manager.initModelWorkspace(workspace);
            }
            catch (Throwable t) {
                t.printStackTrace();
                ModelerCore.Util.log(4, ModelerCore.Util.getString("ModelWorkspaceManager.Error_encountered_starting_ModelWorkspaceManager_1", new Object[0]));
            }
        }
        return manager;
    }

    public static final void shutdown() throws CoreException {
        if (manager != null) {
            try {
                try {
                    IWorkspace workspace = ModelerCore.getWorkspace();
                    workspace.removeResourceChangeListener((IResourceChangeListener)manager.getDeltaProcessor());
                    manager.shutdownManager();
                    manager.getIndexManager().disposeAll();
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new CoreException((IStatus)new Status(4, "org.teiid.designer.core", 1, ModelerCore.Util.getString("ModelWorkspaceManager.Error_encountered_shutting_down_ModelWorkspaceManager_2", new Object[0]), t));
                }
            }
            finally {
                manager = null;
            }
        }
    }

    private ModelWorkspaceManager() {
        this.deltaProcessor = new DeltaProcessor(this);
        try {
            this.addChangeNotifier(ModelerCore.getModelContainer());
        }
        catch (CoreException e) {
            ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("ModelWorkspaceManager.Error_adding_ChangeNotifier_to_the_model_container_{0}_1", (Object)e.getMessage()));
        }
    }

    private void add(IResource resource, ModelProjectImpl project) {
        ModelWorkspaceItem resourceItem = this.modelWorkspace.getWorkspaceItem(resource.getFullPath(), resource.getType());
        if (resourceItem != null) {
            return;
        }
        if (project == null) {
            project = new ModelProjectImpl(resource.getProject(), this.modelWorkspace);
        }
        ModelWorkspaceItem newResource = null;
        ModelWorkspaceItem parentItem = null;
        if (resource.getType() == 4) {
            newResource = project;
            parentItem = this.modelWorkspace;
        } else {
            try {
                if (ModelerCore.DEBUG_MODEL_WORKSPACE || ModelerCore.DEBUG_MODEL_WORKSPACE_EVENT) {
                    Object[] params = new Object[]{resource};
                    String debugMsg = ModelerCore.Util.getString("ModelWorkspaceManager.DEBUG.Creating_ModelResource_instance_for_0_2", params);
                    ModelerCore.Util.log(1, debugMsg);
                }
                if (resource.getType() == 1 && ((IFile)resource).getFileExtension() != null && ModelUtil.isModelFile(resource)) {
                    newResource = project.createModelResource((IFile)resource);
                } else if (resource.getType() == 2) {
                    newResource = project.createModelFolder((IFolder)resource);
                }
                parentItem = this.modelWorkspace.getParent(resource);
            }
            catch (Exception e) {
                ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("ModelWorkspaceManager.Error_creating_new_model_workspace_item___{0}_1", (Object)e.getMessage()));
            }
        }
        if (parentItem == null) {
            parentItem = this.modelWorkspace.getParent(resource);
            ModelerCore.Util.log(4, ModelerCore.Util.getString("ModelWorkspaceManager.Unable_to_find_parent_item_for_{0})_3", (Object)resource.getFullPath()));
            return;
        }
        ModelWorkspaceItemInfo parentInfo = this.getInfo(parentItem);
        if (parentInfo != null) {
            parentInfo.addChild(newResource);
        }
    }

    private void addChangeNotifier(Container container) {
        ChangeNotifier notifier;
        if (container != null && (notifier = container.getChangeNotifier()) != null) {
            notifier.addListener((INotifyChangedListener)new NotificationProcessor());
        }
    }

    public void addModelResourceReloadVetoListener(ModelResourceReloadVetoListener listener) {
        CoreArgCheck.isNotNull((Object)listener);
        if (this.resourceReloadVetoListeners.contains(listener)) {
            return;
        }
        this.resourceReloadVetoListeners.add(listener);
    }

    public void addNotificationListener(ModelWorkspaceNotificationListener listener) {
        CoreArgCheck.isNotNull((Object)listener);
        if (this.workspaceListeners.contains(listener)) {
            return;
        }
        this.workspaceListeners.add(listener);
    }

    public boolean canReload(ModelResource modelResource) {
        Collection listeners = this.getModelResourceReloadVetoListeners();
        if (listeners.size() != 0) {
            for (ModelResourceReloadVetoListener listener : this.getModelResourceReloadVetoListeners()) {
                boolean canReload = listener.canReload(modelResource);
                if (canReload) continue;
                return false;
            }
        }
        return true;
    }

    private boolean changeWorkspace(ModelWorkspaceNotification notification) throws CoreException {
        final IResource resource = (IResource)notification.getNotifier();
        IProject iProject = resource.getProject();
        if (iProject.exists() && iProject.isOpen() && !ModelerCore.hasModelNature(iProject)) {
            return false;
        }
        if (resource.getType() == 1) {
            if (!ModelUtil.isModelFile(resource, false) && !ModelUtil.isVdbArchiveFile(resource)) {
                return false;
            }
            this.setIndexType(0);
        } else if (resource.getType() != 4 && resource.getType() != 2) {
            return false;
        }
        ModelProjectImpl project = (ModelProjectImpl)this.modelWorkspace.findModelProject(resource);
        int eventType = ((ModelWorkspaceNotificationImpl)notification).getEventType();
        switch (eventType) {
            case 3: {
                this.add(resource, project);
                break;
            }
            case 4: {
                try {
                    TransactionUtil.executeNonUndoable(new IOperation(){

                        public void execute() throws CoreException {
                            ModelWorkspaceManager.this.remove(resource);
                        }
                    }, (Object)this);
                    break;
                }
                catch (CoreException err) {
                    throw err;
                }
                catch (Exception err) {
                    ModelerCore.Util.log((Throwable)err);
                    break;
                }
            }
            case 7: {
                break;
            }
            case 1: {
                IPath oldPath = notification.getDelta().getMovedFromPath();
                ModelWorkspaceItem oldItem = this.modelWorkspace.getWorkspaceItem(oldPath, resource.getType());
                if (oldItem == null || oldItem.getResource() == null) break;
                this.remove(oldItem.getResource());
                this.add(resource, project);
                break;
            }
            case 50: {
                ModelWorkspaceItem resourceItem;
                if (resource.getType() != 1 || (resourceItem = this.modelWorkspace.getWorkspaceItem(resource.getFullPath(), resource.getType())) == null || !(resourceItem instanceof ModelResourceImpl) || ModelUtil.isVdbArchiveFile(resourceItem.getCorrespondingResource())) break;
                ModelResourceImpl model = (ModelResourceImpl)resourceItem;
                return model.processContentsChange(notification);
            }
            case 51: {
                if (!(resource instanceof IProject)) break;
                if (project == null) {
                    project = new ModelProjectImpl((IProject)resource, this.modelWorkspace);
                    ModelWorkspaceItemInfo parentInfo = this.getInfo(this.modelWorkspace);
                    if (parentInfo != null) {
                        parentInfo.addChild(project);
                    }
                }
                project.open(null);
                break;
            }
            default: {
                throw new ModelerCoreException(String.valueOf(ModelerCore.Util.getString("ModelWorkspaceManager.Illegal_notification,_notification_type_not_recognized___1", new Object[0])) + eventType);
            }
        }
        return false;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public boolean deleteIndexes(IResource theResource) throws CoreException {
        return this.deleteIndexes(theResource, new SearchIndexResourceVisitor());
    }

    public boolean deleteIndexes(IResource theResource, SearchIndexResourceVisitor theVisitor) throws CoreException {
        theResource.accept((IResourceVisitor)theVisitor);
        File[] indexFiles = theVisitor.getIndexFiles();
        return IndexUtil.deleteIndexFiles(indexFiles, true);
    }

    public ModelResource findModelResource(Resource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        return ModelBufferManager.getDefaultBufferManager().getModelResource(resource);
    }

    public ModelWorkspaceItem findModelWorkspaceItem(IPath resourcePath, int resourceType) {
        CoreArgCheck.isNotNull((Object)resourcePath);
        return this.modelWorkspace.getWorkspaceItem(resourcePath, resourceType);
    }

    public ModelWorkspaceItem findModelWorkspaceItem(IResource resource) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)resource);
        if (resource.getProject().isOpen()) {
            return this.findModelWorkspaceItem(resource, false);
        }
        return null;
    }

    public ModelWorkspaceItem findModelWorkspaceItem(IResource resource, boolean createIfRequired) throws ModelWorkspaceException {
        ModelProject modelProject;
        CoreArgCheck.isNotNull((Object)resource);
        IProject proj = resource.getProject();
        if (!ModelerCore.hasModelNature(proj)) {
            return null;
        }
        IPath pathInProject = resource.getProjectRelativePath();
        ModelWorkspaceItem parent = modelProject = this.getModelWorkspace().getModelProject((IResource)proj);
        int numFolders = pathInProject.segmentCount();
        if (resource instanceof IFile) {
            if (!ModelUtil.isModelFile(resource)) {
                return null;
            }
            --numFolders;
        }
        int i = 0;
        while (i < numFolders) {
            String folderName = pathInProject.segment(i);
            ModelWorkspaceItem child = parent.getChild(folderName);
            if (child == null) {
                IFolder underlyingFolder = proj.getFolder(pathInProject.uptoSegment(i + 1));
                CoreArgCheck.isNotNull((Object)underlyingFolder);
                ModelFolderImpl newFolder = new ModelFolderImpl(underlyingFolder, parent);
                ModelWorkspaceItemInfo parentInfo = ((ModelWorkspaceItemImpl)parent).getItemInfo();
                if (parentInfo instanceof ModelFolderInfo) {
                    ((ModelFolderInfo)parentInfo).addChild(newFolder);
                    parent = newFolder;
                } else if (parentInfo instanceof ModelProjectInfo) {
                    ((ModelProjectInfo)parentInfo).addChild(newFolder);
                    parent = newFolder;
                }
            } else {
                parent = child;
            }
            ++i;
        }
        if (resource instanceof IFile) {
            ModelWorkspaceItem result = parent.getChild(resource);
            if (result == null && createIfRequired) {
                String name = resource.getName();
                result = new ModelResourceImpl(parent, name);
            }
            return result;
        }
        return parent;
    }

    public void fire(ModelWorkspaceNotification notification) throws CoreException {
        CoreArgCheck.isNotNull((Object)notification);
        IResourceDelta delta = notification.getDelta();
        int eventType = notification.getEventType();
        boolean reloadedResource = false;
        if (delta != null && notification.isPostChange()) {
            reloadedResource = this.changeWorkspace(notification);
        }
        if (notification.isPreDelete()) {
            reloadedResource = this.changeWorkspace(notification);
        }
        if (eventType == 52 && notification.isProject() && notification.getNotifier() instanceof IProject) {
            this.deleteIndexes((IResource)((IProject)notification.getNotifier()));
        }
        block9: for (ModelWorkspaceNotificationListener listener : this.getNotificationListeners()) {
            switch (eventType) {
                case 3: {
                    listener.notifyAdd(notification);
                    break;
                }
                case 4: {
                    listener.notifyRemove(notification);
                    break;
                }
                case 7: {
                    listener.notifyMove(notification);
                    break;
                }
                case 1: {
                    listener.notifyRename(notification);
                    break;
                }
                case 50: {
                    listener.notifyChanged(notification);
                    if (!reloadedResource) continue block9;
                    ModelWorkspaceNotificationImpl reloadedNotification = new ModelWorkspaceNotificationImpl(53, notification.getDelta(), ((ModelWorkspaceNotificationImpl)notification).getChangeEvent());
                    listener.notifyReloaded(reloadedNotification);
                    break;
                }
                case 51: {
                    listener.notifyOpen(notification);
                    break;
                }
                case 52: {
                    listener.notifyClosing(notification);
                    break;
                }
                default: {
                    throw new ModelerCoreException(String.valueOf(ModelerCore.Util.getString("ModelWorkspaceManager.Illegal_notification,_notification_type_not_recognized___1", new Object[0])) + eventType);
                }
            }
        }
    }

    @Override
    public XMIHeader getCachedXmiHeader(File resource) {
        XMIHeaderCachedObject headerCachedObject = (XMIHeaderCachedObject)this.FileToxmlHeaderMap.get(resource.getAbsolutePath());
        if (headerCachedObject != null) {
            if (!headerCachedObject.isModified(resource)) {
                return headerCachedObject.getXMIHeader();
            }
            this.FileToxmlHeaderMap.remove(resource.getAbsolutePath());
        }
        return null;
    }

    public DeltaProcessor getDeltaProcessor() {
        return this.deltaProcessor;
    }

    public ModelWorkspaceItem getHandleFromMemento(String memento) {
        if (memento == null) {
            return null;
        }
        ModelWorkspace modelWorkspace = this.getModelWorkspace();
        if (memento.equals("")) {
            return modelWorkspace;
        }
        return null;
    }

    public ModelWorkspaceIndexManager getIndexManager() {
        return this.indexManager;
    }

    public ModelWorkspaceItemInfo getInfo(ModelWorkspaceItem item) {
        return this.cache.getInfo(item);
    }

    public ModelMarkerManager getMarkerManager() {
        return this.markerManager;
    }

    public Container getModelContainer() throws CoreException {
        if (this.container == null) {
            this.container = ModelerCore.getModelContainer();
        }
        return this.container;
    }

    Collection getModelResourceReloadVetoListeners() {
        return new ArrayList(this.resourceReloadVetoListeners);
    }

    public ModelWorkspace getModelWorkspace() {
        return this.modelWorkspace;
    }

    public ModelWorkspaceSearch getModelWorkspaceSearch() {
        return this.modelWorkspaceSearch;
    }

    public Collection getNonIndexedResources(int indexType) throws CoreException {
        ModelProject[] projects;
        if (this.indexType == 3 || this.indexType == indexType) {
            return Collections.EMPTY_LIST;
        }
        this.setIndexType(indexType);
        class ResourceVisitor
        implements IResourceVisitor {
            Collection resources = new ArrayList();
            private final /* synthetic */ int val$indexType;

            ResourceVisitor(int n) {
                this.val$indexType = n;
            }

            public Collection getResources() {
                return this.resources;
            }

            public boolean visit(IResource resource) throws CoreException {
                ModelWorkspaceItem modelWorkspaceItem;
                if (resource != null && resource.getType() == 1 && (modelWorkspaceItem = ModelWorkspaceManager.this.findModelWorkspaceItem(resource)) != null && modelWorkspaceItem instanceof ModelResource) {
                    ModelResource mResource = (ModelResource)modelWorkspaceItem;
                    int modelIndexType = mResource.getIndexType();
                    switch (this.val$indexType) {
                        case 3: {
                            if (modelIndexType == 3) break;
                            this.resources.add(mResource.getResource());
                            break;
                        }
                        case 1: {
                            if (modelIndexType == 3 || modelIndexType == 1) break;
                            this.resources.add(mResource.getResource());
                            break;
                        }
                        case 2: {
                            if (modelIndexType == 3 || modelIndexType == 2) break;
                            this.resources.add(mResource.getResource());
                            break;
                        }
                    }
                }
                return true;
            }
        }
        ResourceVisitor visitor = new ResourceVisitor(indexType);
        ModelProject[] modelProjectArray = projects = ModelerCore.getModelWorkspace().getModelProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            ModelProject mProject = modelProjectArray[n2];
            if (mProject != null && mProject.isOpen()) {
                mProject.getProject().accept((IResourceVisitor)visitor);
            }
            ++n2;
        }
        return visitor.getResources();
    }

    Collection getNotificationListeners() {
        return new ArrayList(this.workspaceListeners);
    }

    private void initModelWorkspace(IWorkspace workspace) throws CoreException {
        CoreArgCheck.isNotNull((Object)workspace);
        ModelIResourceCollectorVisitor resourceVisitor = new ModelIResourceCollectorVisitor();
        workspace.getRoot().accept((IResourceVisitor)resourceVisitor);
        List resources = resourceVisitor.getResources();
        IResourceComparator comparator = new IResourceComparator();
        Collections.sort(resources, comparator);
        for (IResource resource : resources) {
            ModelWorkspaceItem workspaceItem = ModelWorkspaceManager.create(resource, null);
            if (resource.getType() != 4 && resource.getType() != 8 || !(workspaceItem instanceof Openable)) continue;
            ((Openable)((Object)workspaceItem)).open(null);
        }
        ModelUtil.setModelWorkspaceManagerInitialized();
    }

    public boolean isModelOpen(IResource theResource) {
        CoreArgCheck.isNotNull((Object)theResource);
        boolean result = false;
        if (ModelUtil.isModelFile(theResource, true)) {
            try {
                ModelWorkspaceItem item = this.findModelWorkspaceItem(theResource, false);
                if (item != null) {
                    result = this.getInfo(item) != null;
                }
            }
            catch (ModelWorkspaceException modelWorkspaceException) {}
        }
        return result;
    }

    public boolean modelExists(String containerPath, String modelName) {
        ModelWorkspaceItem item;
        if (containerPath == null) {
            return false;
        }
        IPath modelPath = new Path(containerPath).append(modelName);
        if (!modelPath.toString().toLowerCase().endsWith("xmi")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        return (item = this.findModelWorkspaceItem(modelPath, 1)) != null;
    }

    public void notifyClean(IProject project) {
        Collection listeners = this.getNotificationListeners();
        for (ModelWorkspaceNotificationListener listener : listeners) {
            listener.notifyClean(project);
        }
    }

    protected Object peekAtInfo(ModelWorkspaceItem item) {
        return this.cache.peekAtInfo(item);
    }

    public void putInfo(ModelWorkspaceItem item, ModelWorkspaceItemInfo info) {
        this.cache.putInfo(item, info);
    }

    void remove(IResource resource) throws CoreException {
        ModelWorkspaceItemInfo parentInfo;
        ModelWorkspaceItem parentItem;
        ModelWorkspaceItem resourceItem = this.modelWorkspace.getWorkspaceItem(resource.getFullPath(), resource.getType());
        this.removeResourcesRecursively(resource);
        if (resourceItem instanceof Openable) {
            ((Openable)((Object)resourceItem)).close();
        }
        if ((parentItem = this.modelWorkspace.getParent(resource)) != null && (parentInfo = this.getInfo(parentItem)) != null) {
            parentInfo.removeChild(resourceItem);
        }
    }

    public void removeAllModelResourceReloadVetoListeners() {
        this.resourceReloadVetoListeners.clear();
    }

    public void removeAllNotificationListeners() {
        this.workspaceListeners.clear();
    }

    public void removeInfo(ModelWorkspaceItem item) {
        this.cache.removeInfo(item);
    }

    public void removeModelResourceReloadVetoListener(ModelResourceReloadVetoListener listener) {
        CoreArgCheck.isNotNull((Object)listener);
        this.resourceReloadVetoListeners.remove(listener);
    }

    public void removeNotificationListener(ModelWorkspaceNotificationListener listener) {
        this.workspaceListeners.remove(listener);
    }

    private void removeResourcesRecursively(IResource resource) throws CoreException {
        CoreArgCheck.isNotNull((Object)resource);
        int resourceType = resource.getType();
        if (resource.getLocation() != null && resourceType == 1) {
            ModelWorkspaceItem resourceItem;
            String searchIndexFileName;
            File searchIndexFile;
            String runtimeIndexFileName = IndexUtil.getRuntimeIndexFileName(resource);
            File runtimeIndexFile = new File(IndexUtil.INDEX_PATH, runtimeIndexFileName);
            if (runtimeIndexFile.exists()) {
                this.getIndexManager().disposeIndex(runtimeIndexFileName);
            }
            if ((searchIndexFile = new File(IndexUtil.INDEX_PATH, searchIndexFileName = IndexUtil.getSearchIndexFileName(resource))).exists()) {
                this.getIndexManager().disposeIndex(searchIndexFileName);
            }
            if ((resourceItem = this.modelWorkspace.getWorkspaceItem(resource.getFullPath(), 1)) != null && resourceItem instanceof ModelResourceImpl) {
                ((ModelResourceImpl)resourceItem).removeEmfResource();
            }
            this.FileToxmlHeaderMap.remove(ModelUtil.getLocation(resource).toOSString());
        }
        if (resource.exists() && resource.isAccessible() && resourceType != 1) {
            class ResourceVisitor
            implements IResourceVisitor {
                List resources = new ArrayList();

                ResourceVisitor() {
                }

                public List getFileResources() {
                    return this.resources;
                }

                private boolean isIncludedResource(IResource resource) {
                    if (resource == null || !resource.exists()) {
                        return false;
                    }
                    return ModelUtil.isModelFile(resource) || ModelUtil.isXsdFile(resource) || ModelUtil.isVdbArchiveFile(resource);
                }

                public boolean visit(IResource resource) {
                    if (this.isIncludedResource(resource)) {
                        this.resources.add(resource);
                    }
                    return true;
                }
            }
            ResourceVisitor visitor = new ResourceVisitor();
            resource.accept((IResourceVisitor)visitor);
            List childResources = visitor.getFileResources();
            for (IResource child : childResources) {
                this.removeResourcesRecursively(child);
            }
        }
    }

    void setIndexType(int type) {
        this.indexType = type;
    }

    @Override
    public void setXmiHeaderToCache(File resource, XMIHeader header) {
        XMIHeaderCachedObject headerCachedObject = new XMIHeaderCachedObject(header, resource.lastModified());
        this.FileToxmlHeaderMap.put(resource.getAbsolutePath(), headerCachedObject);
    }

    private void shutdownManager() throws CoreException {
        if (this.container != null) {
            try {
                try {
                    if (ModelerCore.DEBUG_MODEL_WORKSPACE) {
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("ModelWorkspaceManager.DEBUG.Shutting_down_model_container", new Object[0]));
                    }
                    this.container.shutdown();
                    if (ModelerCore.DEBUG_MODEL_WORKSPACE) {
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("ModelWorkspaceManager.DEBUG.Completed_shuting_down_model_container", new Object[0]));
                    }
                }
                catch (ModelerCoreException e) {
                    throw new CoreException((IStatus)new Status(4, "org.teiid.designer.core", 1, ModelerCore.Util.getString("ModelWorkspaceManager.Error_shutting_down_the_model_container_2", new Object[0]), (Throwable)e));
                }
            }
            finally {
                this.container = null;
            }
        }
        if (this.workspaceListeners != null) {
            this.workspaceListeners.clear();
        }
        if (this.markerManager != null) {
            this.markerManager.dispose();
        }
    }

    private class IResourceComparator
    implements Comparator {
        public int compare(Object rsc1, Object rsc2) {
            CoreArgCheck.isInstanceOf(IResource.class, (Object)rsc1);
            CoreArgCheck.isInstanceOf(IResource.class, (Object)rsc2);
            IResource resource1 = (IResource)rsc1;
            IResource resource2 = (IResource)rsc2;
            return resource2.getType() - resource1.getType();
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject == this) {
                return true;
            }
            return anObject != null && anObject.getClass() == this.getClass();
        }
    }

    class ModelIResourceCollectorVisitor
    implements IResourceVisitor {
        List resources = new ArrayList();

        ModelIResourceCollectorVisitor() {
        }

        public List getResources() {
            return this.resources;
        }

        private boolean isIncludedResource(IResource resource) {
            if (resource == null || !resource.exists()) {
                return false;
            }
            if (resource.getType() == 4) {
                return ModelerCore.hasModelNature((IProject)resource);
            }
            if (resource.getType() == 1) {
                return ModelUtil.isModelFile(resource) || ModelUtil.isXsdFile(resource) || ModelUtil.isVdbArchiveFile(resource);
            }
            return true;
        }

        public boolean visit(IResource resource) {
            if (this.isIncludedResource(resource)) {
                this.resources.add(resource);
                if (resource.getType() != 1) {
                    return true;
                }
            }
            return false;
        }
    }

    class NotificationProcessor
    implements INotifyChangedListener {
        NotificationProcessor() {
        }

        private void checkResourceForIndexing(Notification notification) {
            Object target = notification.getNotifier();
            if (notification.isTouch()) {
                return;
            }
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.refreshResourceIndexType(target);
                }
            }
        }

        public void notifyChanged(Notification notification) {
            if (notification.isTouch()) {
                return;
            }
            if (notification instanceof SourcedNotification) {
                Collection chain = ((SourcedNotification)notification).getNotifications();
                for (Notification n : chain) {
                    this.checkResourceForIndexing(n);
                }
            } else {
                this.checkResourceForIndexing(notification);
            }
        }

        private void refreshResourceIndexType(Object obj) {
            ModelResource mResource;
            Resource eResource;
            if (obj == null) {
                return;
            }
            if (obj instanceof Resource && ((Resource)obj).isModified()) {
                ModelResource mResource2 = ModelWorkspaceManager.this.findModelResource((Resource)obj);
                if (mResource2 != null) {
                    if (mResource2.getIndexType() == 0) {
                        return;
                    }
                    mResource2.refreshIndexType();
                    ModelWorkspaceManager.this.setIndexType(0);
                }
            } else if (obj instanceof EObject && ((EObject)obj).eResource() != null && (eResource = ((EObject)obj).eResource()).isModified() && (mResource = ModelWorkspaceManager.this.findModelResource(eResource)) != null) {
                if (mResource.getIndexType() == 0) {
                    return;
                }
                mResource.setIndexType(0);
                ModelWorkspaceManager.this.setIndexType(0);
            }
        }
    }

    private class XMIHeaderCachedObject {
        private final XMIHeader header;
        private final long lastModified;

        XMIHeaderCachedObject(XMIHeader header, long lastModified) {
            this.header = header;
            this.lastModified = lastModified;
        }

        XMIHeader getXMIHeader() {
            return this.header;
        }

        boolean isModified(File file) {
            return file.lastModified() != this.lastModified;
        }
    }
}

