/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.util.HashMap;
import java.util.Map;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.util.OverflowingLRUCache;
import org.teiid.designer.core.workspace.ModelWorkspaceInfo;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceItemCache;
import org.teiid.designer.core.workspace.ModelWorkspaceItemInfo;

public class ModelWorkspaceCache {
    public static final int OPENABLE_CACHE_SIZE = 2000;
    protected ModelWorkspaceInfo workspaceInfo;
    protected Map<ModelWorkspaceItem, ModelWorkspaceItemInfo> projectAndRootCache = new HashMap<ModelWorkspaceItem, ModelWorkspaceItemInfo>(50);
    protected OverflowingLRUCache<ModelWorkspaceItem, ModelWorkspaceItemInfo> openableCache = new ModelWorkspaceItemCache(2000);
    protected Map<ModelWorkspaceItem, ModelWorkspaceItemInfo> childrenCache = new HashMap<ModelWorkspaceItem, ModelWorkspaceItemInfo>(40000);

    public int pkgSize() {
        return 0;
    }

    public ModelWorkspaceItemInfo getInfo(ModelWorkspaceItem item) {
        CoreArgCheck.isNotNull((Object)item);
        switch (item.getItemType()) {
            case 1: {
                return this.workspaceInfo;
            }
            case 2: 
            case 4: {
                return this.projectAndRootCache.get(item);
            }
            case 5: {
                return (ModelWorkspaceItemInfo)this.openableCache.get(item);
            }
        }
        return this.childrenCache.get(item);
    }

    protected Object peekAtInfo(ModelWorkspaceItem item) {
        CoreArgCheck.isNotNull((Object)item);
        switch (item.getItemType()) {
            case 1: {
                return this.workspaceInfo;
            }
            case 2: 
            case 4: {
                return this.projectAndRootCache.get(item);
            }
            case 5: {
                return this.openableCache.get(item);
            }
        }
        return this.childrenCache.get(item);
    }

    protected void putInfo(ModelWorkspaceItem item, ModelWorkspaceItemInfo info) {
        CoreArgCheck.isNotNull((Object)item);
        CoreArgCheck.isNotNull((Object)info);
        switch (item.getItemType()) {
            case 1: {
                this.workspaceInfo = (ModelWorkspaceInfo)info;
                break;
            }
            case 2: 
            case 4: {
                this.projectAndRootCache.put(item, info);
                break;
            }
            case 5: {
                this.openableCache.put(item, info);
                break;
            }
            default: {
                this.childrenCache.put(item, info);
            }
        }
    }

    protected void removeInfo(ModelWorkspaceItem item) {
        CoreArgCheck.isNotNull((Object)item);
        switch (item.getItemType()) {
            case 1: {
                this.workspaceInfo = null;
                break;
            }
            case 2: 
            case 4: {
                this.projectAndRootCache.remove(item);
                break;
            }
            case 5: {
                this.openableCache.remove(item);
                break;
            }
            default: {
                this.childrenCache.remove(item);
            }
        }
    }

    public void clear() {
        this.childrenCache.clear();
        this.openableCache.clear();
        this.projectAndRootCache.clear();
        this.workspaceInfo = null;
    }
}

