/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.workspace.ModelBufferImpl;
import org.teiid.designer.core.workspace.ModelDiagrams;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelResourceImpl;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.NonOpenableModelWorkspaceItemImpl;
import org.teiid.designer.core.workspace.Openable;
import org.teiid.designer.metamodels.diagram.Diagram;

public class ModelDiagramsImpl
extends NonOpenableModelWorkspaceItemImpl
implements ModelDiagrams {
    protected static final String DEFAULT_NAME = ModelerCore.Util.getString("ModelDiagramsImpl.defaultName", new Object[0]);

    ModelDiagramsImpl() {
        super(8, null, DEFAULT_NAME);
    }

    public ModelDiagramsImpl(ModelWorkspaceItem parent) {
        super(8, parent, DEFAULT_NAME);
    }

    public ModelResource getModelResource() {
        return (ModelResource)this.getParent();
    }

    @Override
    public IResource getResource() {
        return this.getModelResource().getResource();
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.getResource();
    }

    @Override
    public IPath getPath() {
        return this.getModelResource().getPath();
    }

    protected ModelBufferImpl getModelBuffer() throws ModelWorkspaceException {
        ModelResourceImpl modelResourceImpl = (ModelResourceImpl)this.getModelResource();
        return (ModelBufferImpl)modelResourceImpl.getBuffer();
    }

    @Override
    public List getDiagrams(EObject target) throws ModelWorkspaceException {
        ModelBufferImpl buffer = this.getModelBuffer();
        ModelContents contents = buffer.getModelContents();
        if (contents == null) {
            Object[] params = new Object[]{this.getParent().getPath()};
            String msg = ModelerCore.Util.getString("ModelDiagramsImpl.No_ModelContents_found_for_resource", params);
            CoreArgCheck.isTrue((boolean)false, (String)msg);
        }
        return contents.getDiagrams(target);
    }

    @Override
    public List getDiagrams() throws ModelWorkspaceException {
        return this.getModelBuffer().getModelContents().getDiagrams();
    }

    @Override
    public Diagram createNewDiagram(EObject target, boolean persistent) throws ModelWorkspaceException {
        EObject finalTarget = target;
        if (finalTarget == null) {
            finalTarget = this.getModelBuffer().getModelContents().getModelAnnotation();
        }
        return ModelResourceContainerFactory.createNewDiagram(finalTarget, this.getModelResource().getEmfResource(), persistent);
    }

    @Override
    public boolean delete(Diagram diagram) {
        return ModelResourceContainerFactory.deleteDiagram(diagram);
    }

    @Override
    public boolean isPersistent(Diagram diagram) {
        return ModelResourceContainerFactory.isPersistent(diagram);
    }

    @Override
    public void setPersistent(Diagram diagram, boolean persistent) throws ModelWorkspaceException {
        if (persistent == this.isPersistent(diagram)) {
            return;
        }
        ModelResourceContainerFactory.setDiagramPersistence(diagram, this.getModelResource().getEmfResource(), persistent);
    }

    @Override
    public Openable getOpenable() {
        return this.getOpenableParent();
    }
}

