/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation.rules;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.StructuralFeatureValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.rules.CoreValidationRulesUtil;

public class StringNameRule
implements StructuralFeatureValidationRule {
    private char[] validChars;
    private final int featureID;

    public StringNameRule(char[] validChars, int featureID) {
        CoreArgCheck.isNotNull((Object)validChars);
        this.validChars = validChars;
        this.featureID = featureID;
    }

    public StringNameRule(int featureID) {
        this.featureID = featureID;
    }

    @Override
    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        if (eStructuralFeature.getFeatureID() != this.featureID) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        String name = (String)value;
        ValidationResultImpl result = new ValidationResultImpl(eObject);
        if (this.validateCharacters()) {
            CoreValidationRulesUtil.validateStringNameChars((ValidationResult)result, name, this.validChars, this.getInvalidCharactersSeverityCode());
        }
        context.addResult(result);
        String objType = eObject.eClass().getName();
        if (!context.hasRunRule(eObject, String.valueOf(this.getRuleName()) + objType) && this.validateUniqueness()) {
            List siblings = this.getSiblingsForUniquenessCheck(eObject);
            CoreValidationRulesUtil.validateUniqueness(context, siblings, this.featureID);
            context.recordRuleRun(eObject, String.valueOf(this.getRuleName()) + objType);
        }
    }

    protected String getRuleName() {
        return this.getClass().getName();
    }

    protected boolean validateUniqueness() {
        return true;
    }

    protected boolean validateCharacters() {
        return true;
    }

    protected int getInvalidCharactersSeverityCode() {
        return 4;
    }

    protected int getFeatureID() {
        return this.featureID;
    }

    protected List getSiblingsForUniquenessCheck(EObject eObject) {
        EObject parent = eObject.eContainer();
        if (parent != null) {
            return parent.eContents();
        }
        Resource resource = eObject.eResource();
        if (resource != null) {
            return resource.getContents();
        }
        return Collections.EMPTY_LIST;
    }

    public void setNameCanBeNull(boolean b) {
    }
}

