/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.util.Iterator;
import java.util.Map;
import org.teiid.core.designer.util.LRUCache;

public abstract class OverflowingLRUCache<K, V>
extends LRUCache<K, V> {
    private static final long serialVersionUID = 1L;

    public OverflowingLRUCache(int maxSize) {
        super(maxSize);
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (!super.removeEldestEntry(eldest)) {
            return false;
        }
        Iterator entryIter = this.entrySet().iterator();
        int targetSize = (int)((float)this.maxSize * 0.66f);
        while (this.size() > targetSize && entryIter.hasNext()) {
            if (!this.close((Map.Entry)entryIter.next())) continue;
            entryIter.remove();
        }
        return false;
    }

    protected abstract boolean close(Map.Entry<K, V> var1);

    public int getOverflow() {
        return Math.max(0, this.size() - this.maxSize);
    }
}

