/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramContainer;
import org.teiid.designer.metamodels.diagram.DiagramEntity;

public class CoreModelObjectNotificationHelper {
    private static final String NEW_LINE = "\n";
    protected Notification primaryNotification = null;
    protected HashSet addOrRemoveTargets = null;
    protected HashSet changeTargets = null;
    protected HashSet changedModels = null;
    protected HashSet modifiedResources = null;
    protected HashSet addedChildren;
    protected boolean modelChildrenChanged = false;
    protected List leftoverNotifications = null;
    protected boolean handleNotification = false;
    protected boolean isDiagramOnlyNotification = true;

    public CoreModelObjectNotificationHelper(Notification notification) {
        this.primaryNotification = notification;
        this.init();
    }

    private void init() {
        this.addOrRemoveTargets = new HashSet();
        this.addedChildren = new HashSet();
        this.changeTargets = new HashSet();
        this.changedModels = new HashSet();
        this.modifiedResources = new HashSet();
        this.leftoverNotifications = new ArrayList();
        this.setHandleNotification();
        this.filterTargets();
    }

    private void setHandleNotification() {
        this.handleNotification = true;
    }

    public boolean shouldHandleNotification() {
        return this.handleNotification;
    }

    protected void filterTargets() {
        this.addOrRemoveTargets.clear();
        this.changeTargets.clear();
        this.changedModels.clear();
        this.modelChildrenChanged = false;
        this.leftoverNotifications.clear();
        if (this.primaryNotification instanceof SourcedNotification) {
            Collection notifications = ((SourcedNotification)this.primaryNotification).getNotifications();
            Iterator iter = notifications.iterator();
            Notification notification = null;
            while (iter.hasNext()) {
                IResource resource;
                EObject[] newValues;
                notification = (Notification)iter.next();
                Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
                if (targetObject instanceof DiagramContainer || targetObject instanceof ModelAnnotation) {
                    this.leftoverNotifications.add(notification);
                }
                boolean targetIsResource = targetObject instanceof Resource;
                EObject targetEObject = this.getEObjectTarget(notification);
                if (targetEObject != null) {
                    this.addToModifiedResources(targetEObject);
                    if (NotificationUtilities.isAdded(notification)) {
                        this.handleAddOrRemove(notification, targetEObject);
                        newValues = NotificationUtilities.getAddedChildren(notification);
                        if (newValues.length <= 0) continue;
                        this.addedChildren.addAll(Arrays.asList(newValues));
                        this.checkNonDiagramRelatedChange(newValues, false);
                        continue;
                    }
                    if (NotificationUtilities.isRemoved(notification)) {
                        this.handleAddOrRemove(notification, targetEObject);
                        this.checkNonDiagramRelatedChange(targetEObject, false);
                        continue;
                    }
                    if (!NotificationUtilities.isChanged(notification)) continue;
                    this.handleChanged(notification, targetEObject);
                    this.checkNonDiagramRelatedChange(targetEObject, true);
                    continue;
                }
                if (!targetIsResource) continue;
                if (NotificationUtilities.isAdded(notification)) {
                    this.handleAddOrRemove(notification, targetEObject);
                    newValues = NotificationUtilities.getAddedChildren(notification);
                    if (newValues.length > 0) {
                        this.addedChildren.addAll(Arrays.asList(newValues));
                        this.checkNonDiagramRelatedChange(newValues, false);
                    }
                } else if (NotificationUtilities.isRemoved(notification)) {
                    this.handleAddOrRemove(notification, targetEObject);
                    this.checkNonDiagramRelatedChange(targetEObject, false);
                } else if (NotificationUtilities.isChanged(notification)) {
                    this.handleChanged(notification, targetEObject);
                    this.checkNonDiagramRelatedChange(targetEObject, true);
                }
                if ((resource = WorkspaceResourceFinderUtil.findIResource((Resource)targetObject)) == null || !ModelWorkspaceManager.getModelWorkspaceManager().isModelOpen(resource)) continue;
                this.modelChildrenChanged = true;
                this.changedModels.add(resource);
                this.addToModifiedResources(resource);
            }
        } else {
            Object targetObject = ModelerCore.getModelEditor().getChangedObject(this.primaryNotification);
            if (targetObject instanceof DiagramContainer || targetObject instanceof ModelAnnotation) {
                this.leftoverNotifications.add(this.primaryNotification);
            }
            EObject targetEObject = this.getEObjectTarget(this.primaryNotification);
            if (NotificationUtilities.isAdded(this.primaryNotification) || NotificationUtilities.isRemoved(this.primaryNotification)) {
                if (targetEObject != null) {
                    this.addOrRemoveTargets.add(targetEObject);
                    this.checkNonDiagramRelatedChange(targetEObject, false);
                }
            } else if (NotificationUtilities.isChanged(this.primaryNotification) && targetEObject != null) {
                this.changeTargets.add(targetEObject);
                this.checkNonDiagramRelatedChange(targetEObject, true);
            }
        }
    }

    protected void addToModifiedResources(Object someObject) {
        IResource iResource = null;
        try {
            if (someObject instanceof EObject) {
                ModelResource mr = ModelerCore.getModelEditor().findModelResource((EObject)someObject);
                if (mr != null) {
                    iResource = mr.getUnderlyingResource();
                }
            } else if (someObject instanceof Resource) {
                ModelResource mr = ModelerCore.getModelEditor().findModelResource((Resource)someObject);
                if (mr != null) {
                    iResource = mr.getUnderlyingResource();
                }
            } else if (someObject instanceof IResource) {
                iResource = (IResource)someObject;
            } else if (someObject instanceof ModelResource) {
                iResource = ((ModelResource)someObject).getUnderlyingResource();
            }
        }
        catch (ModelWorkspaceException modelWorkspaceException) {}
        if (iResource != null) {
            this.modifiedResources.add(iResource);
        }
    }

    protected void handleAddOrRemove(Notification notification, EObject targetEObject) {
        if (targetEObject != null) {
            this.addOrRemoveTargets.add(targetEObject);
        } else {
            this.leftoverNotifications.add(notification);
        }
    }

    protected void handleChanged(Notification notification, EObject targetEObject) {
        if (targetEObject != null) {
            this.changeTargets.add(targetEObject);
        } else {
            this.leftoverNotifications.add(notification);
        }
    }

    protected EObject getEObjectTarget(Notification notification) {
        Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
        if (targetObject instanceof EObject) {
            return (EObject)targetObject;
        }
        return null;
    }

    public List getAddOrRemoveTargets() {
        return new ArrayList(this.addOrRemoveTargets);
    }

    public List getChangeTargets() {
        return new ArrayList(this.changeTargets);
    }

    public List getChangeModels() {
        return new ArrayList(this.changedModels);
    }

    public boolean getModelChildrenChanged() {
        return this.modelChildrenChanged;
    }

    public List getLeftoverNotifications() {
        return this.leftoverNotifications;
    }

    public Set getAddedChildren() {
        return this.addedChildren;
    }

    public List getModifiedResources() {
        return new ArrayList(this.modifiedResources);
    }

    private void checkNonDiagramRelatedChange(Object obj, boolean isSet) {
        if (this.isDiagramOnlyNotification && obj != null) {
            if (obj instanceof DiagramEntity) {
                this.isDiagramOnlyNotification = true;
            } else if (obj instanceof Diagram && isSet) {
                this.isDiagramOnlyNotification = false;
            } else if (obj instanceof List) {
                for (Object nextObj : (List)obj) {
                    if (!(nextObj instanceof Diagram) && !(nextObj instanceof DiagramEntity)) {
                        this.isDiagramOnlyNotification = false;
                    }
                    if (!this.isDiagramOnlyNotification) break;
                }
            }
        }
    }

    public boolean allChangesAreIgnorable() {
        if (this.isDiagramOnlyNotification) {
            return this.addedChildren.isEmpty() && this.addOrRemoveTargets.isEmpty() && this.changeTargets.isEmpty();
        }
        return this.isDiagramOnlyNotification;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getClass().getName()) + NEW_LINE);
        sb.append("   # added children        = " + this.addedChildren.size() + NEW_LINE);
        sb.append("   # add/remove targets    = " + this.addOrRemoveTargets.size() + NEW_LINE);
        sb.append("   # changed targets       = " + this.changeTargets.size() + NEW_LINE);
        sb.append("   # changed models        = " + this.changedModels.size() + NEW_LINE);
        sb.append("   # changed resources     = " + this.modifiedResources.size() + NEW_LINE);
        sb.append("   Model Children Changed  = " + this.modelChildrenChanged + NEW_LINE);
        sb.append("   All Changes to Ignorable= " + this.allChangesAreIgnorable() + NEW_LINE);
        return sb.toString();
    }
}

