/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.IEntryResult;
import org.teiid.designer.core.index.IQueryResult;
import org.teiid.designer.core.index.Index;
import org.teiid.designer.core.index.IndexConstants;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.index.ModelWorkspaceSearchIndexSelector;
import org.teiid.designer.core.search.runtime.ReferencesRecord;
import org.teiid.designer.core.search.runtime.ResourceImportRecord;
import org.teiid.designer.core.search.runtime.ResourceObjectRecord;
import org.teiid.designer.core.search.runtime.ResourceRecord;
import org.teiid.designer.core.search.runtime.SearchRuntimeAdapter;

public class ModelWorkspaceSearch {
    private static final IQueryResult[] EMTPY_QUERY_RESULT_ARRAY = new IQueryResult[0];
    private static final IEntryResult[] EMTPY_ENTRY_RESULT_ARRAY = new IEntryResult[0];
    private IndexSelector selector;
    private IProgressMonitor monitor;
    private int iIncrement = -1;
    private static final int NOMINAL_WORK = 100;
    private static final int START_UNITS = 10;

    public ModelWorkspaceSearch() {
    }

    public ModelWorkspaceSearch(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public IPath[] getResourcesContainingObjectId(ObjectID id) {
        return this.getResourcesContainingObjectId(id.toString());
    }

    public IPath[] getResourcesContainingObjectId(String id) {
        String prefix = IndexUtil.getPrefixPattern('C', id);
        IQueryResult[] results = this.queryPrefix(prefix);
        ArrayList<Path> tmp = new ArrayList<Path>(results.length);
        int i = 0;
        while (i < results.length) {
            IQueryResult result = results[i];
            String resultPath = result.getPath();
            int beginIndex = resultPath.indexOf(47);
            if (beginIndex > 0) {
                resultPath = resultPath.substring(beginIndex);
            }
            Path path = new Path(resultPath);
            tmp.add(path);
            ++i;
        }
        IPath[] paths = new IPath[tmp.size()];
        tmp.toArray(paths);
        return paths;
    }

    public IPath[] getResourcesWithId(ObjectID id) {
        return this.getResourcesWithId(id.toString());
    }

    public IPath[] getResourcesWithId(String id) {
        String prefix = IndexUtil.getPrefixPattern('A', id);
        IEntryResult[] results = this.queryWithPrefix(prefix);
        ArrayList<Path> tmp = new ArrayList<Path>(results.length);
        int i = 0;
        while (i < results.length) {
            IEntryResult result = results[i];
            ResourceRecord record = (ResourceRecord)SearchRuntimeAdapter.getSearchRecord(result.getWord());
            tmp.add(new Path(record.getPath()));
            ++i;
        }
        IPath[] paths = new IPath[tmp.size()];
        tmp.toArray(paths);
        return paths;
    }

    public Collection getAllModelObjectRecords() {
        this.initMonitor();
        String prefix = IndexUtil.getPrefixPattern('C', null);
        IEntryResult[] results = null;
        results = this.monitor != null ? this.queryWithPrefix(prefix, this.monitor) : this.queryWithPrefix(prefix);
        HashSet<ResourceObjectRecord> objRecords = new HashSet<ResourceObjectRecord>(results.length);
        int iRecordCount = results.length;
        int i = 0;
        while (i < iRecordCount) {
            IEntryResult result = results[i];
            ResourceObjectRecord record = (ResourceObjectRecord)SearchRuntimeAdapter.getSearchRecord(result.getWord());
            objRecords.add(record);
            try {
                this.updateMonitor(i, iRecordCount);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            ++i;
        }
        return objRecords;
    }

    private void initMonitor() {
        if (this.monitor == null) {
            return;
        }
        this.monitor.beginTask(null, 100);
    }

    private void updateMonitor(int iCurrentIndex, int iTotalRecords) throws InterruptedException {
        if (this.monitor == null || iTotalRecords == 0) {
            return;
        }
        if (this.iIncrement == -1) {
            int iRemainingUnits = 90;
            this.iIncrement = iTotalRecords / iRemainingUnits;
            if (this.iIncrement == 0) {
                this.iIncrement = 1;
            }
        }
        if (iCurrentIndex % this.iIncrement == 0) {
            if (this.monitor.isCanceled()) {
                throw new InterruptedException();
            }
            this.monitor.worked(this.iIncrement);
        }
    }

    public Collection getModelsImportingResources(String folderOrFilePath) {
        String prefix = "B\u00a0" + folderOrFilePath.trim();
        IEntryResult[] results = this.queryWithPrefix(prefix);
        HashSet<ResourceImportRecord> refRecords = new HashSet<ResourceImportRecord>(results.length);
        int i = 0;
        while (i < results.length) {
            IEntryResult result = results[i];
            ResourceImportRecord record = (ResourceImportRecord)SearchRuntimeAdapter.getSearchRecord(result.getWord());
            refRecords.add(record);
            ++i;
        }
        return refRecords;
    }

    public Collection getResourcesImportedByModel(String folderOrFilePath) {
        String pattern = "B\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + folderOrFilePath.trim() + '\u00a0';
        IEntryResult[] results = this.queryWithPattern(pattern);
        HashSet<ResourceImportRecord> refRecords = new HashSet<ResourceImportRecord>(results.length);
        int i = 0;
        while (i < results.length) {
            IEntryResult result = results[i];
            ResourceImportRecord record = (ResourceImportRecord)SearchRuntimeAdapter.getSearchRecord(result.getWord());
            refRecords.add(record);
            ++i;
        }
        return refRecords;
    }

    public Collection getUniDirectionalReferencesTo(String id) {
        String prefix = "D\u00a0" + id.trim() + '\u00a0';
        IEntryResult[] results = this.queryWithPrefix(prefix);
        HashSet<ReferencesRecord> refRecords = new HashSet<ReferencesRecord>(results.length);
        int i = 0;
        while (i < results.length) {
            IEntryResult result = results[i];
            ReferencesRecord record = (ReferencesRecord)SearchRuntimeAdapter.getSearchRecord(result.getWord());
            refRecords.add(record);
            ++i;
        }
        return refRecords;
    }

    public Collection getUniDirectionalReferencesFrom(String id) {
        String pattern = "D\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + id.trim() + '\u00a0';
        IEntryResult[] results = this.queryWithPattern(pattern);
        HashSet<ReferencesRecord> refRecords = new HashSet<ReferencesRecord>(results.length);
        int i = 0;
        while (i < results.length) {
            IEntryResult result = results[i];
            ReferencesRecord record = (ReferencesRecord)SearchRuntimeAdapter.getSearchRecord(result.getWord());
            refRecords.add(record);
            ++i;
        }
        return refRecords;
    }

    public void setIndexSelector(IndexSelector indexSelector) {
        this.selector = indexSelector;
    }

    protected IndexSelector getIndexSelector() {
        return this.getIndexSelector(null);
    }

    protected IndexSelector getIndexSelector(IProgressMonitor monitor) {
        if (this.selector == null) {
            this.selector = this.createIndexSelector(monitor);
        }
        if (this.selector instanceof ModelWorkspaceSearchIndexSelector) {
            ((ModelWorkspaceSearchIndexSelector)this.selector).setMonitor(monitor);
        }
        return this.selector;
    }

    protected IndexSelector createIndexSelector(IProgressMonitor monitor) {
        return new ModelWorkspaceSearchIndexSelector(monitor);
    }

    private IEntryResult[] queryWithPrefix(String prefix) {
        return this.queryWithPrefix(prefix, null);
    }

    private IEntryResult[] queryWithPrefix(String prefix, IProgressMonitor monitor) {
        try {
            Index[] indexes = null;
            indexes = monitor != null ? this.getIndexSelector(monitor).getIndexes() : this.getIndexSelector().getIndexes();
            return IndexUtil.queryIndex(monitor, indexes, prefix.toCharArray(), true, false);
        }
        catch (ModelerCoreException e) {
            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
        }
        catch (IOException e) {
            ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("ModelWorkspaceSearch.Error_trying_to_index_files_from_selector_1", new Object[0]));
        }
        return EMTPY_ENTRY_RESULT_ARRAY;
    }

    private IEntryResult[] queryWithPattern(String pattern) {
        try {
            Index[] indexes = this.getIndexSelector().getIndexes();
            return IndexUtil.queryIndex(indexes, pattern.toCharArray(), false, false);
        }
        catch (ModelerCoreException e) {
            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
        }
        catch (IOException e) {
            ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("ModelWorkspaceSearch.Error_trying_to_index_files_from_selector_1", new Object[0]));
        }
        return EMTPY_ENTRY_RESULT_ARRAY;
    }

    private IQueryResult[] queryPrefix(String prefix) {
        try {
            Index[] indexes = this.getIndexSelector().getIndexes();
            return this.queryPrefix(indexes, prefix.toCharArray());
        }
        catch (ModelerCoreException e) {
            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
        }
        catch (IOException e) {
            ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("ModelWorkspaceSearch.Error_trying_to_index_files_from_selector_1", new Object[0]));
        }
        return EMTPY_QUERY_RESULT_ARRAY;
    }

    private IQueryResult[] queryPrefix(Index[] indexes, char[] prefix) throws ModelerCoreException {
        ArrayList<IQueryResult> queryResult = new ArrayList<IQueryResult>();
        try {
            int i = 0;
            while (i < indexes.length) {
                IQueryResult[] partialResult = indexes[i].queryPrefix(prefix);
                if (partialResult != null && partialResult.length > 0) {
                    queryResult.addAll(Arrays.asList(partialResult));
                }
                ++i;
            }
        }
        catch (IOException e) {
            Object[] params = new Object[]{new String(prefix)};
            throw new ModelerCoreException((Throwable)e, ModelerCore.Util.getString("ModelWorkspaceSearch.Error_trying_to_query_index_files_for_prefix_2", params));
        }
        IQueryResult[] result = new IQueryResult[queryResult.size()];
        queryResult.toArray(result);
        return result;
    }
}

