/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.resource;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.EResourceImpl;
import org.teiid.designer.core.resource.EResourceSetImpl;
import org.teiid.designer.metamodels.core.Identifiable;

public class EResourceXmiSaveImpl
extends XMISaveImpl {
    protected static final char UUID_PROTOCOL_DELIMITER = '/';
    protected static final String XMI_UUID = "uuid";
    protected static final String XMI_UUID_NS = "xmi:uuid";
    protected static final String BAD_DATATYPE_HREF = "#null";
    private static final String AMP = "&amp;";
    private static final String LT = "&lt;";
    private static final String QUOT = "&quot;";
    private static final String HEX_PREFIX = "&#x";
    private static final boolean DEBUG = false;
    private boolean escaped;
    private final EResourceImpl eResource;

    public EResourceXmiSaveImpl(XMLHelper helper, EResourceImpl theEResource) {
        super(helper);
        CoreArgCheck.isNotNull((Object)theEResource);
        this.eResource = theEResource;
    }

    protected String getContent(EObject o, EStructuralFeature[] features) {
        XMLResource.XMLMap map = this.helper.getXMLMap();
        if (map == null) {
            return null;
        }
        int i = 0;
        while (i < features.length) {
            XMLResource.XMLInfo info = map.getInfo((ENamedElement)features[i]);
            if (info != null && info.getXMLRepresentation() == 2) {
                Object value = this.helper.getValue(o, features[i]);
                if (value == null) {
                    return null;
                }
                EDataType d = (EDataType)features[i].getEType();
                EPackage ePackage = d.getEPackage();
                EFactory fac = ePackage.getEFactoryInstance();
                String svalue = fac.convertToString(d, value);
                if (this.escaped) {
                    svalue = this.convert(svalue);
                }
                return svalue;
            }
            ++i;
        }
        return null;
    }

    protected void init(XMLResource resource, Map options) {
        super.init(resource, options);
        this.escape = null;
        this.escaped = !Boolean.TRUE.equals(options.get("SKIP_ESCAPE"));
    }

    protected void saveDataTypeElementSingle(EObject o, EStructuralFeature f) {
        String name = this.helper.getQName(f);
        Object value = this.helper.getValue(o, f);
        if (value == null) {
            this.doc.startElement(name);
            this.doc.addAttribute("xsi:nil", "true");
            this.doc.endEmptyElement();
            this.declareXSI = true;
        } else {
            EDataType d = (EDataType)f.getEType();
            EPackage ePackage = d.getEPackage();
            EFactory fac = ePackage.getEFactoryInstance();
            this.doc.startElement(name);
            String svalue = fac.convertToString(d, value);
            if (this.escaped) {
                svalue = this.convert(svalue);
            }
            this.doc.endContentElement(svalue);
        }
    }

    protected void saveDataTypeSingle(EObject o, EStructuralFeature f) {
        EDataType d = (EDataType)f.getEType();
        EPackage ePackage = d.getEPackage();
        EFactory fac = ePackage.getEFactoryInstance();
        Object value = this.helper.getValue(o, f);
        if (value != null) {
            String svalue = fac.convertToString(d, value);
            if (this.escaped) {
                svalue = this.convert(svalue);
            }
            this.doc.addAttribute(this.helper.getQName(f), svalue);
        }
    }

    protected void saveDataTypeMany(EObject o, EStructuralFeature f) {
        EDataType d = (EDataType)f.getEType();
        EPackage ePackage = d.getEPackage();
        EFactory fac = ePackage.getEFactoryInstance();
        List values = (List)this.helper.getValue(o, f);
        int size = values.size();
        if (size > 0) {
            String name = this.helper.getQName(f);
            int i = 0;
            while (i < size) {
                Object value = values.get(i);
                if (value == null) {
                    this.doc.startElement(name);
                    this.doc.addAttribute("xsi:nil", "true");
                    this.doc.endEmptyElement();
                    this.declareXSI = true;
                } else {
                    this.doc.startElement(name);
                    String svalue = fac.convertToString(d, value);
                    if (this.escaped) {
                        svalue = this.convert(svalue);
                    }
                    this.doc.endContentElement(svalue);
                }
                ++i;
            }
        }
    }

    protected void saveElementID(EObject o) {
        String uuid;
        String id = this.helper.getID(o);
        if (id != null) {
            this.doc.addAttribute(this.idAttributeName, id);
        }
        if ((uuid = ModelerCore.getObjectIdString(o)) != null) {
            this.doc.addAttribute(XMI_UUID_NS, uuid);
        }
        this.saveFeatures(o);
    }

    protected void saveElementReference(EObject remote, EStructuralFeature f) {
        if (remote instanceof Identifiable) {
            String name = this.helper.getQName(f);
            String href = ((Identifiable)remote).getUuid();
            if (href != null) {
                href = href.replace(':', '/');
                this.doc.startElement(name);
                this.doc.endContentElement(href);
            }
            return;
        }
        super.saveElementReference(remote, f);
    }

    protected void saveHref(EObject remote, EStructuralFeature f) {
        if (this.saveConvertedHref(remote, f)) {
            return;
        }
        super.saveHref(remote, f);
    }

    protected void saveIDRefSingle(EObject eObject, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(eObject, f);
        if (value != null && value instanceof Identifiable) {
            String name = this.helper.getQName(f);
            String id = ((Identifiable)value).getUuid();
            id = id.replace(':', '/');
            this.doc.addAttribute(name, id);
        } else {
            super.saveIDRefSingle(eObject, f);
        }
    }

    protected void saveIDRefMany(EObject eObject, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(eObject, f);
        if (!values.isEmpty()) {
            String name = this.helper.getQName(f);
            StringBuffer ids = new StringBuffer(values.size() * 10);
            Iterator i = values.basicIterator();
            while (true) {
                EObject value = (EObject)i.next();
                String id = null;
                if (value instanceof Identifiable) {
                    id = ((Identifiable)value).getUuid();
                    id = id.replace(':', '/');
                } else {
                    id = this.helper.getIDREF(value);
                }
                ids.append(id);
                if (!i.hasNext()) break;
                ids.append(" ");
            }
            this.doc.addAttribute(name, ids.toString());
        }
    }

    protected void saveHRefMany(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        Iterator basicIterator = values.basicIterator();
        while (basicIterator.hasNext()) {
            this.saveHref((EObject)basicIterator.next(), f);
        }
    }

    protected String convert(String value) {
        if (value == null) {
            return null;
        }
        char[] chrs = new char[value.length()];
        value.getChars(0, chrs.length, chrs, 0);
        StringBuffer newVal = new StringBuffer();
        int ndx = 0;
        int len = chrs.length;
        while (ndx < len) {
            char chr = chrs[ndx];
            switch (chr) {
                case '&': {
                    newVal.append(AMP);
                    break;
                }
                case '<': {
                    newVal.append(LT);
                    break;
                }
                case '\"': {
                    newVal.append(QUOT);
                    break;
                }
                default: {
                    if (chr < ' ' || chr > '\u007f') {
                        newVal.append(HEX_PREFIX + Integer.toHexString(chr) + ';');
                        break;
                    }
                    newVal.append(chr);
                }
            }
            ++ndx;
        }
        return newVal.toString();
    }

    protected boolean saveConvertedHref(EObject remote, EStructuralFeature f) {
        EResourceSetImpl rs;
        Object logicalUri = null;
        if (this.eResource.getResourceSet() instanceof EResourceSetImpl && (rs = (EResourceSetImpl)this.eResource.getResourceSet()).getEObjectHrefConverter() != null) {
            logicalUri = rs.getEObjectHrefConverter().getLogicalURI(remote);
        }
        if (logicalUri != null) {
            String href = logicalUri.toString();
            String name = this.helper.getQName(f);
            this.doc.startElement(name);
            EClass eClass = remote.eClass();
            EClass expectedType = (EClass)f.getEType();
            if (eClass != expectedType && expectedType.isAbstract()) {
                this.saveTypeAttribute(eClass);
            }
            this.doc.addAttribute("href", href);
            this.doc.endEmptyElement();
            return true;
        }
        return false;
    }
}

