/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.refactor;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ResourceFinder;
import org.teiid.designer.core.refactor.ExternalReferenceVisitor;
import org.teiid.designer.core.refactor.OrganizeImportCommandHelper;
import org.teiid.designer.core.refactor.PathPair;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.core.util.ModelImportComparator;

public class OrganizeImportCommandHelperNonXsd
extends OrganizeImportCommandHelper {
    protected OrganizeImportCommandHelperNonXsd() {
    }

    @Override
    protected IStatus execute(IProgressMonitor monitor) {
        return this.process(monitor);
    }

    private IStatus process(IProgressMonitor monitor) {
        LinkedList problems = new LinkedList();
        Resource eResource = this.getResource();
        ModelAnnotation modelAnnot = this.getModelAnnotation(eResource);
        this.modelImports.clear();
        HashSet newImports = new HashSet(this.modelImports.size());
        this.buildAllImportsForExternalRef(eResource, problems, newImports, monitor);
        this.modelImports.addAll(newImports);
        if (this.importsChanged(modelAnnot)) {
            this.updateImport(modelAnnot);
        }
        IStatus resultStatus = this.createFinalStatus(problems);
        return resultStatus;
    }

    private boolean importsChanged(ModelAnnotation modelAnnot) {
        boolean result = false;
        boolean bl = result = modelAnnot.getModelImports().size() != this.modelImports.size();
        if (!result && (this.hasStaleImports(modelAnnot) || this.isMissingImports(modelAnnot))) {
            result = true;
        }
        return result;
    }

    private boolean clearExistingImports(ModelAnnotation modelAnnot) {
        if (modelAnnot.getModelImports().isEmpty()) {
            return false;
        }
        ArrayList existingImportList = new ArrayList(modelAnnot.getModelImports());
        try {
            ModelerCore.getModelEditor().removeValue(modelAnnot, existingImportList, modelAnnot.getModelImports());
        }
        catch (ModelerCoreException err) {
            ModelerCore.Util.log((Throwable)err);
            return false;
        }
        return true;
    }

    private boolean hasStaleImports(ModelAnnotation modelAnnot) {
        ArrayList existingImportList = new ArrayList(modelAnnot.getModelImports());
        for (ModelImport nextImport : existingImportList) {
            if (this.importInList(nextImport, this.modelImports)) continue;
            return true;
        }
        return false;
    }

    private boolean isMissingImports(ModelAnnotation modelAnnot) {
        ArrayList existingImportList = new ArrayList(modelAnnot.getModelImports());
        for (ModelImport nextImport : this.modelImports) {
            if (this.importInList(nextImport, existingImportList)) continue;
            return true;
        }
        return false;
    }

    private boolean importInList(ModelImport someModelImport, List importList) {
        if (someModelImport.getModelLocation() == null || someModelImport.getModelLocation().trim().equals("")) {
            return false;
        }
        String importLocation = someModelImport.getModelLocation();
        for (ModelImport nextImport : importList) {
            if (nextImport.getModelLocation() == null || !nextImport.getModelLocation().equalsIgnoreCase(importLocation)) continue;
            return true;
        }
        return false;
    }

    private void updateImport(ModelAnnotation modelAnnot) {
        if (modelAnnot != null) {
            boolean importsChanged = this.clearExistingImports(modelAnnot);
            try {
                try {
                    if (!this.modelImports.isEmpty()) {
                        importsChanged = true;
                        Collections.sort(this.modelImports, new ModelImportComparator());
                        ModelerCore.getModelEditor().addValue(modelAnnot, this.modelImports, modelAnnot.getModelImports());
                    }
                }
                catch (ModelerCoreException e1) {
                    ModelerCore.Util.log((Throwable)e1);
                    if (importsChanged) {
                        this.getResource().setModified(true);
                    }
                }
            }
            finally {
                if (importsChanged) {
                    this.getResource().setModified(true);
                }
            }
        }
    }

    private void buildAllImportsForExternalRef(Resource eResource, List problems, Set newImports, IProgressMonitor monitor) {
        ExternalReferenceVisitor visitor = this.processExternalResourcesReferences(eResource, problems);
        Collection externRefList = visitor.getExternalReferences();
        ModelAnnotation modelAnnot = this.getModelAnnotation(eResource);
        HashSet<String> existingImportLocations = new HashSet<String>(modelAnnot.getModelImports().size());
        for (ModelImport existingImport : modelAnnot.getModelImports()) {
            existingImportLocations.add(existingImport.getModelLocation());
        }
        for (ExternalReferenceVisitor.ExternalReferences externalRefs : externRefList) {
            URI externalUri = externalRefs.getResourceUri();
            CoreArgCheck.isNotNull((Object)externalUri);
            if (externalUri.equals(eResource.getURI())) continue;
            try {
                ModelImport modelImport = this.createModelImport(eResource, externalRefs, problems, monitor);
                if (modelImport == null) continue;
                if (!this.containsImport(newImports, modelImport)) {
                    newImports.add(modelImport);
                }
                if (existingImportLocations.contains(modelImport.getModelLocation())) continue;
                this.adjustReferences(eResource, externalRefs, modelImport);
                eResource.setModified(true);
            }
            catch (Throwable t) {
                Object[] params = new Object[]{URI.decode((String)externalUri.toString())};
                String msg = ModelerCore.Util.getString("OrganizeImportCommand.Error_while_building_import", params);
                problems.add(new Status(4, "org.teiid.designer.core", 1009, msg, t));
            }
        }
    }

    private boolean containsImport(Collection importCollection, ModelImport modelImport) {
        String modelImportUUID = modelImport.getUuid();
        String modelImportLoc = modelImport.getModelLocation();
        for (ModelImport mi : importCollection) {
            if (modelImportUUID != null && modelImportUUID.equals(mi.getUuid())) {
                return true;
            }
            if (modelImportLoc == null || !modelImportLoc.equals(mi.getModelLocation())) continue;
            return true;
        }
        return false;
    }

    private ExternalReferenceVisitor processExternalResourcesReferences(Resource eResource, List problems) {
        ExternalReferenceVisitor visitor = new ExternalReferenceVisitor(eResource);
        visitor.setIncludeDiagramReferences(this.includeDiagramReferences);
        ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
        try {
            processor.walk(this.getResource(), 2);
        }
        catch (ModelerCoreException e) {
            Object[] params = new Object[]{this.getResource().getURI(), e.getLocalizedMessage()};
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.Error_while_organizing_imports", params);
            problems.add(new Status(4, "org.teiid.designer.core", 1002, msg, (Throwable)e));
        }
        catch (Throwable t) {
            Object[] params = new Object[]{this.getResource().getURI(), t.getLocalizedMessage()};
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.Unknown_error_while_organizing_imports", params);
            problems.add(new Status(4, "org.teiid.designer.core", 1003, msg, t));
        }
        return visitor;
    }

    private IStatus createFinalStatus(List problems) {
        IStatus resultStatus = null;
        if (problems.isEmpty()) {
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.complete", new Object[0]);
            Status status = new Status(0, "org.teiid.designer.core", 1004, msg, null);
            resultStatus = status;
        } else {
            resultStatus = problems.size() == 1 ? (IStatus)problems.get(0) : this.createFinalResultStatus(problems);
        }
        return resultStatus;
    }

    private IStatus createFinalResultStatus(List problems) {
        MultiStatus resultStatus = null;
        int numErrors = 0;
        int numWarnings = 0;
        for (IStatus aStatus : problems) {
            if (aStatus.getSeverity() == 2) {
                ++numWarnings;
                continue;
            }
            if (aStatus.getSeverity() != 4) continue;
            ++numErrors;
        }
        IStatus[] statusArray = problems.toArray(new IStatus[problems.size()]);
        if (numWarnings != 0 && numErrors == 0) {
            Object[] params = new Object[]{new Integer(numWarnings)};
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.warnings", params);
            resultStatus = new MultiStatus("org.teiid.designer.core", 1005, statusArray, msg, null);
        } else if (numWarnings == 0 && numErrors != 0) {
            Object[] params = new Object[]{new Integer(numErrors)};
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.errors", params);
            resultStatus = new MultiStatus("org.teiid.designer.core", 1006, statusArray, msg, null);
        } else if (numWarnings != 0 && numErrors != 0) {
            Object[] params = new Object[]{new Integer(numWarnings), new Integer(numErrors)};
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.warnings_and_errors", params);
            resultStatus = new MultiStatus("org.teiid.designer.core", 1007, statusArray, msg, null);
        } else {
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.no_warnings_or_errors", new Object[0]);
            resultStatus = new MultiStatus("org.teiid.designer.core", 1008, statusArray, msg, null);
        }
        return resultStatus;
    }

    private ModelImport createModelImport(Resource eResource, ExternalReferenceVisitor.ExternalReferences externalRefs, List problems, IProgressMonitor monitor) {
        ModelImport existingImport;
        ModelImport theImport = null;
        URI uri = externalRefs.getResourceUri();
        if (uri.isRelative()) {
            return null;
        }
        Resource theResource = externalRefs.getResource();
        ResourceSet eResourceSet = eResource.getResourceSet();
        if (theResource == null) {
            theResource = eResourceSet.getResource(uri, false);
        }
        if (theResource == null) {
            Collection refs = externalRefs.getReferencedObjects();
            theResource = this.getHelper().findResourceWithObject(refs, problems, this.handler);
        }
        if (theResource == null || this.resourceMightBeRefactored(theResource, uri)) {
            theResource = this.getHelper().findRefactoredResource(eResource, uri, monitor, problems);
        }
        if ((existingImport = ModelerCore.getModelEditor().findModelImport((EmfResource)eResource, theResource)) != null) {
            ModelerCore.getModelEditor().updateModelImport(existingImport, theResource);
            theImport = existingImport;
        }
        if (theImport == null && theResource != null) {
            try {
                theImport = ModelerCore.getModelEditor().createModelImport((EmfResource)eResource, theResource);
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
        return theImport;
    }

    private boolean resourceMightBeRefactored(Resource theResource, URI uri) {
        if (uri.isFile()) {
            if (!new File(theResource.getURI().toFileString()).exists()) {
                return false;
            }
            IResource resource = WorkspaceResourceFinderUtil.findIResource(theResource);
            if (resource == null || !resource.exists()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setRefactoredPaths(Collection<PathPair> pathPairs) {
        this.getHelper().setRefactoredPaths(pathPairs);
    }

    private ModelAnnotation getModelAnnotation(Resource resource) {
        if (resource instanceof EmfResource) {
            EmfResource emfResource = (EmfResource)resource;
            return emfResource.getModelAnnotation();
        }
        return null;
    }

    private void adjustReferences(Resource eResource, ExternalReferenceVisitor.ExternalReferences externalRefs, ModelImport modelImport) {
        Resource importedResource = null;
        Container cntr = ModelerCore.getContainer(eResource);
        if (cntr != null) {
            ResourceFinder finder = cntr.getResourceFinder();
            String modelLocation = modelImport.getModelLocation();
            if (modelImport.eResource() == null && !CoreStringUtil.isEmpty((String)modelLocation)) {
                URI modelLocationURI;
                URI baseLocationURI = eResource.getURI();
                boolean isXSD = baseLocationURI.lastSegment().endsWith("xsd");
                URI uRI = modelLocationURI = baseLocationURI.isFile() ? URI.createURI((String)modelLocation, (boolean)false) : URI.createURI((String)modelLocation);
                if (isXSD && baseLocationURI.isHierarchical() && !baseLocationURI.isRelative() && modelLocationURI.isRelative()) {
                    modelLocationURI = modelLocationURI.resolve(baseLocationURI);
                }
                importedResource = modelLocationURI.isRelative() ? finder.findByWorkspaceUri(modelLocationURI, eResource) : finder.findByURI(modelLocationURI, true);
            }
            if (importedResource == null) {
                importedResource = finder.findByImport(modelImport, false);
            }
            if (importedResource != null) {
                Collection refs = externalRefs.getReferencedObjects();
                URI uri = importedResource.getURI();
                for (Object obj : refs) {
                    InternalEObject iobj;
                    if (!(obj instanceof InternalEObject) || !(iobj = (InternalEObject)obj).eIsProxy()) continue;
                    URI existingUri = iobj.eProxyURI();
                    String frag = existingUri.fragment();
                    URI newUri = uri.appendFragment(frag);
                    iobj.eSetProxyURI(newUri);
                }
            }
        }
    }
}

