/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.refactor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.TransactionRunnable;
import org.teiid.designer.core.builder.ModelBuildUtil;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.refactor.RefactorCommand;
import org.teiid.designer.core.refactor.RelatedResourceFinder;
import org.teiid.designer.core.refactor.ResourceStatusList;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.workspace.ModelResource;

public class ObjectDeleteCommand
implements RefactorCommand {
    private static final String PID = "org.teiid.designer.core";
    private static final int ERROR_MISSING_OBJECT = 3001;
    private static final int ERROR_MULTIPLE_FILES = 3002;
    private static final int ERROR_DELETE_NULL = 3003;
    private static final int EXCEPTION_CALCULATING_DEPENDENCIES = 3004;
    private static final int EXCEPTION_DURING_DELETE = 3007;
    private List<EObject> objectsToDelete;
    private String objectName;
    private boolean moreThanOneResource = false;
    private boolean deleteArrayContainsNull = false;
    private List<IStatus> problems = new ArrayList<IStatus>();
    private Collection<IFile> relatedResources = Collections.emptyList();

    private void addProblem(IStatus problem) {
        this.problems.add(problem);
    }

    public void setObjectsToDelete(List<EObject> objects) {
        this.objectsToDelete = objects;
        this.deleteArrayContainsNull = false;
        this.moreThanOneResource = false;
        if (objects != null && objects.size() > 0 && objects.get(0) != null) {
            Resource firstResource = objects.get(0).eResource();
            if (objects.size() > 1) {
                for (EObject eObject : objects) {
                    if (eObject == null || eObject.eResource() == null) {
                        this.deleteArrayContainsNull = true;
                        break;
                    }
                    if (eObject.eResource().equals(firstResource)) continue;
                    this.moreThanOneResource = true;
                    break;
                }
            }
        }
        this.objectName = objects.size() == 1 ? ModelerCore.getModelEditor().getName(objects.get(0)) : ModelerCore.Util.getString("ObjectDeleteCommand.Number_of_objects", (Object)objects.size());
    }

    @Override
    public String getLabel() {
        return ModelerCore.Util.getString("ObjectDeleteCommand.delete_label", (Object)this.objectName);
    }

    @Override
    public String getDescription() {
        Object[] params = new Object[]{this.objectName};
        return ModelerCore.Util.getString("ObjectDeleteCommand.delete_description", params);
    }

    @Override
    public boolean canRedo() {
        return false;
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public IStatus canExecute() {
        if (this.objectsToDelete == null || this.objectsToDelete.size() == 0) {
            String msg = ModelerCore.Util.getString("ObjectDeleteCommand.No_delete_target_selected", new Object[0]);
            Status status = new Status(4, PID, 3001, msg, null);
            return status;
        }
        if (this.moreThanOneResource) {
            String msg = ModelerCore.Util.getString("ObjectDeleteCommand.Delete_from_more_than_one_file", new Object[0]);
            Status status = new Status(4, PID, 3002, msg, null);
            return status;
        }
        if (this.deleteArrayContainsNull) {
            String msg = ModelerCore.Util.getString("ObjectDeleteCommand.Delete_array_contains_null", new Object[0]);
            Status status = new Status(4, PID, 3003, msg, null);
            return status;
        }
        ModelResource modelResource = this.getModelResource();
        if (modelResource == null || modelResource.isReadOnly()) {
            String msg = ModelerCore.Util.getString("ObjectDeleteCommand.Selection_is_read_only", new Object[0]);
            Status status = new Status(4, PID, 1002, msg, null);
            return status;
        }
        Object[] params = new Object[]{this.objectName};
        String msg = ModelerCore.Util.getString("ObjectDeleteCommand.Ready_to_delete", params);
        Status status = new Status(0, PID, 1000, msg, null);
        return status;
    }

    private ModelResource getModelResource() {
        ModelEditor editor = ModelerCore.getModelEditor();
        ModelResource modelResource = editor.findModelResource(this.objectsToDelete.get(0));
        return modelResource;
    }

    public Set<ModelResource> getDependentResources() {
        HashSet<ModelResource> result = new HashSet<ModelResource>();
        HashSet<Resource> emfResourceList = new HashSet<Resource>();
        for (EObject object : this.objectsToDelete) {
            try {
                Collection relatedList = ModelerCore.getModelEditor().findOtherObjectsToBeDeleted(object);
                relatedList = ModelerCore.getModelEditor().findExternalReferencesToObjectsBeingDeleted(object, relatedList);
                for (EObject dependent : relatedList) {
                    Resource resource = dependent.eResource();
                    if (emfResourceList.contains(resource)) continue;
                    emfResourceList.add(resource);
                    result.add(ModelerCore.getModelEditor().findModelResource(resource));
                }
            }
            catch (ModelerCoreException e) {
                String msg = ModelerCore.Util.getString("ObjectDeleteCommand.Error_attempting_calculate_dependencies", (Object)object);
                this.addProblem((IStatus)new Status(4, PID, 3004, msg, (Throwable)e));
            }
        }
        return result;
    }

    private int checkDependentResources() {
        RelatedResourceFinder finder = new RelatedResourceFinder(this.getModelResource().getResource());
        Collection<IFile> searchResults = finder.findRelatedResources(RelatedResourceFinder.Relationship.DEPENDENT);
        ResourceStatusList statusList = new ResourceStatusList(searchResults);
        this.relatedResources = statusList.getResourceList();
        this.problems.addAll(statusList.getProblems());
        return statusList.getHighestSeverity();
    }

    private void validateDependentResources() {
        if (this.relatedResources.isEmpty()) {
            return;
        }
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) {
                Container cont = null;
                try {
                    cont = ModelerCore.getModelContainer();
                }
                catch (CoreException err) {
                    String msg = ModelerCore.Util.getString("ObjectDeleteCommand.doGetContainerProblemMessage", new Object[0]);
                    ModelerCore.Util.log(4, (Throwable)err, msg);
                }
                ModelBuildUtil.validateResources(null, ObjectDeleteCommand.this.relatedResources, cont, false);
                return null;
            }
        };
        try {
            ModelerCore.getModelEditor().executeAsTransaction(runnable, "Updating ModelIndexes", false, false, (Object)this);
        }
        catch (CoreException err) {
            ModelerCore.Util.log((Throwable)err);
        }
    }

    @Override
    public IStatus execute(IProgressMonitor monitor) {
        this.problems.clear();
        try {
            String msg = ModelerCore.Util.getString("ObjectDeleteCommand.Execution_complete", new Object[0]);
            Status result = new Status(0, PID, 1001, msg, null);
            if (result.getSeverity() == 4) {
                Status status = result;
                return status;
            }
            int severity = this.checkDependentResources();
            if (severity >= 4) {
                msg = ModelerCore.Util.getString("ObjectDeleteCommand.Dependent_resource_error", new Object[0]);
                Status status = new Status(severity, PID, 1002, msg, null);
                return status;
            }
            try {
                ModelerCore.getModelEditor().delete(this.objectsToDelete, monitor);
            }
            catch (ModelerCoreException e) {
                Object[] params = new Object[]{this.objectName};
                msg = ModelerCore.Util.getString("ObjectDeleteCommand.Error_attempting_to_delete", params);
                Status status = new Status(4, PID, 3007, msg, (Throwable)e);
                if (monitor != null) {
                    monitor.done();
                }
                return status;
            }
            this.validateDependentResources();
            Status status = result;
            return status;
        }
        catch (Exception ex) {
            Status status = new Status(4, PID, ex.getMessage(), (Throwable)ex);
            return status;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public IStatus undo(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus redo(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    @Override
    public Collection<Object> getResult() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getAffectedObjects() {
        return Collections.emptyList();
    }

    @Override
    public Collection<IStatus> getPostExecuteMessages() {
        return this.problems;
    }
}

