/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ResourceFinder;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.ModelImport;

public class UnresolvedModelImportRule
implements ObjectValidationRule {
    @Override
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(ModelImport.class, (Object)eObject);
        ModelImport modelImport = (ModelImport)eObject;
        String location = modelImport.getModelLocation();
        Resource resource = eObject.eResource();
        if (resource == null || location == null) {
            ValidationResultImpl result = new ValidationResultImpl(eObject, resource);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, ModelerCore.Util.getString("UnresolvedModelImportRule.0", new Object[0]), UnresolvedModelImportRule.getLocationPath((EObject)modelImport), UnresolvedModelImportRule.getURIString((EObject)modelImport));
            result.addProblem(problem);
            context.addResult(result);
            return;
        }
        Container container = context.getResourceContainer();
        if (container != null) {
            URI uri;
            ResourceFinder finder = container.getResourceFinder();
            if (finder.isBuiltInResource(uri = URI.createURI((String)location))) {
                return;
            }
            Resource importResource = finder.findByImport(modelImport, true);
            if (importResource == null) {
                ValidationResultImpl result = new ValidationResultImpl(eObject, eObject.eResource());
                String msg = ModelerCore.Util.getString("UnresolvedModelImportRule.The_model_import_cannot_be_resolved", (Object)location);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg, UnresolvedModelImportRule.getLocationPath((EObject)modelImport), UnresolvedModelImportRule.getURIString((EObject)modelImport));
                result.addProblem(problem);
                context.addResult(result);
                return;
            }
            URI resourceURI = resource.getURI();
            URI importURI = importResource.getURI();
            if (resourceURI.isFile() && importURI.isFile()) {
                URI deresolvedURI;
                boolean deresolve;
                boolean bl = deresolve = !resourceURI.isRelative() && resourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(resourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
                if (!location.equals(URI.decode((String)importURI.toString()))) {
                    ValidationResultImpl result = new ValidationResultImpl(eObject, eObject.eResource());
                    String msg = ModelerCore.Util.getString("UnresolvedModelImportRule.The_model_import_cannot_be_resolved", (Object)location);
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg, UnresolvedModelImportRule.getLocationPath((EObject)modelImport), UnresolvedModelImportRule.getURIString((EObject)modelImport));
                    result.addProblem(problem);
                    context.addResult(result);
                }
            }
        }
    }

    private static String getURIString(EObject eoj) {
        return ModelerCore.getModelEditor().getUri(eoj).toString();
    }

    private static String getLocationPath(EObject eoj) {
        return ModelerCore.getModelEditor().getModelRelativePath(eoj).toString();
    }
}

