/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.container;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ObjectManager;
import org.teiid.designer.core.resource.EmfResourceSetImpl;
import org.teiid.designer.core.util.AbstractFinder;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;

public class DefaultEObjectFinder
extends AbstractFinder {
    private final Container container;

    public DefaultEObjectFinder(Container container) {
        this.container = container;
    }

    public Object find(Object key) {
        if (key instanceof URI) {
            return this.getResourceSet().getEObject((URI)key, true);
        }
        if (key instanceof String) {
            Object obj;
            int index;
            String id = (String)key;
            if (CoreStringUtil.startsWithIgnoreCase((String)id, (String)"mmuuid")) {
                try {
                    return this.findByObjectID(IDGenerator.getInstance().stringToObject(id.toLowerCase()), true);
                }
                catch (InvalidIDException e) {
                    throw new ModelerCoreRuntimeException(e.getMessage());
                }
            }
            if (id.indexOf("#mmuuid") != -1 && (index = id.indexOf("#")) != 0 && (obj = this.find(id.substring(index + 1))) != null) {
                String namespaceUri = id.substring(0, index);
                try {
                    String uri;
                    ModelResource model = ModelUtil.getModel(obj);
                    if (model != null && (uri = model.getModelAnnotation().getNamespaceUri()) != null && uri.equals(namespaceUri)) {
                        return obj;
                    }
                }
                catch (ModelWorkspaceException theException) {
                    ModelerCore.Util.log(4, (Throwable)((Object)theException), theException.getLocalizedMessage());
                }
            }
        } else if (key instanceof ObjectID) {
            return this.findByObjectID((ObjectID)key, true);
        }
        throw new ModelerCoreRuntimeException(String.valueOf(ModelerCore.Util.getString("ContainerImpl.Invalid_key_object_in_Finder.find_method____6", new Object[0])) + key);
    }

    @Override
    public Object findKey(Object object) {
        if (object instanceof EObject) {
            return ModelerCore.getObjectId((EObject)object);
        }
        return null;
    }

    protected ResourceSet getResourceSet() {
        return this.container.getResourceSet();
    }

    protected ObjectManager getObjectManager() {
        return this.container.getObjectManager();
    }

    protected Object findByObjectID(ObjectID objectID, boolean searchExternalResourceSets) {
        Object result = this.getObjectManager().findEObject(objectID.toString());
        if (result == null && searchExternalResourceSets && this.getResourceSet() instanceof EmfResourceSetImpl) {
            ResourceSet[] externalResourceSets = ((EmfResourceSetImpl)this.getResourceSet()).getExternalResourceSets();
            int i = 0;
            while (i != externalResourceSets.length) {
                ResourceSet resourceSet = externalResourceSets[i];
                if (resourceSet instanceof Container) {
                    result = ((Container)resourceSet).getEObjectFinder().find((Object)objectID);
                }
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }
}

