/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.compare;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingFactory;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.compare.AbstractEObjectMatcher;

public class UuidEObjectMatcher
extends AbstractEObjectMatcher {
    @Override
    public void addMappingsForRoots(List inputs, List outputs, Mapping mapping, MappingFactory factory) {
    }

    @Override
    public void addMappings(EReference reference, List inputs, List outputs, Mapping mapping, MappingFactory factory) {
        HashMap<ObjectID, EObject> idToInput = new HashMap<ObjectID, EObject>();
        for (EObject obj : inputs) {
            ObjectID id = this.getObjectId(obj);
            if (id == null) continue;
            idToInput.put(id, obj);
        }
        Iterator outputIter = outputs.iterator();
        while (outputIter.hasNext()) {
            EClass outputMetaclass;
            EObject output = (EObject)outputIter.next();
            ObjectID id = this.getObjectId(output);
            EObject input = (EObject)idToInput.get(id);
            if (input == null) continue;
            if (input.eIsProxy() || output.eIsProxy()) {
                inputs.remove(input);
                outputIter.remove();
                this.addMapping(input, output, mapping, factory);
                continue;
            }
            EClass inputMetaclass = input.eClass();
            if (!inputMetaclass.equals(outputMetaclass = output.eClass())) continue;
            inputs.remove(input);
            outputIter.remove();
            this.addMapping(input, output, mapping, factory);
        }
    }

    private ObjectID getObjectId(EObject eo) {
        ObjectID uuid = null;
        if (eo == null) {
            return uuid;
        }
        if (eo.eIsProxy()) {
            if (eo instanceof EObjectImpl) {
                URI uri = ((EObjectImpl)eo).eProxyURI();
                String sUUIDFrag = uri.fragment();
                uuid = this.getObjectIDFromString(sUUIDFrag);
            }
        } else {
            uuid = ModelerCore.getObjectId(eo);
        }
        return uuid;
    }

    private ObjectID getObjectIDFromString(String uuidString) {
        if (uuidString == null || uuidString.length() == 0) {
            return null;
        }
        try {
            return IDGenerator.getInstance().stringToObject(uuidString);
        }
        catch (InvalidIDException invalidIDException) {
            return null;
        }
    }
}

