/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.compare;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingFactory;
import org.teiid.designer.core.compare.AbstractEObjectMatcher;

public class EProxyUriMatcher
extends AbstractEObjectMatcher {
    @Override
    public void addMappingsForRoots(List inputs, List outputs, Mapping mapping, MappingFactory factory) {
        this.addMappings(null, inputs, outputs, mapping, factory);
    }

    @Override
    public void addMappings(EReference reference, List inputs, List outputs, Mapping mapping, MappingFactory factory) {
        HashMap<String, EObject> inputByCompareString = new HashMap<String, EObject>();
        HashMap<String, EObject> proxyinputByCompareString = new HashMap<String, EObject>();
        for (EObject obj : inputs) {
            String key = this.getProxyURICompareString(obj);
            if (key != null) {
                proxyinputByCompareString.put(key, obj);
                continue;
            }
            key = this.getURICompareString(obj);
            inputByCompareString.put(key, obj);
        }
        Iterator outputIter = outputs.iterator();
        while (outputIter.hasNext()) {
            EClass outputMetaclass;
            EClass inputMetaclass;
            EObject output = (EObject)outputIter.next();
            EObject inputEntity = null;
            String key = this.getProxyURICompareString(output);
            if (key != null) {
                inputEntity = (EObject)inputByCompareString.get(key);
                if (inputEntity != null) {
                    inputEntity = (EObject)proxyinputByCompareString.get(key);
                }
            } else {
                key = this.getURICompareString(output);
                inputEntity = (EObject)proxyinputByCompareString.get(key);
            }
            if (inputEntity == null || !(inputMetaclass = inputEntity.eClass()).equals(outputMetaclass = output.eClass())) continue;
            inputs.remove(inputEntity);
            outputIter.remove();
            this.addMapping(inputEntity, output, mapping, factory);
        }
    }

    protected String getURICompareString(EObject eObject) {
        URI uri = EcoreUtil.getURI((EObject)eObject);
        return this.getURICompareString(uri);
    }

    protected String getProxyURICompareString(EObject entity) {
        if (entity != null && entity.eIsProxy() && entity instanceof InternalEObject) {
            InternalEObject internalEObj = (InternalEObject)entity;
            URI proxyURI = internalEObj.eProxyURI();
            return this.getURICompareString(proxyURI);
        }
        return null;
    }

    protected String getURICompareString(URI uri) {
        if (uri != null) {
            String lastFragment = uri.lastSegment();
            String fragment = uri.fragment();
            if (lastFragment != null && fragment != null) {
                return String.valueOf(lastFragment) + fragment;
            }
            return lastFragment;
        }
        return null;
    }
}

