/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.mapping.Mapping;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.search.ModelWorkspaceSearch;
import org.teiid.designer.core.search.runtime.ReferencesRecord;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramEntity;
import org.teiid.designer.metamodels.transformation.InputBinding;
import org.teiid.designer.metamodels.transformation.InputParameter;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.transformation.SqlAlias;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;

public class FindRelatedObjectsToDeleted
implements ModelVisitor {
    private final List additionalDeleteCommands;
    private final EditingDomain editingDomain;
    private Collection deletedObjects;
    private LinkedList objectsForDeleteProcess;
    private final ModelWorkspaceSearch workspaceSearch;

    public FindRelatedObjectsToDeleted(EObject deletedObject, EditingDomain editingDomain, LinkedList objectsForDeleteProcess, Collection deletedObjects) {
        this(deletedObject, editingDomain, objectsForDeleteProcess, deletedObjects, new ModelWorkspaceSearch());
    }

    public FindRelatedObjectsToDeleted(EObject deletedObject, EditingDomain editingDomain, LinkedList objectsForDeleteProcess, Collection deletedObjects, ModelWorkspaceSearch workspaceSearch) {
        CoreArgCheck.isNotNull((Object)objectsForDeleteProcess);
        CoreArgCheck.isNotNull((Object)editingDomain);
        CoreArgCheck.isNotNull((Object)workspaceSearch);
        this.additionalDeleteCommands = new ArrayList();
        this.editingDomain = editingDomain;
        this.objectsForDeleteProcess = objectsForDeleteProcess;
        this.deletedObjects = deletedObjects;
        if (this.deletedObjects == null) {
            this.deletedObjects = new HashSet();
        }
        this.workspaceSearch = workspaceSearch;
        if (deletedObject != null) {
            this.deletedObjects.add(deletedObject);
            TreeIterator iter = deletedObject.eAllContents();
            while (iter.hasNext()) {
                Object child = iter.next();
                if (!(child instanceof EObject)) continue;
                this.deletedObjects.add(child);
            }
        }
    }

    @Override
    public boolean visit(EObject object) {
        Collection refRecords;
        ModelEditorImpl modelEditor = (ModelEditorImpl)ModelerCore.getModelEditor();
        String objID = modelEditor.getSearchIndexObjectID(object);
        if (objID != null && this.workspaceSearch != null && (refRecords = this.workspaceSearch.getUniDirectionalReferencesTo(objID)) != null && !refRecords.isEmpty()) {
            for (ReferencesRecord refRecord : refRecords) {
                String refUUID = refRecord.getUUID();
                EObject refrencingObj = modelEditor.findObject(refUUID);
                if (refrencingObj == null) continue;
                try {
                    if (refrencingObj.eIsProxy()) {
                        ContainerImpl cntr = (ContainerImpl)ModelerCore.getModelContainer();
                        refrencingObj = EcoreUtil.resolve((EObject)refrencingObj, (ResourceSet)cntr.getResourceSet());
                    }
                }
                catch (Exception exception) {}
                this.deleteObjectAsNeeded(refrencingObj);
            }
        }
        this.objectsForDeleteProcess.remove(object);
        return true;
    }

    @Override
    public boolean visit(Resource resource) {
        return false;
    }

    public void deleteObjectAsNeeded(EObject referencingObj) {
        EObject parent = referencingObj.eContainer();
        if (this.deletedObjects.contains(referencingObj) || parent != null && this.deletedObjects.contains(parent)) {
            return;
        }
        if (referencingObj instanceof Annotation) {
            Annotation annotation = (Annotation)referencingObj;
            EObject target = annotation.getAnnotatedObject();
            if (target == null || this.deletedObjects.contains(target)) {
                this.delete(referencingObj);
            }
            return;
        }
        if (referencingObj instanceof DiagramEntity) {
            DiagramEntity entity = (DiagramEntity)referencingObj;
            EObject target = entity.getModelObject();
            if (this.deletedObjects.contains(target)) {
                this.delete(referencingObj);
            }
            return;
        }
        if (referencingObj instanceof InputBinding) {
            InputBinding binding = (InputBinding)referencingObj;
            InputParameter inputParam = binding.getInputParameter();
            InputSet inputSet = inputParam.getInputSet();
            MappingClassColumn mcCol = binding.getMappingClassColumn();
            if (this.deletedObjects.contains(inputParam) || this.deletedObjects.contains(inputSet) || this.deletedObjects.contains(mcCol)) {
                this.delete(referencingObj);
            }
            return;
        }
        if (referencingObj instanceof TransformationMappingRoot) {
            TransformationMappingRoot mappingRoot = (TransformationMappingRoot)referencingObj;
            EObject target = mappingRoot.getTarget();
            if (this.deletedObjects.contains(target)) {
                this.delete(referencingObj);
                return;
            }
            boolean doDelete = true;
            if (mappingRoot.getOutputs() != null && !mappingRoot.getOutputs().isEmpty()) {
                Iterator outputs = mappingRoot.getOutputs().iterator();
                while (outputs.hasNext() && doDelete) {
                    Object next = outputs.next();
                    if (next instanceof MappingClass) {
                        MappingClass mc = (MappingClass)next;
                        if (this.deletedObjects.contains(mc.getMappingClassSet())) continue;
                        doDelete = false;
                        continue;
                    }
                    if (this.deletedObjects.contains(next)) continue;
                    doDelete = false;
                }
            }
            if (doDelete) {
                this.delete(referencingObj);
            }
            return;
        }
        if (referencingObj instanceof MappingClassSet) {
            MappingClassSet mcSet = (MappingClassSet)referencingObj;
            EObject target = mcSet.getTarget();
            if (this.deletedObjects.contains(target)) {
                this.delete(referencingObj);
            }
            return;
        }
        if (referencingObj instanceof Diagram) {
            Diagram diagram = (Diagram)referencingObj;
            EObject target = diagram.getTarget();
            if (this.deletedObjects.contains(target)) {
                this.delete(referencingObj);
            }
            return;
        }
        if (referencingObj instanceof Mapping) {
            Mapping mapping = (Mapping)referencingObj;
            EList outputs = mapping.getOutputs();
            EList inputs = mapping.getInputs();
            if (outputs.isEmpty()) {
                this.delete(referencingObj);
                return;
            }
            if (outputs.size() == 1) {
                EObject outputObj = (EObject)outputs.iterator().next();
                if (this.deletedObjects.contains(outputObj)) {
                    this.delete(referencingObj);
                    return;
                }
                if (AspectManager.getSqlAspect(outputObj) instanceof SqlColumnAspect) {
                    if (inputs.isEmpty()) {
                        this.delete(referencingObj);
                        return;
                    }
                    Object inputObj = inputs.iterator().next();
                    if (this.deletedObjects.contains(inputObj)) {
                        this.delete(referencingObj);
                        return;
                    }
                }
            }
            return;
        }
        if (referencingObj instanceof SqlAlias) {
            SqlAlias sqlAlias = (SqlAlias)referencingObj;
            EObject target = sqlAlias.getAliasedObject();
            if (this.deletedObjects.contains(target)) {
                this.delete(referencingObj);
            }
            return;
        }
    }

    protected void delete(EObject eObject) {
        if (this.deletedObjects.contains(eObject)) {
            return;
        }
        Command command = ModelEditorImpl.createDeleteCommand(this.editingDomain, eObject);
        if (command != null) {
            this.additionalDeleteCommands.add(command);
        }
        this.objectsForDeleteProcess.addLast(eObject);
        TreeIterator iter = eObject.eAllContents();
        while (iter.hasNext()) {
            Object child = iter.next();
            if (!(child instanceof EObject) || this.deletedObjects.contains(child)) continue;
            this.objectsForDeleteProcess.addLast(child);
            this.deletedObjects.add(child);
        }
        this.deletedObjects.add(eObject);
    }

    public List getAdditionalDeleteCommands() {
        return this.additionalDeleteCommands;
    }

    public Collection getAllDeletedObjects() {
        return this.deletedObjects;
    }
}

