/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.html.Option;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.ICompareCriteria;
import org.teiid.designer.query.sql.lang.ICompoundCriteria;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.IFrom;
import org.teiid.designer.query.sql.lang.IGroupBy;
import org.teiid.designer.query.sql.lang.IIsNullCriteria;
import org.teiid.designer.query.sql.lang.IMatchCriteria;
import org.teiid.designer.query.sql.lang.IOrderBy;
import org.teiid.designer.query.sql.lang.ISelect;
import org.teiid.designer.query.sql.lang.ISetCriteria;
import org.teiid.designer.query.sql.lang.ISubqueryContainer;
import org.teiid.designer.query.sql.lang.IUnaryFromClause;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IScalarSubquery;
import org.teiid.designer.query.sql.symbol.ISymbol;
import org.teiid.query.ui.UiPlugin;
import org.teiid.query.ui.sqleditor.component.DeleteDisplayNode;
import org.teiid.query.ui.sqleditor.component.DisplayNode;
import org.teiid.query.ui.sqleditor.component.DisplayNodeConstants;
import org.teiid.query.ui.sqleditor.component.DisplayNodeFactory;
import org.teiid.query.ui.sqleditor.component.HavingDisplayNode;
import org.teiid.query.ui.sqleditor.component.QueryDisplayNode;
import org.teiid.query.ui.sqleditor.component.SelectDisplayNode;
import org.teiid.query.ui.sqleditor.component.SeparatorDisplayNode;
import org.teiid.query.ui.sqleditor.component.UpdateDisplayNode;
import org.teiid.query.ui.sqleditor.component.WhereDisplayNode;

public final class DisplayNodeUtils
implements DisplayNodeConstants {
    public static boolean isIndexRightAfterComma(List displayNodes, int index) {
        List leadingNodes = DisplayNodeUtils.getDisplayNodesBeforeIndex(displayNodes, index);
        int nLeading = leadingNodes.size();
        int i = nLeading - 1;
        while (i >= 0) {
            DisplayNode node = (DisplayNode)leadingNodes.get(i);
            if (node instanceof SeparatorDisplayNode) {
                String nodeStr = node.toString();
                if (nodeStr.indexOf(",") != -1) {
                    return true;
                }
            } else {
                return false;
            }
            --i;
        }
        return false;
    }

    public static boolean isIndexRightBeforeComma(List displayNodes, int index) {
        List trailingNodes = DisplayNodeUtils.getDisplayNodesAfterIndex(displayNodes, index);
        for (DisplayNode node : trailingNodes) {
            if (node instanceof SeparatorDisplayNode) {
                String nodeStr = node.toString();
                if (nodeStr.indexOf(",") == -1) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static List<DisplayNode> getDisplayNodesAtIndex(List<DisplayNode> displayNodes, int index) {
        ArrayList<DisplayNode> validNodes = new ArrayList<DisplayNode>(2);
        for (DisplayNode displayNode : displayNodes) {
            if (displayNode.getStartIndex() > index) break;
            if (displayNode.getEndIndex() + 1 < index) continue;
            List<DisplayNode> childNodes = DisplayNodeUtils.getDisplayNodesAtIndex(displayNode.getChildren(), index);
            if (childNodes.isEmpty()) {
                validNodes.add(displayNode);
                continue;
            }
            if (childNodes.size() == 1) {
                validNodes.addAll(childNodes);
                continue;
            }
            return childNodes;
        }
        return validNodes;
    }

    public static List getDisplayNodesBeforeIndex(List displayNodes, int index) {
        ArrayList<DisplayNode> validNodes = new ArrayList<DisplayNode>(0);
        for (DisplayNode node : displayNodes) {
            int nodeEndIndex = node.getEndIndex();
            if (nodeEndIndex >= index) break;
            validNodes.add(node);
        }
        return validNodes;
    }

    public static List getDisplayNodesAfterIndex(List displayNodes, int index) {
        ArrayList<DisplayNode> validNodes = new ArrayList<DisplayNode>(0);
        for (DisplayNode node : displayNodes) {
            int nodeStartIndex = node.getStartIndex();
            if (nodeStartIndex < index) continue;
            validNodes.add(node);
        }
        return validNodes;
    }

    public static boolean hasSymbol(DisplayNode node) {
        if (node == null) {
            return false;
        }
        if (DisplayNodeUtils.isSymbolNode(node)) {
            return true;
        }
        List nodes = node.getDisplayNodeList();
        for (DisplayNode displayNode : nodes) {
            if (!DisplayNodeUtils.isSymbolNode(displayNode)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExpression(DisplayNode node) {
        if (node.languageObject != null && node.languageObject instanceof IExpression) {
            return true;
        }
        List nodes = node.getDisplayNodeList();
        for (DisplayNode displayNode : nodes) {
            if (DisplayNodeUtils.getExpressionForNode(displayNode) == null) continue;
            return true;
        }
        return false;
    }

    public static int getStartIndexOfNextSymbol(DisplayNode node, int index) {
        if (DisplayNodeUtils.isSymbolNode(node)) {
            if (node.isAnywhereWithin(index)) {
                return node.getStartIndex();
            }
            return -1;
        }
        List nodes = node.getDisplayNodeList();
        for (DisplayNode displayNode : nodes) {
            if (!DisplayNodeUtils.isSymbolNode(displayNode) || displayNode.getStartIndex() < index) continue;
            return displayNode.getStartIndex();
        }
        return -1;
    }

    public static int getEndIndexOfPreviousSymbol(DisplayNode node, int index) {
        int prevEnd = -1;
        if (DisplayNodeUtils.isSymbolNode(node)) {
            if (node.isAnywhereWithin(index)) {
                return node.getEndIndex() + 1;
            }
            return prevEnd;
        }
        List nodes = node.getDisplayNodeList();
        for (DisplayNode displayNode : nodes) {
            if (displayNode.getEndIndex() >= index) break;
            if (!DisplayNodeUtils.isSymbolNode(displayNode)) continue;
            prevEnd = displayNode.getEndIndex() + 1;
        }
        return prevEnd;
    }

    public static int getStartIndexOfNextExpression(DisplayNode node, int index) {
        if (node.languageObject != null && node.languageObject instanceof IExpression) {
            if (node.isAnywhereWithin(index)) {
                return node.getStartIndex();
            }
            return -1;
        }
        List nodes = node.getDisplayNodeList();
        for (DisplayNode displayNode : nodes) {
            if (!displayNode.isInExpression() || displayNode.getStartIndex() < index) continue;
            return displayNode.getStartIndex();
        }
        return -1;
    }

    public static int getEndIndexOfPreviousExpression(DisplayNode node, int index) {
        int prevEnd = -1;
        if (node.languageObject != null && node.languageObject instanceof IExpression) {
            if (node.isAnywhereWithin(index)) {
                return node.getEndIndex() + 1;
            }
            return prevEnd;
        }
        List nodes = node.getDisplayNodeList();
        for (DisplayNode displayNode : nodes) {
            if (displayNode.getEndIndex() >= index) break;
            if (!displayNode.isInExpression()) continue;
            prevEnd = displayNode.getEndIndex() + 1;
        }
        return prevEnd;
    }

    public static boolean isIndexAtClauseStart(DisplayNode clauseNode, int index) {
        if (clauseNode != null && DisplayNodeUtils.isClauseNode(clauseNode)) {
            List displayNodes = clauseNode.getDisplayNodeList();
            List leadingNodes = DisplayNodeUtils.getDisplayNodesBeforeIndex(displayNodes, index);
            for (DisplayNode node : leadingNodes) {
                if (node.languageObject == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isIndexAtClauseEnd(DisplayNode clauseNode, int index) {
        if (clauseNode != null && DisplayNodeUtils.isClauseNode(clauseNode)) {
            List displayNodes = clauseNode.getDisplayNodeList();
            List trailingNodes = DisplayNodeUtils.getDisplayNodesAfterIndex(displayNodes, index);
            for (DisplayNode node : trailingNodes) {
                if (node instanceof SeparatorDisplayNode) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isClauseNode(DisplayNode clauseNode) {
        if (clauseNode instanceof SelectDisplayNode) {
            return true;
        }
        if (clauseNode.languageObject instanceof IFrom) {
            return true;
        }
        if (clauseNode instanceof WhereDisplayNode) {
            return true;
        }
        if (clauseNode.languageObject instanceof IGroupBy) {
            return true;
        }
        if (clauseNode instanceof HavingDisplayNode) {
            return true;
        }
        if (clauseNode.languageObject instanceof IOrderBy) {
            return true;
        }
        return clauseNode.languageObject instanceof Option;
    }

    public static boolean isCommandNode(DisplayNode node) {
        return node.getLanguageObject() instanceof ICommand;
    }

    public static boolean canInsertBefore(DisplayNode node, int type) {
        return DisplayNodeUtils.canInsertNextTo(node, type);
    }

    public static boolean canInsertAfter(DisplayNode node, int type) {
        return DisplayNodeUtils.canInsertNextTo(node, type);
    }

    private static boolean canInsertNextTo(DisplayNode node, int type) {
        boolean result = false;
        if (type == 3) {
            DisplayNode clauseNode = DisplayNodeUtils.getNodeTypeForNode(node, 5);
            if (clauseNode != null && clauseNode.supportsExpression()) {
                result = true;
            }
        } else if (type == 2 && !node.isInCriteria()) {
            UpdateDisplayNode updateNode;
            DisplayNode whereClause;
            DisplayNode commandNode = DisplayNodeUtils.getNodeTypeForNode(node, 4);
            if (commandNode instanceof QueryDisplayNode) {
                QueryDisplayNode queryNode = (QueryDisplayNode)commandNode;
                DisplayNode whereClause2 = queryNode.getClauseDisplayNode(9);
                DisplayNode fromClause = queryNode.getClauseDisplayNode(8);
                if (whereClause2 == null && fromClause != null) {
                    result = true;
                }
            } else if (commandNode instanceof DeleteDisplayNode) {
                DeleteDisplayNode deleteNode = (DeleteDisplayNode)commandNode;
                DisplayNode whereClause3 = deleteNode.getClauseDisplayNode(9);
                if (whereClause3 == null) {
                    result = true;
                }
            } else if (commandNode instanceof UpdateDisplayNode && (whereClause = (updateNode = (UpdateDisplayNode)commandNode).getClauseDisplayNode(9)) == null) {
                result = true;
            }
        }
        return result;
    }

    public static boolean isIndexWithin(List nodeList, int index, int nodeType) {
        boolean result = false;
        List<DisplayNode> nodes = DisplayNodeUtils.getDisplayNodesAtIndex(nodeList, index);
        if (nodes.size() == 2) {
            DisplayNode node1 = nodes.get(0);
            DisplayNode node2 = nodes.get(1);
            result = DisplayNodeUtils.isNodeWithin(node2, nodeType) ? true : DisplayNodeUtils.isNodeWithin(node1, nodeType);
        } else if (nodes.size() == 1 && DisplayNodeUtils.isNodeWithin(nodes.get(0), nodeType)) {
            result = true;
        }
        return result;
    }

    public static boolean isNodeWithin(DisplayNode node, int nodeType) {
        if (nodeType == 3) {
            return DisplayNodeUtils.isWithinExpression(node);
        }
        if (nodeType == 2) {
            return DisplayNodeUtils.isWithinCriteria(node);
        }
        if (nodeType == 14) {
            return DisplayNodeUtils.isWithinEditableCriteria(node);
        }
        if (nodeType == 6) {
            return DisplayNodeUtils.isWithinSelect(node);
        }
        if (nodeType == 8) {
            return DisplayNodeUtils.isWithinFrom(node);
        }
        if (nodeType == 4) {
            return DisplayNodeUtils.isWithinCommand(node);
        }
        return false;
    }

    public static boolean isWithinCriteria(DisplayNode displayNode) {
        return DisplayNodeUtils.getCriteriaForNode(displayNode) != null;
    }

    public static boolean isWithinEditableCriteria(DisplayNode displayNode) {
        DisplayNode criteriaDN = DisplayNodeUtils.getCriteriaForNode(displayNode);
        return DisplayNodeUtils.isEditableCriteria(criteriaDN);
    }

    public static boolean isEditableCriteria(DisplayNode criteriaDN) {
        boolean result = false;
        if (criteriaDN != null && (criteriaDN.languageObject instanceof ICompoundCriteria || criteriaDN.languageObject instanceof ICompareCriteria || criteriaDN.languageObject instanceof IIsNullCriteria || criteriaDN.languageObject instanceof IMatchCriteria || criteriaDN.languageObject instanceof ISetCriteria)) {
            result = true;
        }
        return result;
    }

    public static boolean isWithinExpression(DisplayNode displayNode) {
        return DisplayNodeUtils.getExpressionForNode(displayNode) != null;
    }

    public static boolean isWithinSelect(DisplayNode displayNode) {
        if (displayNode.languageObject instanceof ISelect) {
            return true;
        }
        DisplayNode parentNode = displayNode.getParent();
        while (parentNode != null) {
            if (parentNode instanceof SelectDisplayNode) {
                return true;
            }
            parentNode = parentNode.getParent();
        }
        return false;
    }

    public static boolean isWithinFrom(DisplayNode displayNode) {
        if (displayNode.languageObject instanceof IFrom) {
            return true;
        }
        DisplayNode parentNode = displayNode.getParent();
        while (parentNode != null) {
            if (parentNode.languageObject instanceof IFrom) {
                return true;
            }
            parentNode = parentNode.getParent();
        }
        return false;
    }

    public static boolean isWithinCommand(DisplayNode displayNode) {
        if (DisplayNodeUtils.isCommandNode(displayNode)) {
            return true;
        }
        DisplayNode parentNode = displayNode.getParent();
        while (parentNode != null) {
            if (DisplayNodeUtils.isCommandNode(parentNode)) {
                return true;
            }
            parentNode = parentNode.getParent();
        }
        return false;
    }

    public static boolean isWithinSubQueryNode(DisplayNode displayNode) {
        DisplayNode parentNode = displayNode;
        while (parentNode != null) {
            if (parentNode.languageObject instanceof ISubqueryContainer) {
                return true;
            }
            parentNode = parentNode.getParent();
        }
        return false;
    }

    public static boolean isSymbolNode(DisplayNode node) {
        return node.languageObject instanceof ISymbol || node.languageObject instanceof IElementSymbol || node.languageObject instanceof IUnaryFromClause;
    }

    public static boolean isInsertAllowed(List nodeList, int index, int nodeType) {
        DisplayNode node1;
        boolean result = false;
        List<DisplayNode> nodes = DisplayNodeUtils.getDisplayNodesAtIndex(nodeList, index);
        if (nodes.size() == 2) {
            DisplayNode node12 = nodes.get(0);
            DisplayNode node2 = nodes.get(1);
            result = DisplayNodeUtils.canInsertBefore(node2, nodeType) ? true : DisplayNodeUtils.canInsertAfter(node12, nodeType);
        } else if (nodes.size() == 1 && DisplayNodeUtils.canInsertAfter(node1 = nodes.get(0), nodeType)) {
            result = true;
        }
        return result;
    }

    public static DisplayNode getNodeTypeAtIndex(List nodeList, int index, int nodeType) {
        DisplayNode result = null;
        List<DisplayNode> nodes = DisplayNodeUtils.getDisplayNodesAtIndex(nodeList, index);
        int nNodes = nodes.size();
        if (nNodes == 1) {
            DisplayNode node = nodes.get(0);
            return DisplayNodeUtils.getNodeTypeAtIndex(node, index, nodeType);
        }
        if (nNodes == 2) {
            DisplayNode node = nodes.get(1);
            result = DisplayNodeUtils.getNodeTypeForNode(node, nodeType);
            if (result != null) {
                return result;
            }
            node = nodes.get(0);
            result = DisplayNodeUtils.getNodeTypeForNode(node, nodeType);
        }
        return result;
    }

    public static DisplayNode getNodeTypeAtIndex(DisplayNode parentNode, int index, int nodeType) {
        DisplayNode theNode;
        if (parentNode != null && parentNode.isAnywhereWithin(index) && (theNode = DisplayNodeUtils.getNodeTypeForNode(parentNode, nodeType)) != null) {
            return theNode;
        }
        if (parentNode != null) {
            for (DisplayNode node : parentNode.getChildren()) {
                DisplayNode theNode2 = DisplayNodeUtils.getNodeTypeAtIndex(node, index, nodeType);
                if (theNode2 == null) continue;
                return theNode2;
            }
        }
        return null;
    }

    public static DisplayNode getNodeTypeForNode(DisplayNode node, int nodeType) {
        if (nodeType == 3) {
            return DisplayNodeUtils.getExpressionForNode(node);
        }
        if (nodeType == 2) {
            return DisplayNodeUtils.getCriteriaForNode(node);
        }
        if (nodeType == 4) {
            return DisplayNodeUtils.getCommandForNode(node);
        }
        if (nodeType == 5) {
            return DisplayNodeUtils.getClauseForNode(node);
        }
        return null;
    }

    public static DisplayNode getCriteriaForNode(DisplayNode node) {
        return node.getCriteria();
    }

    public static DisplayNode getCriteriaInNode(DisplayNode node) {
        if (node.languageObject instanceof ICriteria) {
            return node;
        }
        DisplayNode nextNode = null;
        Iterator<DisplayNode> iter = node.getChildren().iterator();
        if (iter.hasNext()) {
            nextNode = iter.next();
            return DisplayNodeUtils.getCriteriaInNode(nextNode);
        }
        return null;
    }

    public static DisplayNode getExpressionForNode(DisplayNode node) {
        if (node == null) {
            return null;
        }
        if (node.languageObject instanceof IElementSymbol) {
            if (node.isInExpression()) {
                return node.getExpression();
            }
            return null;
        }
        if (node.languageObject != null && node.languageObject instanceof IExpression && !(node.languageObject instanceof IScalarSubquery)) {
            return node;
        }
        if (node.isInExpression()) {
            return node.getExpression();
        }
        return null;
    }

    public static DisplayNode getCommandForNode(DisplayNode node) {
        if (node == null) {
            return null;
        }
        DisplayNode parentNode = node;
        while (parentNode != null) {
            if (DisplayNodeUtils.isCommandNode(parentNode)) {
                return parentNode;
            }
            parentNode = parentNode.getParent();
        }
        return null;
    }

    public static DisplayNode getClauseForNode(DisplayNode node) {
        DisplayNode result = null;
        if (node != null) {
            if (DisplayNodeUtils.isClauseNode(node)) {
                result = node;
            } else {
                DisplayNode parentNode = node.getParent();
                while (parentNode != null) {
                    if (DisplayNodeUtils.isClauseNode(parentNode)) {
                        result = parentNode;
                        break;
                    }
                    parentNode = parentNode.getParent();
                }
            }
        }
        return result;
    }

    public static boolean isClauseCROn() {
        UiPlugin uiPlugin = UiPlugin.getDefault();
        if (uiPlugin != null) {
            return uiPlugin.getPreferenceStore().getBoolean("startClausesOnNewLine");
        }
        return true;
    }

    public static boolean isClauseIndentOn() {
        UiPlugin uiPlugin = UiPlugin.getDefault();
        if (uiPlugin != null) {
            return uiPlugin.getPreferenceStore().getBoolean("indentClauseContent");
        }
        return true;
    }

    public static List getIndentNodes(DisplayNode dnNode, int iIndentLevel) {
        ArrayList<DisplayNode> arylIndentNodes = new ArrayList<DisplayNode>(iIndentLevel);
        int i = 0;
        while (i < iIndentLevel) {
            arylIndentNodes.add(DisplayNodeFactory.createDisplayNode(dnNode, "\t"));
            ++i;
        }
        return arylIndentNodes;
    }
}

