/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.viewers.TreeViewer;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IQueryCommand;
import org.teiid.designer.query.sql.lang.ISetCriteria;
import org.teiid.designer.query.sql.lang.ISubquerySetCriteria;
import org.teiid.query.ui.builder.model.AbstractPredicateCriteriaTypeEditorModel;
import org.teiid.query.ui.builder.model.CriteriaExpressionEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;
import org.teiid.query.ui.builder.util.ElementViewerFactory;
import org.teiid.query.ui.builder.util.ICriteriaStrategy;

public class SetCriteriaEditorModel
extends AbstractPredicateCriteriaTypeEditorModel
implements ILanguageObjectEditorModelListener {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(SetCriteriaEditorModel.class);
    private static final String[] OPERATORS = new String[]{Util.getString(String.valueOf(PREFIX) + "in", new Object[0])};
    public static final String EXPRESSION = "SET CRITERIA EXPRESSION";
    public static final String SUBTYPE_CHANGED = "SET CRITERIA SUBTYPE CHANGED";
    public static final String VALUES = "SET CRITERIA VALUES";
    public static final String COMMAND = "SET CRITERIA SUBQUERY COMMAND";
    public static final int LIST = 1;
    public static final int SUBQUERY = 2;
    private static final int INITIAL_TYPE = 1;
    private final ISetCriteria emptySetCriteria;
    private final ISubquerySetCriteria emptySubquerySetCriteria;
    private CriteriaExpressionEditorModel expModel;
    private Collection values = new ArrayList();
    private int curType = 1;
    private ICriteriaStrategy criteriaStrategy = null;
    private ICommand subqueryCommand;
    private Object curSubquerySelection = null;

    public SetCriteriaEditorModel(CriteriaExpressionEditorModel model) {
        super(ISetCriteria.class);
        this.expModel = model;
        this.expModel.addModelListener(this);
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        this.emptySetCriteria = factory.createSetCriteria();
        this.emptySubquerySetCriteria = factory.createSubquerySetCriteria();
        this.subqueryCommand = this.emptySubquerySetCriteria.getCommand();
    }

    public SetCriteriaEditorModel() {
        this(new CriteriaExpressionEditorModel());
    }

    public void setViewer(TreeViewer viewer) {
        this.criteriaStrategy = ElementViewerFactory.getCriteriaStrategy(viewer);
    }

    public String getInvalidSelectionMessage() {
        String msg = this.criteriaStrategy.getInvalidMessage(this.curSubquerySelection);
        return msg;
    }

    public void setCurType(int type) {
        if (this.curType != type) {
            this.curType = type;
            this.fireModelChanged(SUBTYPE_CHANGED);
        }
    }

    public int getCurType() {
        return this.curType;
    }

    @Override
    public ILanguageObject getLanguageObject() {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        if (this.curType == 1) {
            ISetCriteria setCriteria = factory.createSetCriteria();
            setCriteria.setExpression(this.expModel.getExpression());
            setCriteria.setValues(this.values);
            return setCriteria;
        }
        ISubquerySetCriteria subquerySetCriteria = factory.createSubquerySetCriteria();
        subquerySetCriteria.setExpression(this.expModel.getExpression());
        subquerySetCriteria.setCommand((ICommand)((IQueryCommand)this.subqueryCommand));
        return subquerySetCriteria;
    }

    @Override
    public void setLanguageObject(ILanguageObject obj) {
        super.setLanguageObject(obj);
        if (obj == null) {
            this.clear();
        } else if (obj instanceof ISetCriteria) {
            this.setCurType(1);
            ISetCriteria curSetCriteria = (ISetCriteria)obj;
            this.setExpression(curSetCriteria.getExpression());
            this.setValues(curSetCriteria.getValues());
        } else {
            this.setCurType(2);
            ISubquerySetCriteria curSubquerySetCriteria = (ISubquerySetCriteria)obj;
            this.setExpression(curSubquerySetCriteria.getExpression());
            this.setCommand(curSubquerySetCriteria.getCommand());
        }
    }

    @Override
    public void clear() {
        this.notifyListeners = false;
        this.setCurType(1);
        if (this.curType == 1) {
            this.setExpression(this.emptySetCriteria.getExpression());
            this.setValues(this.emptySetCriteria.getValues());
        } else {
            this.setCommand(this.emptySubquerySetCriteria.getCommand());
        }
        this.notifyListeners = true;
        super.clear();
    }

    @Override
    public void save() {
        super.save();
        this.expModel.save();
    }

    public void setExpression(IExpression exp) {
        IExpression oldExp = this.expModel.getExpression();
        boolean same = exp == null ? oldExp == null : exp.equals(oldExp);
        if (!same) {
            this.expModel.setLanguageObject((ILanguageObject)exp);
        }
    }

    public IExpression getExpression() {
        return this.expModel.getExpression();
    }

    @Override
    public void setLeftExpression(IExpression exp) {
        this.setExpression(exp);
    }

    @Override
    public IExpression getLeftExpression() {
        return this.getExpression();
    }

    @Override
    public void setRightExpression(IExpression exp) {
    }

    @Override
    public IExpression getRightExpression() {
        return null;
    }

    public void setValues(Collection vals) {
        ArrayList ourValues = vals;
        if (ourValues == null) {
            ourValues = new ArrayList();
        }
        boolean same = this.sameValues(ourValues);
        Iterator it = ourValues.iterator();
        this.values = new ArrayList();
        while (it.hasNext()) {
            this.values.add(it.next());
        }
        if (!same) {
            this.fireModelChanged(VALUES);
        }
    }

    public void addValue(ILanguageObject newValue) {
        if (!this.values.contains(newValue)) {
            this.values.add(newValue);
            this.fireModelChanged(VALUES);
        }
    }

    public void replaceValue(ILanguageObject oldValue, ILanguageObject newValue) {
        this.values.remove(oldValue);
        this.values.add(newValue);
        this.fireModelChanged(VALUES);
    }

    public void setCommand(ICommand cmd) {
        boolean same = this.subqueryCommand == null ? false : this.subqueryCommand.equals(cmd);
        this.subqueryCommand = cmd;
        if (!same) {
            this.fireModelChanged(COMMAND);
        }
    }

    public ICommand getCommand() {
        return this.subqueryCommand;
    }

    @Override
    public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
        String type = theEvent.getType();
        String eventType = type.equals("MODEL_CHANGE") ? type : EXPRESSION;
        this.fireModelChanged(eventType);
    }

    private boolean sameValues(Collection newValues) {
        boolean same = false;
        if (this.values.size() == newValues.size()) {
            HashMap foundMap = new HashMap();
            Iterator it = this.values.iterator();
            boolean continuing = true;
            while (it.hasNext() && continuing) {
                Object value = it.next();
                if (foundMap.get(value) != null) {
                    continuing = false;
                    continue;
                }
                if (newValues.contains(value)) {
                    foundMap.put(value, new Boolean(true));
                    continue;
                }
                continuing = false;
            }
            same = continuing;
        }
        return same;
    }

    @Override
    public boolean isComplete() {
        boolean complete = this.curType == 1 ? this.expModel.isComplete() && this.values.size() > 0 : this.expModel.isComplete() && this.subqueryIsComplete();
        return complete;
    }

    public void setSubquerySelection(Object selection) {
        this.curSubquerySelection = selection;
        if (this.curSubquerySelection != null) {
            ICommand cmd = this.criteriaStrategy.getCommand(selection);
            this.setCommand(cmd);
        } else {
            this.setCommand(this.emptySubquerySetCriteria.getCommand());
        }
    }

    public Object getSubquerySelection() {
        return this.curSubquerySelection;
    }

    private boolean subqueryIsComplete() {
        boolean complete = false;
        if (this.subqueryCommand != null) {
            complete = !this.subqueryCommand.equals(this.emptySubquerySetCriteria.getCommand());
        }
        return complete;
    }

    public CriteriaExpressionEditorModel getExpressionModel() {
        return this.expModel;
    }

    @Override
    public String[] getOperators() {
        return OPERATORS;
    }

    @Override
    public String getCurrentOperator() {
        return OPERATORS[0];
    }

    @Override
    public void setCurrentOperator(String op) {
    }
}

