/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.model;

import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.IIsNullCriteria;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.query.ui.builder.model.AbstractPredicateCriteriaTypeEditorModel;
import org.teiid.query.ui.builder.model.CriteriaExpressionEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;

public class IsNullCriteriaEditorModel
extends AbstractPredicateCriteriaTypeEditorModel
implements ILanguageObjectEditorModelListener {
    public static final String EXPRESSION = "EXPRESSION";
    private static final String PREFIX = I18nUtil.getPropertyPrefix(IsNullCriteriaEditorModel.class);
    private static final String[] OPERATORS = new String[]{Util.getString(String.valueOf(PREFIX) + "isNull", new Object[0])};
    private final IIsNullCriteria emptyIsNullCriteria;
    private CriteriaExpressionEditorModel expEditorModel;

    public IsNullCriteriaEditorModel(CriteriaExpressionEditorModel eem) {
        super(IIsNullCriteria.class);
        this.expEditorModel = eem;
        this.expEditorModel.addModelListener(this);
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        this.emptyIsNullCriteria = factory.createIsNullCriteria();
    }

    public IsNullCriteriaEditorModel() {
        this(new CriteriaExpressionEditorModel());
    }

    @Override
    public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
        String type = theEvent.getType();
        String eventType = type.equals("MODEL_CHANGE") ? type : EXPRESSION;
        this.fireModelChanged(eventType);
    }

    @Override
    public void setLanguageObject(ILanguageObject obj) {
        super.setLanguageObject(obj);
        if (obj == null) {
            this.clear();
        } else {
            IIsNullCriteria curIsNullCriteria = (IIsNullCriteria)obj;
            this.expEditorModel.setLanguageObject((ILanguageObject)curIsNullCriteria.getExpression());
        }
    }

    @Override
    public void clear() {
        this.notifyListeners = false;
        this.expEditorModel.setLanguageObject((ILanguageObject)this.emptyIsNullCriteria.getExpression());
        this.notifyListeners = true;
        super.clear();
    }

    @Override
    public void save() {
        super.save();
        this.expEditorModel.save();
    }

    @Override
    public ILanguageObject getLanguageObject() {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        IIsNullCriteria isNullCriteria = factory.createIsNullCriteria();
        isNullCriteria.setExpression(this.expEditorModel.getExpression());
        return isNullCriteria;
    }

    @Override
    public boolean isComplete() {
        boolean complete = this.expEditorModel.isComplete();
        return complete;
    }

    public CriteriaExpressionEditorModel getExpressionModel() {
        return this.expEditorModel;
    }

    @Override
    public String[] getOperators() {
        return OPERATORS;
    }

    @Override
    public String getCurrentOperator() {
        return OPERATORS[0];
    }

    @Override
    public void setCurrentOperator(String op) {
    }

    public IExpression getExpression() {
        IExpression exp = this.expEditorModel.getExpression();
        return exp;
    }

    public void setExpression(IExpression exp) {
        IExpression oldExp = this.expEditorModel.getExpression();
        boolean same = exp == null ? oldExp == null : exp.equals(oldExp);
        if (!same) {
            this.expEditorModel.setLanguageObject((ILanguageObject)exp);
        }
    }

    @Override
    public IExpression getLeftExpression() {
        return this.getExpression();
    }

    @Override
    public void setLeftExpression(IExpression exp) {
        this.setExpression(exp);
    }

    @Override
    public IExpression getRightExpression() {
        return null;
    }

    @Override
    public void setRightExpression(IExpression exp) {
    }
}

