/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.model;

import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.ICompareCriteria;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.query.ui.builder.model.AbstractPredicateCriteriaTypeEditorModel;
import org.teiid.query.ui.builder.model.CriteriaExpressionEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;

public class CompareCriteriaEditorModel
extends AbstractPredicateCriteriaTypeEditorModel
implements ILanguageObjectEditorModelListener {
    public static final String LEFT_EXPRESSION = "COMPARE CRITERIA LEFT EXPRESSION";
    public static final String RIGHT_EXPRESSION = "COMPARE CRITERIA RIGHT EXPRESSION";
    public static final String OPERATOR = "OPERATOR";
    public static final String EQ = "=";
    public static final String NE = "<>";
    public static final String LT = "<";
    public static final String GT = ">";
    public static final String LE = "<=";
    public static final String GE = ">=";
    private static final String[] OPERATORS = new String[]{"=", "<>", "<", ">", "<=", ">="};
    private final ICompareCriteria emptyCompareCriteria;
    private CriteriaExpressionEditorModel leftExpModel;
    private CriteriaExpressionEditorModel rightExpModel;
    private int curOperatorInt;
    private String curOperatorStr;

    public CompareCriteriaEditorModel(CriteriaExpressionEditorModel left, CriteriaExpressionEditorModel right) {
        super(ICompareCriteria.class);
        this.leftExpModel = left;
        this.rightExpModel = right;
        this.leftExpModel.addModelListener(this);
        this.rightExpModel.addModelListener(this);
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        this.emptyCompareCriteria = factory.createCompareCriteria();
        this.curOperatorInt = this.emptyCompareCriteria.getOperator();
        this.curOperatorStr = this.operatorAsString(this.curOperatorInt);
        this.setLeftExpression(this.leftExpModel.getExpression());
        this.setRightExpression(this.rightExpModel.getExpression());
    }

    public CompareCriteriaEditorModel() {
        this(new CriteriaExpressionEditorModel(), new CriteriaExpressionEditorModel());
    }

    @Override
    public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
        String type = theEvent.getType();
        if (type.equals("MODEL_CHANGE")) {
            this.fireModelChanged(type);
        } else {
            this.fireModelChanged("STATE_CHANGE");
        }
    }

    @Override
    public ILanguageObject getLanguageObject() {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        ICompareCriteria compareCriteria = factory.createCompareCriteria();
        compareCriteria.setLeftExpression(this.leftExpModel.getExpression());
        compareCriteria.setRightExpression(this.rightExpModel.getExpression());
        compareCriteria.setOperator(this.curOperatorInt);
        return compareCriteria;
    }

    @Override
    public void setLanguageObject(ILanguageObject obj) {
        super.setLanguageObject(obj);
        if (obj == null) {
            this.clear();
        } else {
            ICompareCriteria curCompareCriteria = (ICompareCriteria)obj;
            this.setLeftExpression(curCompareCriteria.getLeftExpression());
            this.setRightExpression(curCompareCriteria.getRightExpression());
            this.setOperator(curCompareCriteria.getOperator());
        }
    }

    @Override
    public void clear() {
        this.notifyListeners = false;
        this.setLeftExpression(this.emptyCompareCriteria.getLeftExpression());
        this.setRightExpression(this.emptyCompareCriteria.getRightExpression());
        this.setOperator(this.emptyCompareCriteria.getOperator());
        this.notifyListeners = true;
        super.clear();
    }

    @Override
    public void setLeftExpression(IExpression exp) {
        this.leftExpModel.setLanguageObject((ILanguageObject)exp);
        this.fireModelChanged(LEFT_EXPRESSION);
    }

    @Override
    public void setRightExpression(IExpression exp) {
        this.rightExpModel.setLanguageObject((ILanguageObject)exp);
        this.fireModelChanged(RIGHT_EXPRESSION);
    }

    public void setOperator(int op) {
        if (op != this.curOperatorInt) {
            this.curOperatorInt = op;
            this.curOperatorStr = this.operatorAsString(this.curOperatorInt);
            this.fireModelChanged(OPERATOR);
        }
    }

    @Override
    public void setCurrentOperator(String opStr) {
        int opInt = this.operatorAsInt(opStr);
        this.setOperator(opInt);
    }

    private int operatorAsInt(String op) {
        int opInt = -1;
        if (op != null) {
            if (op.equals(EQ)) {
                opInt = 1;
            } else if (op.equals(NE)) {
                opInt = 2;
            } else if (op.equals(LT)) {
                opInt = 3;
            } else if (op.equals(GT)) {
                opInt = 4;
            } else if (op.equals(LE)) {
                opInt = 5;
            } else if (op.equals(GE)) {
                opInt = 6;
            }
        }
        return opInt;
    }

    private String operatorAsString(int op) {
        String str = "";
        switch (op) {
            case 1: {
                str = EQ;
                break;
            }
            case 2: {
                str = NE;
                break;
            }
            case 3: {
                str = LT;
                break;
            }
            case 4: {
                str = GT;
                break;
            }
            case 5: {
                str = LE;
                break;
            }
            case 6: {
                str = GE;
            }
        }
        return str;
    }

    @Override
    public void save() {
        super.save();
        this.leftExpModel.save();
        this.rightExpModel.save();
    }

    @Override
    public boolean isComplete() {
        boolean leftModelComplete = this.leftExpModel.isComplete();
        boolean curOperatorOK = this.curOperatorInt != -1;
        boolean rightModelComplete = this.rightExpModel.isComplete();
        boolean complete = leftModelComplete && curOperatorOK && rightModelComplete;
        return complete;
    }

    @Override
    public IExpression getLeftExpression() {
        return this.leftExpModel.getExpression();
    }

    public CriteriaExpressionEditorModel getLeftExpressionModel() {
        return this.leftExpModel;
    }

    @Override
    public IExpression getRightExpression() {
        return this.rightExpModel.getExpression();
    }

    public CriteriaExpressionEditorModel getRightExpressionModel() {
        return this.rightExpModel;
    }

    @Override
    public String[] getOperators() {
        return OPERATORS;
    }

    @Override
    public String getCurrentOperator() {
        return this.curOperatorStr;
    }
}

