/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.ui.debug.editors;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class BooleanVariableEditor
extends TrayDialog {
    private String title;
    private String message;
    private boolean value = false;
    private Button okButton;
    private Combo combo;

    public BooleanVariableEditor(Shell parentShell, String dialogTitle, String dialogMessage, boolean initialValue) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.value = initialValue;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.value = Boolean.parseBoolean(this.combo.getText());
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.combo.setFocus();
        this.combo.select(this.combo.indexOf(Boolean.toString(this.value)));
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(772);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(font);
        }
        this.combo = new Combo(composite, 2056);
        this.combo.add(Boolean.TRUE.toString());
        this.combo.add(Boolean.FALSE.toString());
        GridData gridData = new GridData(1808);
        gridData.heightHint = 12;
        gridData.widthHint = 30;
        this.combo.setLayoutData((Object)gridData);
        this.combo.setFont(font);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BooleanVariableEditor.this.okButton.isEnabled()) {
                    return;
                }
                BooleanVariableEditor.this.okButton.setEnabled(true);
            }
        });
        return composite;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Combo getCombo() {
        return this.combo;
    }

    public boolean getValue() {
        return this.value;
    }

    protected void okPressed() {
        if (this.okButton.isEnabled()) {
            super.okPressed();
        }
    }
}

