/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.preview.jobs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.runtime.preview.Messages;
import org.teiid.designer.runtime.preview.PreviewContext;
import org.teiid.designer.runtime.preview.PreviewManager;
import org.teiid.designer.runtime.preview.jobs.WorkspacePreviewVdbJob;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbModelEntry;
import org.teiid.designer.vdb.XmiVdb;

public final class CreatePreviewVdbJob
extends WorkspacePreviewVdbJob {
    private final IFile model;
    private final IProject project;
    private IFile pvdbFile;
    private boolean ignorableJob = false;

    public CreatePreviewVdbJob(IFile model, PreviewContext context) throws Exception {
        super(NLS.bind((String)Messages.CreatePreviewVdbJob, (Object)model.getFullPath()), context);
        assert (PreviewManager.isPreviewableResource(model)) : "model is not previewable" + model.getFullPath();
        this.model = model;
        this.project = null;
        this.initialize();
    }

    public CreatePreviewVdbJob(IProject project, PreviewContext context) throws Exception {
        super(NLS.bind((String)Messages.CreatePreviewVdbJob, (Object)project.getFullPath()), context);
        this.project = project;
        this.model = null;
        this.initialize();
    }

    @Override
    public IFile getPreviewVdb() {
        return this.pvdbFile;
    }

    private void initialize() {
        int size;
        IFile resource = this.project == null ? this.model : this.project;
        int n = size = this.project == null ? 4 : 3;
        if (!resource.exists() || ModelUtil.isVdbSourceObject((Object)this.model)) {
            this.cancel();
            this.ignorableJob = true;
            return;
        }
        this.pvdbFile = this.getContext().getPreviewVdb((IResource)resource);
        ISchedulingRule[] rules = new ISchedulingRule[size];
        rules[0] = this.getSchedulingRuleFactory().createRule((IResource)this.pvdbFile);
        rules[1] = this.getSchedulingRuleFactory().modifyRule((IResource)this.pvdbFile);
        rules[2] = this.getSchedulingRuleFactory().buildRule();
        if (size == 4) {
            rules[3] = this.getSchedulingRuleFactory().modifyRule((IResource)this.model);
        }
        this.setRule(MultiRule.combine((ISchedulingRule[])rules));
    }

    @Override
    protected IStatus runImpl(IProgressMonitor monitor) throws Exception {
        block10: {
            if (this.ignorableJob) {
                this.cancel();
                return new Status(0, "org.teiid.designer.dqp", NLS.bind((String)Messages.CreatePreviewVdbJobSuccessfullyCompleted, (Object)this.model.getFullPath()));
            }
            try {
                IFile resource;
                Object object = resource = this.project == null ? this.model : this.project;
                if (resource instanceof IFile && !this.model.isSynchronized(2)) {
                    this.model.refreshLocal(2, null);
                }
                if (this.pvdbFile.exists() && !this.pvdbFile.getLocation().toFile().exists()) {
                    this.pvdbFile.delete(true, monitor);
                }
                boolean isNew = false;
                if (!this.pvdbFile.exists()) {
                    isNew = true;
                    this.pvdbFile.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
                }
                this.pvdbFile.setHidden(true);
                XmiVdb pvdb = new XmiVdb(this.pvdbFile, true);
                boolean resourceContainsUdf = false;
                if (resource instanceof IFile) {
                    if (pvdb.getModelEntries().isEmpty()) {
                        pvdb.addEntry(this.model.getFullPath());
                    }
                    Set entries = pvdb.getModelEntries();
                    for (VdbEntry modelEntry : entries) {
                        resourceContainsUdf = ((VdbModelEntry)modelEntry).containsUdf();
                        if (resourceContainsUdf) break;
                    }
                    pvdb.synchronizeUdfJars(new HashSet());
                }
                if (isNew || pvdb.isModified() || resourceContainsUdf) {
                    pvdb.save();
                }
            }
            catch (Exception e) {
                IProject proj;
                IProject iProject = proj = this.project == null ? this.model.getProject() : this.project;
                if (!proj.isOpen()) break block10;
                IPath path = this.project == null ? this.model.getFullPath() : this.project.getFullPath();
                throw new CoreException((IStatus)new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.CreatePreviewVdbJobError, (Object)path), (Throwable)e));
            }
        }
        return new Status(0, "org.teiid.designer.dqp", NLS.bind((String)Messages.CreatePreviewVdbJobSuccessfullyCompleted, (Object)this.pvdbFile.getFullPath()));
    }
}

