/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.preview.jobs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.preview.Messages;
import org.teiid.designer.runtime.preview.PreviewContext;
import org.teiid.designer.runtime.preview.jobs.PreviewVdbJob;
import org.teiid.designer.runtime.spi.ITeiidServer;

public class CompositePreviewJob
extends Job
implements PreviewVdbJob {
    private final PreviewContext context;
    private final List<PreviewVdbJob> jobs;
    private IJobChangeListener listener;
    private final ITeiidServer previewServer;
    private final boolean runInSequence;

    public CompositePreviewJob(String jobName, PreviewContext context, ITeiidServer previewServer) {
        this(jobName, context, previewServer, false);
    }

    public CompositePreviewJob(String jobName, PreviewContext context, ITeiidServer previewServer, boolean runInSequence) {
        super(jobName);
        assert (context != null);
        this.context = context;
        this.jobs = new ArrayList<PreviewVdbJob>();
        this.runInSequence = runInSequence;
        this.previewServer = previewServer;
    }

    public void add(PreviewVdbJob job) {
        assert (job != null);
        this.jobs.add(job);
    }

    public void addChildJobChangeListener(IJobChangeListener listener) {
        this.listener = listener;
    }

    protected void canceling() {
        for (PreviewVdbJob previewJob : this.jobs) {
            assert (previewJob instanceof Job);
            Job job = (Job)previewJob;
            job.cancel();
        }
    }

    @Override
    public boolean completedSuccessfully() {
        for (PreviewVdbJob job : this.jobs) {
            if (job.completedSuccessfully()) continue;
            return false;
        }
        return true;
    }

    protected IJobChangeListener getChildJobChangeListener() {
        return this.listener;
    }

    @Override
    public PreviewContext getContext() {
        return this.context;
    }

    public List<PreviewVdbJob> getJobs() {
        return this.jobs;
    }

    public ITeiidServer getPreviewServer() {
        return this.previewServer;
    }

    protected IStatus run(IProgressMonitor monitor) {
        assert (!this.jobs.isEmpty());
        monitor.beginTask(this.getName(), this.getJobs().size());
        try {
            try {
                CompositePreviewJob.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                for (PreviewVdbJob previewJob : this.jobs) {
                    assert (previewJob instanceof Job);
                    Job job = (Job)previewJob;
                    job.setProgressGroup(monitor, 1);
                    if (this.listener != null) {
                        job.addJobChangeListener(this.listener);
                    }
                    job.schedule();
                    if (this.runInSequence) {
                        job.join();
                    }
                    if (!monitor.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                DqpPlugin.Util.log((IStatus)new Status(8, "org.teiid.designer.dqp", NLS.bind((String)Messages.JobCanceled, (Object)this.getName())));
                monitor.done();
            }
            catch (InterruptedException e) {
                DqpPlugin.Util.log((Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

