/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.net.MalformedURLException;
import org.teiid.core.designer.PluginUtil;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidURL;

public class TeiidServerUtils {
    private static PluginUtil UTIL = DqpPlugin.Util;
    public static final String FORMAT_SERVER = "mm[s]://<hostname>:<port>";
    public static final String DEFAULT_SERVER = "mm://localhost:31443";
    public static final String DEFAULT_SECURE_SERVER = "mms://localhost:31443";
    public static final String MM_PREFIX = "mm://";
    public static final String MMS_PREFIX = "mms://";
    public static final String COLON = ":";
    public static final String COMMA = ",";

    public TeiidServerUtils getInstance() {
        return this;
    }

    public static void validateServerUrl(String url) throws MalformedURLException {
        new TeiidURL(url);
    }

    public static void validPortNumber(String port) {
        int portNumber;
        try {
            portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(UTIL.getString("serverUtilsPortMustBeNumeric", (Object)port));
        }
        if (portNumber < 0 || portNumber > 65535) {
            throw new IllegalArgumentException(UTIL.getString("serverUtilsPortOutOfRange", (Object)Integer.toString(portNumber)));
        }
    }
}

