/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.io.File;
import java.io.InputStream;
import java.sql.Driver;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.adapter.TeiidServerAdapterFactory;
import org.teiid.designer.runtime.registry.TeiidRuntimeRegistry;
import org.teiid.designer.runtime.spi.EventManager;
import org.teiid.designer.runtime.spi.ExecutionConfigurationEvent;
import org.teiid.designer.runtime.spi.HostProvider;
import org.teiid.designer.runtime.spi.IExecutionAdmin;
import org.teiid.designer.runtime.spi.ITeiidAdminInfo;
import org.teiid.designer.runtime.spi.ITeiidConnectionInfo;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidJdbcInfo;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.spi.ITeiidVdb;
import org.teiid.designer.runtime.spi.TeiidPropertyDefinition;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public class TeiidServer
implements ITeiidServer {
    private ITeiidServerVersion serverVersion;
    protected IExecutionAdmin admin;
    protected final EventManager eventManager;
    private ITeiidJdbcInfo teiidJdbcInfo;
    private ITeiidAdminInfo teiidAdminInfo;
    private String connectionError;
    private String customLabel;
    private final String id;
    private final IServer parentServer;
    private TeiidServerAdapterFactory serverAdapterFactory;
    private boolean connecting = false;

    TeiidServer(ITeiidServerVersion serverVersion, ITeiidAdminInfo adminInfo, ITeiidJdbcInfo jdbcInfo, EventManager eventManager, IServer parentServer) {
        CoreArgCheck.isNotNull((Object)serverVersion, (String)"serverVersion");
        CoreArgCheck.isNotNull((Object)adminInfo, (String)"adminInfo");
        CoreArgCheck.isNotNull((Object)jdbcInfo, (String)"jdbcInfo");
        CoreArgCheck.isNotNull((Object)eventManager, (String)"eventManager");
        CoreArgCheck.isNotNull((Object)parentServer, (String)"parentServer");
        CoreArgCheck.isTrue((!parentServer.getClass().getSimpleName().equals("ServerWorkingCopy") ? 1 : 0) != 0, (String)"TeiidServer parent should not be a working copy");
        this.serverVersion = serverVersion;
        this.eventManager = eventManager;
        this.parentServer = parentServer;
        this.teiidAdminInfo = adminInfo;
        this.teiidAdminInfo.setHostProvider((HostProvider)this);
        this.teiidJdbcInfo = jdbcInfo;
        this.teiidJdbcInfo.setHostProvider((HostProvider)this);
        this.id = String.valueOf(this.getUrl()) + "-" + this.getServerVersion() + "-" + this.getParent().getId();
        if (parentServer.getServerState() != 2) {
            this.disconnect();
        }
    }

    protected void setServerVersion(ITeiidServerVersion teiidVersion) {
        if (teiidVersion == null) {
            return;
        }
        this.serverVersion = teiidVersion;
    }

    public ITeiidServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public void disconnect() {
        if (this.admin != null) {
            this.admin.disconnect();
            this.admin = null;
        }
        this.notifyRefresh();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TeiidServer other = (TeiidServer)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.parentServer == null ? other.parentServer != null : !this.parentServer.equals(other.parentServer)) {
            return false;
        }
        if (this.teiidAdminInfo == null ? other.teiidAdminInfo != null : !this.teiidAdminInfo.equals(other.teiidAdminInfo)) {
            return false;
        }
        return !(this.teiidJdbcInfo == null ? other.teiidJdbcInfo != null : !this.teiidJdbcInfo.equals(other.teiidJdbcInfo));
    }

    public void connect() throws Exception {
        if (!this.isParentConnected()) {
            throw new Exception(DqpPlugin.Util.getString("jbossServerNotStartedMessage", new Object[0]));
        }
        if (this.admin == null) {
            try {
                this.setServerVersion(this.getAdapterFactory().getTeiidRuntimeVersion(this.parentServer));
            }
            catch (Exception ex) {
                DqpPlugin.Util.log((Throwable)ex);
            }
            try {
                this.admin = TeiidRuntimeRegistry.getInstance().getExecutionAdmin((ITeiidServer)this);
                if (this.admin != null) {
                    this.getEventManager().permitListeners(false);
                    this.admin.connect();
                }
            }
            finally {
                this.getEventManager().permitListeners(true);
                this.connecting = false;
            }
            this.getEventManager().notifyListeners(ExecutionConfigurationEvent.createServerConnectedEvent((ITeiidServer)this));
            this.notifyRefresh();
        }
    }

    private TeiidServerAdapterFactory getAdapterFactory() {
        if (this.serverAdapterFactory == null) {
            this.serverAdapterFactory = new TeiidServerAdapterFactory();
        }
        return this.serverAdapterFactory;
    }

    public void reconnect() {
        try {
            this.getEventManager().permitListeners(false);
            try {
                this.disconnect();
            }
            finally {
                this.getEventManager().permitListeners(true);
            }
            if (!this.isParentConnected()) {
                throw new Exception(DqpPlugin.Util.getString("serverParentNotConnectedErrorMsg", new Object[0]));
            }
            this.connect();
            this.setConnectionError(null);
        }
        catch (IllegalArgumentException e) {
            DqpPlugin.Util.log((Throwable)e);
            String msg = String.valueOf(DqpPlugin.Util.getString("serverReconnectErrorMsg", (Object)this)) + "\n" + DqpPlugin.Util.getString("serverAdminInitError", new Object[0]);
            this.setConnectionError(msg);
        }
        catch (Exception e) {
            DqpPlugin.Util.log((Throwable)e);
            String msg = String.valueOf(DqpPlugin.Util.getString("serverReconnectErrorMsg", (Object)this)) + "\n" + e.getLocalizedMessage();
            this.setConnectionError(msg);
        }
    }

    public ITeiidAdminInfo getTeiidAdminInfo() {
        return this.teiidAdminInfo;
    }

    public ITeiidJdbcInfo getTeiidJdbcInfo() {
        return this.teiidJdbcInfo;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public String getDisplayName() {
        return this.getCustomLabel() != null ? this.getCustomLabel() : this.getUrl();
    }

    public String getUrl() {
        return this.getTeiidAdminInfo().getUrl();
    }

    public String getCustomLabel() {
        return this.customLabel;
    }

    public String getHost() {
        String host = this.parentServer.getHost();
        if (host == null) {
            host = "localhost";
        }
        return host;
    }

    public String getId() {
        return this.id;
    }

    public IServer getParent() {
        return this.parentServer;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.admin == null ? 0 : this.admin.hashCode());
        result = 31 * result + (this.eventManager == null ? 0 : this.eventManager.hashCode());
        result = 31 * result + (this.parentServer == null ? 0 : this.parentServer.hashCode());
        result = 31 * result + (this.teiidAdminInfo == null ? 0 : this.teiidAdminInfo.hashCode());
        result = 31 * result + (this.teiidJdbcInfo == null ? 0 : this.teiidJdbcInfo.hashCode());
        return result;
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public void startConnecting() {
        this.connecting = true;
        this.getEventManager().notifyListeners(ExecutionConfigurationEvent.createServerConnectingEvent((ITeiidServer)this));
    }

    public boolean isConnected() {
        if (!this.isParentConnected() || this.admin == null) {
            return false;
        }
        return this.ping().isOK();
    }

    public boolean isParentConnected() {
        if (this.parentServer == null || this.parentServer.getServerState() != 2) {
            return false;
        }
        try {
            return this.getAdapterFactory().isParentServerConnected(this.parentServer);
        }
        catch (Exception ex) {
            DqpPlugin.Util.log((Throwable)ex);
            return false;
        }
    }

    public boolean isRefreshing() {
        if (this.isConnected()) {
            try {
                return this.admin.isRefreshing();
            }
            catch (Exception ex) {
                DqpPlugin.Util.log((Throwable)ex);
                return false;
            }
        }
        return false;
    }

    public IStatus ping() {
        String msg = DqpPlugin.Util.getString("cannotConnectToServer", (Object)this.getTeiidAdminInfo().getUsername());
        try {
            if (!this.isParentConnected() || this.admin == null) {
                throw new Exception(msg);
            }
            this.admin.ping(IExecutionAdmin.PingType.ADMIN);
        }
        catch (Exception e) {
            return new Status(4, "org.teiid.designer.dqp", msg, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public void notifyRefresh() {
        if (this.admin != null) {
            this.getEventManager().notifyListeners(ExecutionConfigurationEvent.createServerRefreshEvent((ITeiidServer)this));
        } else {
            DqpPlugin.getInstance().getServerManager().notifyListeners(ExecutionConfigurationEvent.createServerRefreshEvent((ITeiidServer)this));
        }
    }

    public String getConnectionError() {
        return this.connectionError;
    }

    private void setConnectionError(String connectionError) {
        this.connectionError = connectionError;
    }

    public void setCustomLabel(String customLabel) {
        this.customLabel = StringUtilities.isEmpty((String)customLabel) ? null : customLabel;
    }

    public IStatus testPing() {
        try {
            boolean testCausesConnect = false;
            if (this.admin == null) {
                this.connect();
                testCausesConnect = true;
            }
            IStatus status = this.ping();
            if (testCausesConnect) {
                this.disconnect();
            }
            return status;
        }
        catch (Exception e) {
            String msg = DqpPlugin.Util.getString("cannotConnectToServer", (Object)this);
            return new Status(4, "org.teiid.designer.dqp", msg, (Throwable)e);
        }
    }

    public IStatus testJDBCPing(String host, String port, String username, String password) {
        try {
            boolean testCausesConnect = false;
            if (this.admin == null) {
                this.connect();
                testCausesConnect = true;
            }
            IStatus status = this.admin.ping(IExecutionAdmin.PingType.JDBC);
            if (testCausesConnect) {
                this.disconnect();
            }
            return status;
        }
        catch (Exception e) {
            String msg = DqpPlugin.Util.getString("cannotConnectToServer", (Object)this);
            return new Status(4, "org.teiid.designer.dqp", msg, (Throwable)e);
        }
    }

    private String getVdbDataSourceConnectionUrl(String vdbName) {
        String host = this.teiidJdbcInfo.getHostProvider().getHost();
        String port = this.teiidJdbcInfo.getPort();
        String protocol = this.teiidJdbcInfo.isSecure() ? "@mms" : "@mm";
        return "jdbc:teiid:" + vdbName + protocol + "://" + host + ":" + port;
    }

    public IStatus createVdbDataSource(String vdbName, String displayName, String jndiName) {
        Properties props = new Properties();
        String username = this.teiidJdbcInfo.getUsername();
        String password = this.teiidJdbcInfo.getPassword();
        if (username != null) {
            props.put("user-name", username);
        }
        if (password != null) {
            props.put("password", password);
        }
        props.put("driver-class", "org.teiid.jdbc.TeiidDriver");
        props.put("connection-url", this.getVdbDataSourceConnectionUrl(vdbName));
        try {
            this.connect();
            this.admin.getOrCreateDataSource(displayName, jndiName, "connector-jdbc", props);
        }
        catch (Exception ex) {
            String msg = "Error creating data source for VDB " + vdbName;
            return new Status(4, "org.teiid.designer.dqp", msg, (Throwable)ex);
        }
        return Status.OK_STATUS;
    }

    public String getParentName() {
        return this.parentServer.getName();
    }

    public int getParentRequestTimeout() {
        return this.getAdapterFactory().getParentRequestExecutionTimeout(this.parentServer);
    }

    public String toString() {
        String txt = DqpPlugin.Util.getString("serverToStringWithNoCustomLabel", (Object)this.parentServer.getName());
        return txt;
    }

    public boolean dataSourceExists(String name) throws Exception {
        this.connect();
        return this.admin.dataSourceExists(name);
    }

    public void deleteDataSource(String jndiName) throws Exception {
        this.connect();
        this.admin.deleteDataSource(jndiName);
    }

    public void deployVdb(IFile vdbFile) throws Exception {
        this.connect();
        this.admin.deployVdb(vdbFile);
    }

    public void deployVdb(IFile vdbFile, int version) throws Exception {
        this.connect();
        this.admin.deployVdb(vdbFile, version);
    }

    public ITeiidDataSource getDataSource(String name) throws Exception {
        this.connect();
        return this.admin.getDataSource(name);
    }

    public Collection<ITeiidDataSource> getDataSources() throws Exception {
        this.connect();
        return this.admin.getDataSources();
    }

    public Set<String> getDataSourceTypeNames() throws Exception {
        this.connect();
        return this.admin.getDataSourceTypeNames();
    }

    public ITeiidDataSource getOrCreateDataSource(String displayName, String jndiName, String typeName, Properties properties) throws Exception {
        this.connect();
        CoreArgCheck.isNotNull((Object)displayName, (String)"displayName");
        CoreArgCheck.isNotNull((Object)jndiName, (String)"jndiName");
        CoreArgCheck.isNotNull((Object)typeName, (String)"typeName");
        CoreArgCheck.isNotNull((Object)properties, (String)"properties");
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object value = entry.getValue();
            String errorMsg = "No value for the connection property '" + entry.getKey() + "'";
            CoreArgCheck.isNotNull((Object)value, (String)errorMsg);
            CoreArgCheck.isNotEmpty((String)value.toString(), (String)errorMsg);
        }
        return this.admin.getOrCreateDataSource(displayName, jndiName, typeName, properties);
    }

    public ITeiidTranslator getTranslator(String name) throws Exception {
        this.connect();
        return this.admin.getTranslator(name);
    }

    public Collection<ITeiidTranslator> getTranslators() throws Exception {
        this.connect();
        return this.admin.getTranslators();
    }

    public Collection<ITeiidVdb> getVdbs() throws Exception {
        this.connect();
        return this.admin.getVdbs();
    }

    public ITeiidVdb getVdb(String name) throws Exception {
        this.connect();
        return this.admin.getVdb(name);
    }

    public boolean hasVdb(String name) throws Exception {
        this.connect();
        return this.admin.hasVdb(name);
    }

    public boolean isVdbActive(String vdbName) throws Exception {
        this.connect();
        return this.admin.isVdbActive(vdbName);
    }

    public boolean isVdbLoading(String vdbName) throws Exception {
        this.connect();
        return this.admin.isVdbLoading(vdbName);
    }

    public boolean hasVdbFailed(String vdbName) throws Exception {
        this.connect();
        return this.admin.hasVdbFailed(vdbName);
    }

    public boolean wasVdbRemoved(String vdbName) throws Exception {
        this.connect();
        return this.admin.wasVdbRemoved(vdbName);
    }

    public List<String> retrieveVdbValidityErrors(String vdbName) throws Exception {
        this.connect();
        return this.admin.retrieveVdbValidityErrors(vdbName);
    }

    public void undeployVdb(String vdbName) throws Exception {
        this.connect();
        this.admin.undeployVdb(vdbName);
    }

    public IStatus ping(IExecutionAdmin.PingType pingType) throws Exception {
        this.connect();
        return this.admin.ping(pingType);
    }

    public String getAdminDriverPath() throws Exception {
        this.connect();
        return this.admin.getAdminDriverPath();
    }

    public Driver getTeiidDriver(String driverClass) throws Exception {
        this.connect();
        return this.admin.getTeiidDriver(driverClass);
    }

    public void update(ITeiidServer otherServer) {
        CoreArgCheck.isNotNull((Object)otherServer);
        this.serverVersion = new TeiidServerVersion(otherServer.getServerVersion().toString());
        this.getTeiidAdminInfo().setAll((ITeiidConnectionInfo)otherServer.getTeiidAdminInfo());
        this.getTeiidJdbcInfo().setAll((ITeiidConnectionInfo)otherServer.getTeiidJdbcInfo());
    }

    public void deployDynamicVdb(String vdbDeploymentName, InputStream inStream) throws Exception {
        this.connect();
        this.admin.deployDynamicVdb(vdbDeploymentName, inStream);
    }

    public void deployDriver(File file) throws Exception {
        this.connect();
        this.admin.deployDriver(file);
    }

    public void undeployDynamicVdb(String vdbName) throws Exception {
        this.connect();
        this.admin.undeployDynamicVdb(vdbName);
    }

    public Set<String> getDataSourceTemplateNames() throws Exception {
        this.connect();
        return this.admin.getDataSourceTemplateNames();
    }

    public Collection<TeiidPropertyDefinition> getTemplatePropertyDefns(String templateName) throws Exception {
        this.connect();
        return this.admin.getTemplatePropertyDefns(templateName);
    }

    public String getSchema(String vdbName, int vdbVersion, String modelName) throws Exception {
        this.connect();
        return this.admin.getSchema(vdbName, vdbVersion, modelName);
    }

    public Properties getDataSourceProperties(String name) throws Exception {
        this.connect();
        return this.admin.getDataSourceProperties(name);
    }

    @Deprecated
    public void mergeVdbs(String sourceVdbName, int sourceVdbVersion, String targetVdbName, int targetVdbVersion) throws Exception {
        this.connect();
        this.admin.mergeVdbs(sourceVdbName, sourceVdbVersion, targetVdbName, targetVdbVersion);
    }
}

