/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.ModelWorkspaceNotification;
import org.teiid.designer.core.workspace.ModelWorkspaceNotificationAdapter;
import org.teiid.designer.core.workspace.ModelWorkspaceNotificationListener;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionConstants;
import org.teiid.designer.runtime.DefaultServersProvider;
import org.teiid.designer.runtime.IServersProvider;
import org.teiid.designer.runtime.TeiidParentServerListener;
import org.teiid.designer.runtime.preview.PreviewManager;
import org.teiid.designer.runtime.spi.ITeiidServerManager;

public class DqpPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.teiid.designer.dqp";
    public static final String PACKAGE_ID = DqpPlugin.class.getPackage().getName();
    private static final String I18N_NAME = String.valueOf(PACKAGE_ID) + ".i18n";
    public static final String SOURCE_BINDINGS_FILE_NAME = "SourceBindings.xml";
    private static IPath runtimePath;
    public static PluginUtil Util;
    private ModelWorkspaceNotificationAdapter workspaceListener = null;
    private static DqpPlugin plugin;
    private IServersProvider serversProvider;

    static {
        Util = new PluginUtilImpl(PLUGIN_ID, I18N_NAME, ResourceBundle.getBundle(I18N_NAME));
    }

    public static DqpPlugin getInstance() {
        return plugin;
    }

    public IEclipsePreferences getPreferences() {
        return this.getPreferences(PLUGIN_ID);
    }

    public int getJbossRequestTimeout() {
        IEclipsePreferences preferences = DqpPlugin.getInstance().getPreferences();
        int timeout = preferences.getInt(".preferences.JbossRequestExecutionTimeout", 10);
        if (timeout < 100) {
            timeout *= 1000;
        }
        return timeout;
    }

    public IEclipsePreferences getPreferences(String pluginId) {
        return InstanceScope.INSTANCE.getNode(pluginId);
    }

    public IPath getRuntimePath() {
        if (runtimePath == null) {
            runtimePath = DqpPlugin.getInstance().getStateLocation();
        }
        return (IPath)runtimePath.clone();
    }

    public ITeiidServerManager getServerManager() {
        return ModelerCore.getTeiidServerManager();
    }

    public IServersProvider getServersProvider() {
        if (this.serversProvider == null) {
            this.serversProvider = new DefaultServersProvider();
        }
        return this.serversProvider;
    }

    void handleContextChanged(IChangeNotifier vdb) {
    }

    private void initializeDefaultPreferences() {
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode(DqpPlugin.getInstance().getBundle().getSymbolicName());
        prefs.putBoolean("org.teiid.designer.dqp.preferences.PreviewEnabled", true);
        prefs.putBoolean("org.teiid.designer.dqp.preferences.PreviewTeiidCleanupEnabled", true);
    }

    public boolean isDebugOptionEnabled(String option) {
        return this.isDebugging() && Boolean.toString(true).equals(Platform.getDebugOption((String)option));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
        this.initializeDefaultPreferences();
        this.workspaceListener = new ModelWorkspaceNotificationAdapter(){

            public void notifyReloaded(ModelWorkspaceNotification notification) {
                DqpPlugin.this.handleNewModelEvent(notification);
            }

            public void notifyAdd(ModelWorkspaceNotification notification) {
                DqpPlugin.this.handleNewModelEvent(notification);
            }
        };
        ModelWorkspaceManager.getModelWorkspaceManager().addNotificationListener((ModelWorkspaceNotificationListener)this.workspaceListener);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.getServersProvider().isInitialised()) {
            this.getServersProvider().removeServerStateListener(TeiidParentServerListener.getInstance());
            this.getServersProvider().removeServerLifecycleListener(TeiidParentServerListener.getInstance());
        }
        try {
            if (this.getServerManager() != null) {
                this.getServerManager().shutdown(null);
            }
            PreviewManager.getInstance().shutdown(null);
        }
        finally {
            super.stop(context);
        }
    }

    void handleNewModelEvent(ModelWorkspaceNotification notification) {
        IResource model;
        if (notification.isPostChange() && (model = (IResource)notification.getNotifier()) != null) {
            ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
            String prefix = RestModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix();
            RestModelExtensionAssistant assistant = (RestModelExtensionAssistant)registry.getModelExtensionAssistant(prefix);
            try {
                assistant.applyMedIfNecessary(model);
            }
            catch (Exception e) {
                Util.log((Throwable)e);
            }
        }
    }

    private static Display getDisplay() {
        return Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent();
    }

    private static void runInSwtThread(Runnable operation, boolean asynchronous) {
        Display display = DqpPlugin.getDisplay();
        if (Thread.currentThread() != display.getThread()) {
            if (asynchronous) {
                display.asyncExec(operation);
            } else {
                display.syncExec(operation);
            }
        } else {
            operation.run();
        }
    }

    public static void handleException(final Exception ex) {
        Util.log((Throwable)ex);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String reason = Util.getString("TeiidParentServerListener.initTeiidServerException.reason", new Object[0]);
                MultiStatus multiStatus = new MultiStatus(DqpPlugin.PLUGIN_ID, 0, reason, null);
                Throwable throwable = ex;
                do {
                    Status status = new Status(4, DqpPlugin.PLUGIN_ID, " * " + throwable.getLocalizedMessage());
                    multiStatus.add((IStatus)status);
                } while ((throwable = throwable.getCause()) != null);
                StatusManager.getManager().handle((IStatus)multiStatus, 2);
            }
        };
        DqpPlugin.runInSwtThread(runnable, true);
    }
}

