/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.commons.tree;

import java.io.File;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.fusesource.ide.commons.ui.Workbenches;
import org.fusesource.ide.commons.ui.drop.DropHandlerSupport;
import org.fusesource.ide.commons.ui.views.ColumnViewSupport;
import org.fusesource.ide.commons.util.IFiles;
import org.fusesource.ide.commons.util.IOUtils;
import org.fusesource.ide.jmx.commons.Activator;
import org.fusesource.ide.jmx.commons.messages.Exchanges;
import org.fusesource.ide.jmx.commons.messages.IMessage;
import org.fusesource.ide.jmx.commons.messages.Message;
import org.fusesource.ide.jmx.commons.messages.contenttype.MessagesNamespaceXmlContentDescriber;
import org.fusesource.ide.jmx.commons.tree.MessageDropTarget;
import org.fusesource.ide.jmx.commons.views.messages.MessagesView;

public class MessageDropHandler
extends DropHandlerSupport {
    private final MessageDropTarget target;

    public MessageDropHandler(MessageDropTarget target) {
        this.target = target;
    }

    public void dropIFile(IFile resource) {
        try {
            IMessage message = MessageDropHandler.fileToMessage(resource);
            if (message != null) {
                this.dropMessage(message);
            }
        }
        catch (Exception e) {
            Activator.showUserError("Failed to send message to " + this.target, "Failed to load resource " + resource + " as a Message. ", e);
        }
    }

    public static IMessage fileToMessage(IFile resource) throws CoreException, JAXBException {
        IMessage message;
        IContentDescription contentDescription = resource.getContentDescription();
        resource.getFileExtension();
        if (MessagesNamespaceXmlContentDescriber.isXmlFormat(resource)) {
            message = Exchanges.loadMessage(resource, resource.getContents());
        } else {
            File file = IFiles.toFile((IFile)resource);
            if (file != null) {
                IContentType contentType;
                Message m = new Message();
                message = m;
                MessageDropHandler.setMessageBody(m, file, !IFiles.isTextContentType((IFile)resource));
                if (contentDescription != null && (contentType = contentDescription.getContentType()) != null) {
                    m.setHeader("EclipseContentType", contentType.getId());
                }
            } else {
                message = null;
            }
        }
        return message;
    }

    public static void setMessageBody(Message m, File file, boolean binary) {
        Object body = null;
        if (binary) {
            body = IOUtils.loadBinaryFile((File)file);
        } else {
            String text = IOUtils.loadTextFile((File)file, (String)"UTF-8");
            body = text;
        }
        m.setBody(body);
    }

    public void dropFile(File file) {
        try {
            IMessage message = Exchanges.loadMessage(file);
            this.dropMessage(message);
        }
        catch (Exception e) {
            Activator.showUserError("Failed to send message to " + this.target, "Failed to load file " + file + " as a Message. ", e);
        }
    }

    public void dropMessage(IMessage message) {
        if (message != null) {
            IViewPart view;
            this.target.dropMessage(message);
            IWorkbenchPage activeWorkbenchPage = Workbenches.getActiveWorkbenchPage();
            if (activeWorkbenchPage != null && (view = activeWorkbenchPage.findView("org.fusesource.ide.fabric.views.MessagesView")) instanceof MessagesView) {
                ColumnViewSupport messageView = (ColumnViewSupport)view;
                messageView.refresh();
            }
        }
    }
}

