/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.webservice.aspects.sql;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.metamodels.webservice.Input;
import org.teiid.designer.metamodels.webservice.WebServiceMetamodelPlugin;
import org.teiid.designer.metamodels.webservice.aspects.sql.WebServiceComponentAspect;

public class InputAspect
extends WebServiceComponentAspect
implements SqlProcedureParameterAspect {
    private static final Object DEFAULT_VALUE = null;
    private static final int LENGTH = 0;
    private static final int SCALE = 0;
    private static final int NULL_TYPE = 1;
    private static final int PRECISION = 0;
    private static final int POSITION = 0;
    private static final int RADIX = 0;
    private static final String DATATYPE_NAME = "XMLLiteral";
    private static final String RUNTIME_TYPE = "xml";

    protected InputAspect(MetamodelEntity entity) {
        super(entity);
    }

    public EObject getDatatype(EObject eObject) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        try {
            DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true);
            return dtMgr.getBuiltInDatatype(DATATYPE_NAME);
        }
        catch (ModelerCoreException e) {
            WebServiceMetamodelPlugin.Util.log((Throwable)e);
            return null;
        }
    }

    public String getDatatypeName(EObject eObject) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        return DATATYPE_NAME;
    }

    public String getDatatypeObjectID(EObject eObject) {
        EObject datatype = this.getDatatype(eObject);
        if (datatype == null) {
            return null;
        }
        DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true);
        return dtMgr.getUuidString(datatype) == null ? "" : dtMgr.getUuidString(datatype);
    }

    public String getRuntimeType(EObject eObject) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        return RUNTIME_TYPE;
    }

    public Object getDefaultValue(EObject eObject) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        return DEFAULT_VALUE;
    }

    public int getNullType(EObject eObject) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        return 1;
    }

    public int getLength(EObject eObject) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        return 0;
    }

    public int getPosition(EObject eObject) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        return 0;
    }

    public int getRadix(EObject eObject) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        return 0;
    }

    public int getScale(EObject eObject) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        return 0;
    }

    public int getPrecision(EObject eObject) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        return 0;
    }

    public int getType(EObject eObject) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        return 0;
    }

    public boolean isOptional(EObject eObject) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        return false;
    }

    public boolean isDatatypeFeature(EObject eObject, EStructuralFeature eFeature) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        EObjectImpl eObjectImpl = super.getEObjectImpl(eObject);
        if (eObjectImpl != null) {
            switch (eObjectImpl.eDerivedStructuralFeatureID(eFeature)) {
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'F';
    }

    public boolean canSetDatatype() {
        return false;
    }

    public void setDatatype(EObject eObject, EObject datatype) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        String msg = WebServiceMetamodelPlugin.Util.getString("InputAspect.setDatatypeNotSupported", new Object[0]);
        throw new UnsupportedOperationException(msg);
    }

    public boolean canSetLength() {
        return false;
    }

    public void setLength(EObject eObject, int length) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        String msg = WebServiceMetamodelPlugin.Util.getString("InputAspect.setLengthNotSupported", new Object[0]);
        throw new UnsupportedOperationException(msg);
    }

    public boolean canSetNullType() {
        return false;
    }

    public void setNullType(EObject eObject, int nullType) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        String msg = WebServiceMetamodelPlugin.Util.getString("InputAspect.setNullTypeNotSupported", new Object[0]);
        throw new UnsupportedOperationException(msg);
    }

    public boolean isInputParam(EObject eObject) {
        return true;
    }

    public void setDirection(EObject eObject, int dir) {
        CoreArgCheck.isInstanceOf(Input.class, (Object)eObject);
        String msg = WebServiceMetamodelPlugin.Util.getString("InputAspect.setDirectionNotSupported", new Object[0]);
        throw new UnsupportedOperationException(msg);
    }
}

