/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.wizard;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.wizard.InterfaceDefinitionPage;
import org.teiid.designer.webservice.util.WebServiceBuildOptions;
import org.teiid.designer.webservice.util.WebServiceBuilderHelper;

public class GenerateWebServiceModelWizard
extends AbstractWizard
implements INewWizard,
IInternalUiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(GenerateWebServiceModelWizard.class);
    public static boolean HEADLESS = false;
    protected InterfaceDefinitionPage interfaceDefinitionPage;
    protected ISelection selection;
    private IWizardPage[] wizardPageArray;
    private IProgressMonitor monitor;
    private MultiStatus result;
    WebServiceBuilderHelper webServiceBuilderHelper = new WebServiceBuilderHelper();
    WebServiceBuildOptions webServiceBuildOptions;

    public GenerateWebServiceModelWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), GenerateWebServiceModelWizard.getString("title"), null);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.interfaceDefinitionPage = new InterfaceDefinitionPage(this.selection);
        this.addPage((IWizardPage)this.interfaceDefinitionPage);
    }

    public boolean finish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                GenerateWebServiceModelWizard.this.webServiceBuildOptions = GenerateWebServiceModelWizard.this.interfaceDefinitionPage.getWebServiceBuildOptions();
                GenerateWebServiceModelWizard.this.doFinish(monitor);
            }
        };
        String txnDescr = GenerateWebServiceModelWizard.getString("createWebService.txnDescr");
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)txnDescr, (Object)this);
        try {
            try {
                new ProgressMonitorDialog(this.getShell()).run(false, false, op);
            }
            catch (Throwable err) {
                UTIL.log(4, err, err.getMessage());
                if (startedTxn) {
                    ModelerCore.commitTxn();
                }
            }
        }
        finally {
            if (startedTxn) {
                ModelerCore.commitTxn();
            }
        }
        return true;
    }

    public void doFinish(IProgressMonitor monitor) {
        CoreArgCheck.isNotNull((Object)this.webServiceBuilderHelper);
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
        String msg = GenerateWebServiceModelWizard.getString("begin");
        this.monitor.beginTask(msg, 1);
        this.result = this.webServiceBuilderHelper.createWebService(this.webServiceBuildOptions, false, true, this.monitor);
        this.monitor.worked(1);
        if (!this.result.isOK()) {
            int i = 0;
            while (i < this.result.getChildren().length) {
                UTIL.log(this.result.getChildren()[i]);
                ++i;
            }
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GenerateWebServiceModelWizard.this.webServiceBuilderHelper.getWebServiceModel() != null) {
                    ModelEditorManager.openInEditMode((Object)GenerateWebServiceModelWizard.this.webServiceBuilderHelper.getWebServiceModel(), (boolean)true, (int)0);
                }
            }
        });
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.interfaceDefinitionPage) {
            return null;
        }
        int i = 0;
        while (i < this.wizardPageArray.length) {
            if (this.wizardPageArray[i] == page && i + 1 < this.wizardPageArray.length) {
                return this.wizardPageArray[i + 1];
            }
            ++i;
        }
        return null;
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.interfaceDefinitionPage) {
            result = currentPage.isPageComplete();
        } else {
            boolean lastPage = currentPage == this.wizardPageArray[this.wizardPageArray.length - 1];
            result = lastPage && currentPage.isPageComplete();
        }
        return result;
    }

    public int getPageCount() {
        if (this.wizardPageArray != null) {
            return this.wizardPageArray.length + 1;
        }
        return 1;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.wizardPageArray == null || page == this.interfaceDefinitionPage) {
            return null;
        }
        if (page == this.wizardPageArray[0]) {
            return this.interfaceDefinitionPage;
        }
        int i = 1;
        while (i < this.wizardPageArray.length) {
            if (page == this.wizardPageArray[i]) {
                return this.wizardPageArray[i - 1];
            }
            ++i;
        }
        return null;
    }

    public MultiStatus getResult() {
        if (this.result == null) {
            this.result = new MultiStatus("org.teiid.designer.webservice.ui", 0, UTIL.getString("GenerateWebServiceModelWizard.result", new Object[0]), null);
        }
        return this.result;
    }

    private static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }
}

