/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.metamodels.transformation.SqlTransformation;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.metamodels.webservice.Input;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.metamodels.webservice.Output;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorPanel;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.undo.ModelerUndoManager;
import org.teiid.designer.ui.util.ModelObjectNotificationHelper;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.editor.OperationObjectEditorPage;
import org.teiid.designer.webservice.ui.util.WebServiceUiUtil;

public class WebServiceNotificationListener
implements INotifyChangedListener,
IInternalUiConstants {
    private static final String I18N_PFX = I18nUtil.getPropertyPrefix(WebServiceNotificationListener.class);
    private static final String CONFIRM_SQLUPDATE_TITLE = UTIL.getString(String.valueOf(I18N_PFX) + "confirmSQLUpdateTitle", new Object[0]);
    private static final String CONFIRM_SQLUPDATE_MSG = UTIL.getString(String.valueOf(I18N_PFX) + "confirmSQLUpdateMsg", new Object[0]);
    boolean uiBooleanResult = false;

    private void handleNotifications(Collection notifications, Object transactionSource) {
        block5: for (Notification note : notifications) {
            Object src = note.getNotifier();
            Object newVal = note.getNewValue();
            Object oldVal = note.getOldValue();
            switch (note.getEventType()) {
                case 3: {
                    if (src instanceof Interface && newVal instanceof Operation) {
                        WebServiceUiUtil.initializeProcedure((Operation)newVal, transactionSource, false);
                        break;
                    }
                    this.processChangedXmlDocumentAsSource(src, newVal, true, transactionSource);
                    break;
                }
                case 4: {
                    this.processChangedXmlDocumentAsSource(src, oldVal, false, transactionSource);
                    break;
                }
                case 1: {
                    String sql;
                    SqlTransformationMappingRoot mappingRoot;
                    EObject target;
                    if (src instanceof Input && note.getFeatureID(Input.class) == 1) {
                        boolean shouldReplace = true;
                        if (!(transactionSource instanceof OperationObjectEditorPage.MySqlPanelDropTargetListener) && !(transactionSource instanceof SqlEditorPanel)) {
                            this.uiBooleanResult = false;
                            UiUtil.runInSwtThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    WebServiceNotificationListener.this.uiBooleanResult = WebServiceNotificationListener.this.confirmReplaceProcedure();
                                }
                            }, (boolean)true);
                            shouldReplace = this.uiBooleanResult;
                        }
                        if (transactionSource instanceof SqlEditorPanel) break;
                        WebServiceUiUtil.initializeProcedure(((Input)src).getOperation(), transactionSource, shouldReplace);
                        break;
                    }
                    if (src instanceof Output && note.getFeatureID(Output.class) == 6) {
                        boolean shouldReplace = true;
                        if (!(transactionSource instanceof OperationObjectEditorPage.MySqlPanelDropTargetListener) && !(transactionSource instanceof SqlEditorPanel)) {
                            this.uiBooleanResult = false;
                            UiUtil.runInSwtThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    WebServiceNotificationListener.this.uiBooleanResult = WebServiceNotificationListener.this.confirmReplaceProcedure();
                                }
                            }, (boolean)true);
                            shouldReplace = this.uiBooleanResult;
                        }
                        if (transactionSource instanceof SqlEditorPanel) break;
                        WebServiceUiUtil.initializeProcedure(((Output)src).getOperation(), transactionSource, shouldReplace);
                        break;
                    }
                    if (!(transactionSource instanceof SqlEditorPanel) || !(src instanceof SqlTransformation) || newVal != null || (target = (mappingRoot = (SqlTransformationMappingRoot)((EObject)src).eContainer()).getTarget()) == null || !TransformationHelper.isOperation((Object)target) || (sql = SqlMappingRootCache.getSelectSql((EObject)mappingRoot)) != null && sql.trim().length() != 0) continue block5;
                    WebServiceUiUtil.clearXmlDocumentAsSource(mappingRoot, true, transactionSource);
                }
            }
        }
    }

    boolean confirmReplaceProcedure() {
        boolean replaceProc = false;
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        boolean disableCallbacks = prefStore.getBoolean("transformation.ui.preference.disableCallbacks");
        if (!disableCallbacks) {
            replaceProc = MessageDialog.openQuestion(null, (String)CONFIRM_SQLUPDATE_TITLE, (String)CONFIRM_SQLUPDATE_MSG);
        }
        return replaceProc;
    }

    private void handleUndo(Collection notifications, Object txnSource) {
        notifications.isEmpty();
    }

    public void notifyChanged(Notification notification) {
        if (notification instanceof SourcedNotification) {
            SourcedNotification note = (SourcedNotification)notification;
            Object src = note.getSource();
            if (src == null || !src.equals(this)) {
                if (src == null) {
                    src = notification.getNotifier();
                }
                if (src instanceof ModelerUndoManager) {
                    Collection notifications = ((SourcedNotification)notification).getNotifications();
                    this.handleUndo(notifications, src);
                } else {
                    ModelObjectNotificationHelper helper = new ModelObjectNotificationHelper(notification);
                    boolean webServiceModelsChanged = false;
                    Iterator iter = helper.getModifiedResources().iterator();
                    while (iter.hasNext()) {
                        if (!ModelIdentifier.isWebServicesViewModel((IResource)((IResource)iter.next()))) continue;
                        webServiceModelsChanged = true;
                        break;
                    }
                    if (webServiceModelsChanged) {
                        Collection notifications = ((SourcedNotification)notification).getNotifications();
                        this.handleNotifications(notifications, src);
                    }
                }
            }
        } else {
            ArrayList<Notification> notifications = new ArrayList<Notification>(1);
            notifications.add(notification);
            this.handleNotifications(notifications, notification.getNotifier());
        }
    }

    private void processChangedXmlDocumentAsSource(Object source, Object value, boolean add, Object transactionSource) {
        if (!TransformationHelper.isSqlTransformationMappingRoot((Object)source)) {
            return;
        }
        EObject target = ((SqlTransformationMappingRoot)source).getTarget();
        if (!(target instanceof Operation)) {
            return;
        }
        Operation operation = add ? (Operation)target : null;
        XmlDocument xmlDocument = null;
        if (value instanceof List) {
            for (Object obj : (List)value) {
                if (!(obj instanceof XmlDocument)) continue;
                if (xmlDocument == null) {
                    xmlDocument = (XmlDocument)obj;
                    continue;
                }
                xmlDocument = null;
                break;
            }
        } else if (value instanceof XmlDocument) {
            xmlDocument = (XmlDocument)value;
        }
        if (xmlDocument != null && operation != null && operation.getOutput() != null) {
            WebServiceUiUtil.addXmlDocumentAsSource((SqlTransformationMappingRoot)source, xmlDocument, transactionSource);
        }
    }
}

