/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.editor;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.xsd.XSDElementDeclaration;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.ui.common.UILabelUtil;
import org.teiid.designer.ui.common.eventsupport.IDialogStatusListener;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.SelectFromEObjectListDialog;
import org.teiid.designer.webservice.ui.WebServiceUiPlugin;
import org.teiid.designer.webservice.ui.editor.WebServiceOperation;
import org.teiid.designer.webservice.ui.util.WebServiceUiUtil;

public class NewOperationPanel
extends Composite
implements StringConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(NewOperationPanel.class);
    protected IStatus currentStatus;
    protected IDialogStatusListener statusListener;
    boolean canFinish;
    Interface intFace;
    WebServiceOperation operation;
    Text modelNameText;
    Text nameText;
    Text inputMsgText;
    Text outputMsgText;
    StyledTextEditor descriptionTextEditor;
    TabItem generalPropertiesTab;
    private Button browseInputContentElementButton;
    private Text selectedInputContentText;
    private Button browseOutputContentElementButton;
    private Text selectedOutputContentText;
    private Button browseOutputXmlDocumentButton;
    private Text selectedOutputXmlDocumentText;
    ModelResource modelResource;

    private static String getString(String id) {
        return WebServiceUiPlugin.UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public NewOperationPanel(Composite parent, int style, Interface intFace, WebServiceOperation operation, IDialogStatusListener statusListener) {
        super(parent, style);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, true).hint(500, -1).applyTo((Control)this);
        this.intFace = intFace;
        this.operation = operation;
        this.statusListener = statusListener;
        this.initialize();
        this.nameText.setFocus();
    }

    private void initialize() {
        this.modelResource = ModelUtilities.getModelResource((Object)this.intFace);
        this.createContents();
    }

    private void createContents() {
        this.createNameGroup();
        TabFolder tabFolder = this.createTabFolder(this);
        this.createGeneralPropertiesTab(tabFolder);
        this.createDescriptionTab(tabFolder);
    }

    protected Composite createNameGroup() {
        Composite thePanel = WidgetFactory.createPanel((Composite)this, (int)0, (int)1, (int)2, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false);
        GridDataFactory.fillDefaults().grab(true, false).minSize(-1, 120).applyTo((Control)thePanel);
        Label label = new Label(thePanel, 0);
        label.setText(NewOperationPanel.getString("model"));
        GridDataFactory.fillDefaults().align(16384, 1).applyTo((Control)label);
        this.modelNameText = new Text(thePanel, 2052);
        this.modelNameText.setBackground(Display.getCurrent().getSystemColor(19));
        this.modelNameText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.modelNameText);
        this.modelNameText.setText(this.modelResource.getItemName());
        label = new Label(thePanel, 0);
        label.setText(NewOperationPanel.getString("operationName"));
        this.nameText = new Text(thePanel, 2052);
        if (this.operation.getName() != null) {
            this.nameText.setText(this.operation.getName());
        }
        this.nameText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = NewOperationPanel.this.nameText.getText();
                if (value == null) {
                    value = "";
                }
                NewOperationPanel.this.operation.setName(value);
                NewOperationPanel.this.handleInfoChanged();
            }
        });
        return thePanel;
    }

    protected void handleInfoChanged() {
        this.validate();
    }

    protected TabFolder createTabFolder(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 2176);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tabFolder);
        return tabFolder;
    }

    protected Composite createDescriptionPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)3);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Group descGroup = WidgetFactory.createGroup((Composite)thePanel, (String)UILabelUtil.getLabel((int)7), (int)1808, (int)3);
        this.descriptionTextEditor = new StyledTextEditor((Composite)descGroup, 2882);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 40).minSize(-1, 30).applyTo((Control)this.descriptionTextEditor.getTextWidget());
        this.descriptionTextEditor.setText("");
        this.descriptionTextEditor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewOperationPanel.this.operation.setDescription(NewOperationPanel.this.descriptionTextEditor.getText());
            }
        });
        return thePanel;
    }

    private void createDescriptionTab(TabFolder folderParent) {
        Composite thePanel = this.createDescriptionPanel((Composite)folderParent);
        TabItem descriptionTab = new TabItem(folderParent, 0);
        descriptionTab.setControl((Control)thePanel);
        descriptionTab.setText(UILabelUtil.getLabel((int)7));
    }

    private void createGeneralPropertiesTab(TabFolder folderParent) {
        Composite thePanel = this.createPropertiesPanel((Composite)folderParent);
        this.generalPropertiesTab = new TabItem(folderParent, 0);
        this.generalPropertiesTab.setControl((Control)thePanel);
        this.generalPropertiesTab.setText(UILabelUtil.getLabel((int)6));
    }

    private Composite createPropertiesPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)3);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Group inputMessagePanel = WidgetFactory.createGroup((Composite)thePanel, (String)NewOperationPanel.getString("inputMessageGroup"), (int)1808);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)inputMessagePanel);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).margins(3, 3).applyTo((Composite)inputMessagePanel);
        Label label = new Label((Composite)inputMessagePanel, 0);
        label.setText(UILabelUtil.getLabel((int)14));
        this.inputMsgText = new Text((Composite)inputMessagePanel, 2052);
        if (this.operation.getInputMessageName() != null) {
            this.inputMsgText.setText(this.operation.getInputMessageName());
        }
        this.inputMsgText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.inputMsgText);
        this.inputMsgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewOperationPanel.this.operation.setInputMessageName(NewOperationPanel.this.inputMsgText.getText());
                NewOperationPanel.this.handleInfoChanged();
            }
        });
        Label contentViaLabel = new Label((Composite)inputMessagePanel, 0);
        contentViaLabel.setText(NewOperationPanel.getString("schemaContentViaElementLabel"));
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.selectedInputContentText = WidgetFactory.createTextField((Composite)inputMessagePanel, (int)768);
        this.selectedInputContentText.setToolTipText(NewOperationPanel.getString("inputElementTooltip"));
        this.selectedInputContentText.setEditable(false);
        this.selectedInputContentText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedInputContentText.setForeground(Display.getCurrent().getSystemColor(10));
        this.browseInputContentElementButton = WidgetFactory.createButton((Composite)inputMessagePanel, (String)UILabelUtil.getLabel((int)0));
        this.browseInputContentElementButton.setToolTipText(NewOperationPanel.getString("browseForInputElementTooltip"));
        this.browseInputContentElementButton.setEnabled(true);
        this.browseInputContentElementButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.browseInputContentElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                NewOperationPanel.this.handleBrowseWorkspaceInputContentViaElement();
            }
        });
        Group outputMessagePanel = WidgetFactory.createGroup((Composite)thePanel, (String)NewOperationPanel.getString("inputMessageGroup"), (int)1808);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)outputMessagePanel);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).margins(3, 3).applyTo((Composite)outputMessagePanel);
        label = new Label((Composite)outputMessagePanel, 0);
        label.setText(UILabelUtil.getLabel((int)14));
        this.outputMsgText = new Text((Composite)outputMessagePanel, 2052);
        if (this.operation.getOutputMessageName() != null) {
            this.outputMsgText.setText(this.operation.getOutputMessageName());
        }
        this.outputMsgText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.outputMsgText);
        this.outputMsgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewOperationPanel.this.operation.setOutputMessageName(NewOperationPanel.this.outputMsgText.getText());
                NewOperationPanel.this.handleInfoChanged();
            }
        });
        contentViaLabel = new Label((Composite)outputMessagePanel, 0);
        contentViaLabel.setText("Schema Content Via Element");
        contentViaLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.selectedOutputContentText = WidgetFactory.createTextField((Composite)outputMessagePanel, (int)768);
        this.selectedOutputContentText.setToolTipText(NewOperationPanel.getString("outputElementTooltip"));
        this.selectedOutputContentText.setEditable(false);
        this.selectedOutputContentText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedOutputContentText.setForeground(Display.getCurrent().getSystemColor(10));
        this.browseOutputContentElementButton = WidgetFactory.createButton((Composite)outputMessagePanel, (String)UILabelUtil.getLabel((int)0));
        this.browseOutputContentElementButton.setToolTipText(NewOperationPanel.getString("browseForOutputElementTooltip"));
        this.browseOutputContentElementButton.setEnabled(true);
        this.browseOutputContentElementButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.browseOutputContentElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                NewOperationPanel.this.handleBrowseWorkspaceOutputContentViaElement();
            }
        });
        Label xmlDocumentLabel = new Label((Composite)outputMessagePanel, 0);
        xmlDocumentLabel.setText(NewOperationPanel.getString("outputXMLDocumentLabel"));
        xmlDocumentLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.selectedOutputXmlDocumentText = WidgetFactory.createTextField((Composite)outputMessagePanel, (int)768);
        this.selectedOutputXmlDocumentText.setToolTipText(NewOperationPanel.getString("outputXmlDocumentTooltip"));
        this.selectedOutputXmlDocumentText.setEditable(false);
        this.selectedOutputXmlDocumentText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedOutputXmlDocumentText.setForeground(Display.getCurrent().getSystemColor(10));
        this.browseOutputXmlDocumentButton = WidgetFactory.createButton((Composite)outputMessagePanel, (String)UILabelUtil.getLabel((int)0));
        this.browseOutputXmlDocumentButton.setToolTipText(NewOperationPanel.getString("browseForXmlDocumentTooltip"));
        this.browseOutputXmlDocumentButton.setEnabled(true);
        this.browseOutputXmlDocumentButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.browseOutputXmlDocumentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                NewOperationPanel.this.handleBrowseWorkspaceOutputXmlDocument();
            }
        });
        return thePanel;
    }

    private void handleBrowseWorkspaceInputContentViaElement() {
        Collection<EObject> elements = WebServiceUiUtil.getGlobalElementDeclarations((EObject)this.intFace);
        SelectFromEObjectListDialog sdDialog = this.createElementSelectionDialog(elements);
        sdDialog.open();
        if (sdDialog.getReturnCode() == 0) {
            Object[] selections = sdDialog.getResult();
            EObject element = (EObject)selections[0];
            String name = ModelerCore.getModelEditor().getName(element);
            this.selectedInputContentText.setText(name);
            this.operation.setInputContentViaElement((XSDElementDeclaration)element);
            this.handleInfoChanged();
        }
    }

    private void handleBrowseWorkspaceOutputContentViaElement() {
        Collection<EObject> elements = WebServiceUiUtil.getGlobalElementDeclarations((EObject)this.intFace);
        SelectFromEObjectListDialog sdDialog = this.createElementSelectionDialog(elements);
        sdDialog.open();
        if (sdDialog.getReturnCode() == 0) {
            Object[] selections = sdDialog.getResult();
            EObject element = (EObject)selections[0];
            String name = ModelerCore.getModelEditor().getName(element);
            this.selectedOutputContentText.setText(name);
            this.operation.setOutputContentViaElement((XSDElementDeclaration)element);
            this.handleInfoChanged();
        }
    }

    private void handleBrowseWorkspaceOutputXmlDocument() {
        Collection<EObject> elements = WebServiceUiUtil.getXmlDocumentsForProject((EObject)this.intFace);
        SelectFromEObjectListDialog sdDialog = this.createXmlDocumentSelectionDialog(elements);
        sdDialog.open();
        if (sdDialog.getReturnCode() == 0) {
            Object[] selections = sdDialog.getResult();
            EObject element = (EObject)selections[0];
            String name = ModelerCore.getModelEditor().getName(element);
            this.selectedOutputXmlDocumentText.setText(name);
            this.operation.setXmlDocument((XmlDocument)element);
            this.handleInfoChanged();
        }
    }

    private SelectFromEObjectListDialog createElementSelectionDialog(Collection<EObject> elementList) {
        String title = "Schema Element Selection";
        String message = "Select schema element for content via element reference in operation message";
        SelectFromEObjectListDialog dialog = new SelectFromEObjectListDialog(this.getShell(), elementList, false, title, message, (LabelProvider)ModelUtilities.getModelObjectLabelProvider());
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0 || selection[0] == null || !(selection[0] instanceof XSDElementDeclaration)) {
                    return new StatusInfo("org.teiid.designer.webservice", 4, "No Element Selected");
                }
                return new StatusInfo("org.teiid.designer.webservice");
            }
        });
        return dialog;
    }

    private SelectFromEObjectListDialog createXmlDocumentSelectionDialog(Collection<EObject> elementList) {
        String title = NewOperationPanel.getString("selectXmlDocument.title");
        String message = NewOperationPanel.getString("selectXmlDocumentForOutputMessage.message");
        SelectFromEObjectListDialog dialog = new SelectFromEObjectListDialog(this.getShell(), elementList, false, title, message, (LabelProvider)ModelUtilities.getModelObjectLabelProvider());
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0 || selection[0] == null || !(selection[0] instanceof XmlDocument)) {
                    return new StatusInfo("org.teiid.designer.webservice", 4, "No XML Document Selected");
                }
                return new StatusInfo("org.teiid.designer.webservice");
            }
        });
        return dialog;
    }

    protected void validate() {
        this.operation.validate();
        this.currentStatus = this.operation.getStatus();
        this.setCanFinish(this.currentStatus.getSeverity() != 4);
        this.statusListener.notifyStatusChanged(this.currentStatus);
    }

    protected final void setCanFinish(boolean value) {
        this.canFinish = value;
    }

    public boolean canFinish() {
        return this.canFinish;
    }
}

