/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.actions;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDParser;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.text.ScaledFontManager;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.webservice.gen.BasicWsdlGenerator;

public class PreviewWsdlAction
extends SortableSelectionAction {
    public List<ModelResource> wsResources = new ArrayList<ModelResource>();
    public static String WSDL_GENERATION = "WSDL Preview";
    public static String WSDL_GENERATION_SUCCESS = "Successfully generated WSDL file: ";
    public static String WSDL_GENERATION_ERROR = "There was an error generating the WSDL...";
    public static String WSDL_DIALOG_TITLE = "WSDL Preview";

    public void run() {
        BasicWsdlGenerator wsdlGenerator = new BasicWsdlGenerator();
        String webServiceName = "TeiidWS";
        for (ModelResource webServiceModel : this.wsResources) {
            try {
                wsdlGenerator.addWebServiceModel(webServiceModel.getEmfResource());
                webServiceName = webServiceModel.getItemName();
                List iResources = WorkspaceResourceFinderUtil.getDependentResources((IResource)webServiceModel.getResource());
                for (IResource iResource : iResources) {
                    if (!ModelIdentifier.isSchemaModel((IResource)iResource)) continue;
                    wsdlGenerator.addXsdModel(this.importSchema(iResource.getLocation().toOSString()), iResource.getLocation());
                }
            }
            catch (ModelWorkspaceException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        webServiceName = webServiceName.substring(0, webServiceName.lastIndexOf("."));
        wsdlGenerator.setName(webServiceName);
        wsdlGenerator.setTargetNamespace("http://teiid.org");
        wsdlGenerator.setUrlRootForReferences("");
        wsdlGenerator.setUrlSuffixForReferences("");
        wsdlGenerator.setUrlForWsdlService("http://serverName:port/warName/");
        IStatus status = wsdlGenerator.generate((IProgressMonitor)new NullProgressMonitor());
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        BufferedOutputStream stream = new BufferedOutputStream(bas);
        try {
            try {
                wsdlGenerator.write((OutputStream)stream);
            }
            catch (IOException e) {
                MessageDialog.openInformation(null, (String)WSDL_GENERATION, (String)(String.valueOf(WSDL_GENERATION_ERROR) + e.getMessage()));
                throw new RuntimeException(e.getMessage());
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        if (status.getSeverity() == 4) {
            ErrorDialog.openError(null, (String)WSDL_GENERATION, (String)WSDL_GENERATION_ERROR, (IStatus)status);
            throw new RuntimeException("Unable to generate WSDL");
        }
        new WsdlDialog(Display.getDefault().getActiveShell(), bas.toString()).open();
    }

    public XSDSchema importSchema(String path) {
        XSDParser parser = new XSDParser(null);
        parser.parse(path);
        XSDSchema schema = parser.getSchema();
        schema.setSchemaLocation(path);
        return schema;
    }

    protected boolean isValidSelection(ISelection selection) {
        boolean isValid = true;
        this.wsResources = new ArrayList<ModelResource>();
        if (SelectionUtilities.isEmptySelection((ISelection)selection)) {
            isValid = false;
        }
        if (isValid) {
            List objs = SelectionUtilities.getSelectedObjects((ISelection)selection);
            Iterator selections = objs.iterator();
            while (selections.hasNext() && isValid) {
                Object next = selections.next();
                ModelResource modelResource = null;
                if (next instanceof IFile) {
                    modelResource = ModelerCore.getModelWorkspace().findModelResource((IResource)((IFile)next));
                    if (modelResource != null) {
                        isValid = ModelIdentifier.isWebServicesViewModel((ModelResource)modelResource);
                        this.wsResources.add(modelResource);
                    } else {
                        isValid = false;
                    }
                } else {
                    isValid = false;
                }
                if (!isValid) break;
            }
        }
        return isValid;
    }

    public boolean isApplicable(ISelection selection) {
        return this.isValidSelection(selection);
    }

    class WsdlDialog
    extends Dialog {
        private StyledText text;
        private String wsdlString;

        public WsdlDialog(Shell shell, String wsdlString) {
            super(shell, WSDL_DIALOG_TITLE);
            this.wsdlString = wsdlString;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.text = new StyledText(composite, 512);
            GridData gd = new GridData(1808);
            this.text.setLayoutData((Object)gd);
            this.text.setEditable(false);
            this.text.setWordWrap(true);
            this.text.setTabs(4);
            StyleRange bodyRange = new StyleRange();
            bodyRange.start = 0;
            bodyRange.length = this.wsdlString.length();
            ScaledFontManager fontManager = new ScaledFontManager();
            this.text.setFont(fontManager.createFontOfSize(10));
            this.text.setText(this.wsdlString);
            this.text.setStyleRange(bodyRange);
            super.setSizeRelativeToScreen(75, 70);
            return composite;
        }

        public void create() {
            this.setShellStyle(this.getShellStyle() | 0x10);
            super.create();
            super.getShell().setText(WSDL_DIALOG_TITLE);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            okButton.setFocus();
        }
    }
}

