/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.xmi.XMIHeader;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.WebServiceUiPlugin;
import org.teiid.designer.webservice.ui.wizard.GenerateWebServiceModelWizard;
import org.teiid.designer.xml.ui.wizards.XmlDocumentContentProvider;
import org.teiid.designer.xml.ui.wizards.XmlDocumentSelectorDialog;

public class GenerateWebServiceModelAction2
extends SortableSelectionAction
implements IInternalUiConstants {
    private static final String KEY_NO_SEL_DLG_MSG = "GenerateWebServiceModelAction.noSelMsg";
    private static final String NO_SEL_DLG_TITLE = IInternalUiConstants.UTIL.getString("GenerateWebServiceModelAction.noSelTitle", new Object[0]);
    private static final String DEFAULT_EXPLORER_TITLE = IInternalUiConstants.UTIL.getString("GenerateWebServiceModelAction.defaultViewName", new Object[0]);
    private boolean canIgnoreSelection = false;

    public GenerateWebServiceModelAction2() {
        this.setImageDescriptor(WebServiceUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/CreateWebService.png"));
    }

    public boolean isApplicable(ISelection selection) {
        return this.isValidSelection(selection);
    }

    private boolean isDocumentOrRootSelected(ISelection selection) {
        if (!SelectionUtilities.isSingleSelection((ISelection)selection)) {
            return false;
        }
        Object selectedObject = SelectionUtilities.getSelectedObject((ISelection)selection);
        return selectedObject != null && (selectedObject instanceof XmlDocument || selectedObject instanceof XmlRoot);
    }

    private boolean isSingleXmlDocumentModelSelected(ISelection selection) {
        String mmURI;
        IResource iResource;
        XMIHeader header;
        if (!SelectionUtilities.isSingleSelection((ISelection)selection)) {
            return false;
        }
        Object selectedObject = SelectionUtilities.getSelectedObject((ISelection)selection);
        return selectedObject instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)selectedObject)) && (header = ModelUtil.getXmiHeader((IResource)(iResource = (IResource)selectedObject))) != null && (mmURI = header.getPrimaryMetamodelURI()) != null && mmURI.equals("http://www.metamatrix.com/metamodels/XmlDocument");
    }

    protected boolean isValidSelection(ISelection selection) {
        boolean isValid = true;
        if (SelectionUtilities.isEmptySelection((ISelection)selection)) {
            isValid = false;
        }
        if (isValid && SelectionUtilities.isSingleSelection((ISelection)selection)) {
            List objs = SelectionUtilities.getSelectedObjects((ISelection)selection);
            Iterator selections = objs.iterator();
            while (selections.hasNext() && isValid) {
                Object next = selections.next();
                isValid = next instanceof XmlDocument || next instanceof XmlRoot;
                if (isValid) {
                    continue;
                }
                break;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void run() {
        IWorkbenchWindow iww = WebServiceUiPlugin.getDefault().getCurrentWorkbenchWindow();
        if (!ProductCustomizerMgr.getInstance().getProductCharacteristics().preProcess((Object)this, iww.getShell())) {
            this.notifyResult(false);
            return;
        }
        ISelection selection = this.getSelection();
        IStructuredSelection thisSelection = null;
        if (selection != null && !selection.isEmpty() && this.isDocumentOrRootSelected(selection)) {
            thisSelection = (IStructuredSelection)selection;
        } else if (this.canIgnoreSelection) {
            this.canIgnoreSelection = false;
            ModelExplorerLabelProvider labelProvider = new ModelExplorerLabelProvider();
            XmlDocumentContentProvider contentProvider = new XmlDocumentContentProvider();
            XmlDocumentSelectorDialog xmlDialog = new XmlDocumentSelectorDialog(WebServiceUiPlugin.getDefault().getCurrentWorkbenchWindow().getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
            xmlDialog.setAllowMultiple(false);
            if (selection != null && !selection.isEmpty() && this.isSingleXmlDocumentModelSelected(selection)) {
                xmlDialog.setInput(SelectionUtilities.getSelectedObject((ISelection)selection));
            }
            xmlDialog.open();
            if (xmlDialog.getReturnCode() != 0) {
                return;
            }
            Object[] oSelectedObjects = xmlDialog.getResult();
            if (oSelectedObjects.length != 1) {
                String title = IInternalUiConstants.UTIL.getString("GenerateWebServiceModelAction.selectionError.title", new Object[0]);
                String dlgMsg = IInternalUiConstants.UTIL.getString("GenerateWebServiceModelAction.selectionError.emptySelection", new Object[0]);
                MessageDialog.openError((Shell)iww.getShell(), (String)title, (String)dlgMsg);
                this.notifyResult(false);
                return;
            }
            if (!(oSelectedObjects[0] instanceof XmlDocument) && !(oSelectedObjects[0] instanceof XmlRoot)) {
                String title = IInternalUiConstants.UTIL.getString("GenerateWebServiceModelAction.selectionError.title", new Object[0]);
                String dlgMsg = IInternalUiConstants.UTIL.getString("GenerateWebServiceModelAction.selectionError.wrongType", new Object[0]);
                MessageDialog.openError((Shell)iww.getShell(), (String)title, (String)dlgMsg);
                this.notifyResult(false);
                return;
            }
            thisSelection = new StructuredSelection(oSelectedObjects[0]);
        } else {
            IViewReference ivr = iww.getActivePage().findViewReference(ProductCustomizerMgr.getInstance().getProductCharacteristics().getPrimaryNavigationViewId());
            String viewTitle = ivr != null ? ivr.getTitle() : DEFAULT_EXPLORER_TITLE;
            String dlgMsg = IInternalUiConstants.UTIL.getString(KEY_NO_SEL_DLG_MSG, (Object)viewTitle);
            MessageDialog.openError((Shell)iww.getShell(), (String)NO_SEL_DLG_TITLE, (String)dlgMsg);
            return;
        }
        GenerateWebServiceModelWizard wizard = new GenerateWebServiceModelWizard();
        wizard.init(iww.getWorkbench(), thisSelection);
        WizardDialog dialog = new WizardDialog(wizard.getShell(), (IWizard)wizard);
        int rc = dialog.open();
        if (rc == 1) {
            this.notifyResult(false);
            return;
        }
        MultiStatus result = wizard.getResult();
        int severity = result.getSeverity();
        if (severity == 4) {
            String errTitle = IInternalUiConstants.UTIL.getString("GenerateWebServiceModelAction.errTitle", new Object[0]);
            String err = IInternalUiConstants.UTIL.getString("GenerateWebServiceModelAction.errFinish", new Object[0]);
            ErrorDialog.openError((Shell)wizard.getShell(), (String)errTitle, (String)err, (IStatus)result);
        } else if (severity == 2) {
            String warnTitle = IInternalUiConstants.UTIL.getString("GenerateWebServiceModelAction.warnTitle", new Object[0]);
            String warn = IInternalUiConstants.UTIL.getString("GenerateWebServiceModelAction.warnFinish", new Object[0]);
            ErrorDialog.openError((Shell)wizard.getShell(), (String)warnTitle, (String)warn, (IStatus)result);
        } else {
            String okTitle = IInternalUiConstants.UTIL.getString("GenerateWebServiceModelAction.successTitle", new Object[0]);
            String ok = IInternalUiConstants.UTIL.getString("GenerateWebServiceModelAction.successFinish", new Object[0]);
            ArrayList<String> msgs = new ArrayList<String>(result.getChildren().length);
            int i = 0;
            while (i < result.getChildren().length) {
                msgs.add(result.getChildren()[i].getMessage());
                ++i;
            }
            if (msgs.size() > 0) {
                ListMessageDialog.openInformation((Shell)wizard.getShell(), (String)okTitle, null, (String)ok, msgs, null);
            } else {
                MessageDialog.openInformation((Shell)wizard.getShell(), (String)okTitle, (String)ok);
            }
        }
        this.notifyResult(severity < 4 && rc != 1);
    }

    public void setCanIgnoreSelection(boolean theCanIgnoreSelection) {
        this.canIgnoreSelection = theCanIgnoreSelection;
    }
}

