/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.EditorMessages;
import org.fusesource.ide.camel.editor.commands.DiagramOperations;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.model.RouteSupport;

public class DeleteRouteAction
extends Action {
    public static final String DELETE_ROUTE_COMMAND_ID = "org.fusesource.ide.camel.editor.commands.deleteRouteCommand";
    private RouteSupport selectedRoute;

    public void run() {
        RiderDesignEditor editor = Activator.getDiagramEditor();
        DiagramOperations.deleteRoute(editor, this.getSelectedRoute());
        if (editor.getModel().getChildren().size() < 1) {
            editor.addNewRoute();
        }
    }

    public String getId() {
        return DELETE_ROUTE_COMMAND_ID;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
    }

    public String getDescription() {
        return EditorMessages.deleteRouteCommandDescription;
    }

    public String getText() {
        return EditorMessages.deleteRouteCommandLabel;
    }

    public String getToolTipText() {
        return EditorMessages.deleteRouteCommandDescription;
    }

    public void setSelectedRoute(RouteSupport selectedRoute) {
        this.selectedRoute = selectedRoute;
    }

    public RouteSupport getSelectedRoute() {
        return this.selectedRoute;
    }
}

