/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.create;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.editor.provider.ext.PaletteCategoryItemProvider;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.Flow;
import org.fusesource.ide.camel.model.RouteSupport;
import org.fusesource.ide.camel.model.catalog.CamelModelFactory;
import org.fusesource.ide.camel.model.catalog.eips.Eip;
import org.fusesource.ide.camel.model.generated.Choice;

public class CreateFlowFeature
extends AbstractCreateConnectionFeature
implements PaletteCategoryItemProvider {
    public CreateFlowFeature(IFeatureProvider fp) {
        super(fp, "Flow", "Create Flow");
    }

    @Override
    public PaletteCategoryItemProvider.CATEGORY_TYPE getCategoryType() {
        String name = this.getCategoryName();
        return PaletteCategoryItemProvider.CATEGORY_TYPE.getCategoryType(name);
    }

    public boolean canCreate(ICreateConnectionContext context) {
        AbstractNode source = this.getNode(context.getSourceAnchor());
        AbstractNode target = this.getNode(context.getTargetAnchor());
        if (target != null && source != target) {
            if (!this.canHaveMultipleOutputs(source) && !source.getOutputs().isEmpty()) {
                return false;
            }
            return source == null || source.canConnectTo(target);
        }
        return false;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        return this.getNode(context.getSourceAnchor()) != null;
    }

    public String getCreateImageId() {
        return "org.fusesource.demo.icons.flow";
    }

    public String getCreateLargeImageId() {
        return this.getCreateImageId();
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        AbstractNode source = this.getNode(context.getSourceAnchor());
        AbstractNode target = this.getNode(context.getTargetAnchor());
        if (target != null) {
            if (source == null) {
                RouteSupport route;
                RiderDesignEditor editor = RiderDesignEditor.toRiderDesignEditor(this.getDiagramBehavior());
                if (editor != null && (route = editor.getSelectedRoute()) != null) {
                    route.addChild(target);
                }
            } else {
                Flow eReference = this.createFlow(source, target);
                AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
                addContext.setNewObject((Object)eReference);
                newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            }
        }
        return newConnection;
    }

    private AbstractNode getNode(Anchor anchor) {
        Object obj;
        if (anchor != null && (obj = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof AbstractNode) {
            return (AbstractNode)obj;
        }
        return null;
    }

    private Flow createFlow(AbstractNode source, AbstractNode target) {
        Flow flow = new Flow(source, target);
        flow.setName("new Flow");
        return flow;
    }

    @Override
    public String getCategoryName() {
        return null;
    }

    protected boolean canHaveMultipleOutputs(AbstractNode source) {
        String camelVersion = Activator.getDefault().getCamelVersion();
        Eip eip = CamelModelFactory.getModelForVersion((String)camelVersion).getEipModel().getEIPByClass(source.getPatternName());
        if (eip != null) {
            return eip.getOutput().equalsIgnoreCase("true") || source instanceof Choice;
        }
        return false;
    }
}

