/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.editor;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DefaultPersistencyBehavior;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.io.IRemoteCamelEditorInput;
import org.fusesource.ide.camel.model.util.CamelContextIOUtils;
import org.fusesource.ide.commons.camel.tools.ValidationHandler;

public class CamelPersistencyBehaviour
extends DefaultPersistencyBehavior {
    private RiderDesignEditor editor;

    public CamelPersistencyBehaviour(RiderDesignEditor editor) {
        super(editor.getDiagramBehavior());
        this.editor = editor;
    }

    public Diagram loadDiagram(URI uri) {
        if (!this.loadModel(this.editor.getEditorInput())) {
            return null;
        }
        this.editor.getActiveConfig().diagram = Graphiti.getPeCreateService().createDiagram("CamelContext", "CamelContext", true);
        return this.editor.getActiveConfig().diagram;
    }

    protected boolean loadModel(IEditorInput input) {
        IFile camelContextFile = null;
        IProject container = null;
        IFileEditorInput fileEditorInput = this.editor.asFileEditorInput(input);
        if (fileEditorInput != null) {
            camelContextFile = fileEditorInput.getFile();
            container = camelContextFile.getProject();
            if (this.editor.getModel() == null) {
                try {
                    this.editor.setModel(CamelContextIOUtils.loadModelFromFile((IFile)camelContextFile));
                    this.editor.setCamelContextFile(camelContextFile);
                    ValidationHandler status = CamelContextIOUtils.validateModel((RouteContainer)this.editor.getModel());
                    if (status.hasErrors()) {
                        Activator.getLogger().error("Unable to validate the model. Invalid input!");
                        return false;
                    }
                }
                catch (PartInitException pe) {
                    Activator.getLogger().error("Unable to load the model. Invalid input!", (Throwable)pe);
                    return false;
                }
            }
            return true;
        }
        IRemoteCamelEditorInput remoteEditorInput = this.editor.asRemoteCamelEditorInput(input);
        if (remoteEditorInput != null) {
            camelContextFile = null;
            container = null;
            if (this.editor.getModel() == null) {
                String text = remoteEditorInput.getXml();
                try {
                    this.editor.setModel(CamelContextIOUtils.loadModelFromText((String)text));
                    ValidationHandler status = CamelContextIOUtils.validateModel((RouteContainer)this.editor.getModel());
                    if (status.hasErrors()) {
                        Activator.getLogger().error("Unable to validate the model. Invalid input!");
                        return false;
                    }
                }
                catch (PartInitException pe) {
                    try {
                        Activator.getLogger().error("Unable to load the model. Invalid input!", (Throwable)pe);
                        return false;
                    }
                    catch (IOException e) {
                        Activator.getLogger().error("Unable to load the model: " + e, (Throwable)e);
                        return false;
                    }
                }
            }
            this.editor.setCamelContextFile(camelContextFile);
            this.editor.setContainer(container);
            return true;
        }
        return false;
    }
}

