/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.webservices.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDParser;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.workspace.ModelObjectAnnotationHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionConstants;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.XmiVdb;
import org.teiid.designer.webservice.gen.BasicWsdlGenerator;

public class WarArchiveUtil {
    public static final String TARGETNS = "targetNs";
    public static final String WEBSERVICENAME = "webserviceName";
    public static final String URLROOT = "urlRoot";
    public static final String SERVICEURL = "serviceUrl";
    public static final String WSDLFILE_EXT = "wsdl";
    private static final ModelObjectAnnotationHelper ANNOTATION_HELPER = new ModelObjectAnnotationHelper();

    public XSDSchema importSchema(String path) {
        XSDParser parser = new XSDParser(null);
        parser.parse(path);
        XSDSchema schema = parser.getSchema();
        schema.setSchemaLocation(path);
        return schema;
    }

    public static ArrayList<String> getPathParameters(String uri) {
        ArrayList<String> pathParams = new ArrayList<String>();
        if (uri.contains("{")) {
            while (uri.indexOf("}") > -1) {
                int start = uri.indexOf("{");
                int end = uri.indexOf("}");
                String param = uri.substring(start + 1, end);
                uri = uri.substring(end + 1);
                pathParams.add(param);
            }
        }
        return pathParams;
    }

    public void generateWSDL(ArrayList<ModelResource> wsModelResourceList, Properties userSuppliedValues) {
        BasicWsdlGenerator wsdlGenerator = new BasicWsdlGenerator();
        ModelResource wsModel = null;
        String webServiceName = userSuppliedValues.getProperty(WEBSERVICENAME, "TeiidWS");
        for (ModelResource webServiceModel : wsModelResourceList) {
            try {
                wsModel = webServiceModel;
                wsdlGenerator.addWebServiceModel(webServiceModel.getEmfResource());
                webServiceName = webServiceModel.getItemName();
                List iResources = WorkspaceResourceFinderUtil.getDependentResources((IResource)webServiceModel.getResource());
                for (IResource iResource : iResources) {
                    if (!ModelIdentifier.isSchemaModel((IResource)iResource)) continue;
                    wsdlGenerator.addXsdModel(this.importSchema(iResource.getLocation().toOSString()), iResource.getLocation());
                }
            }
            catch (ModelWorkspaceException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        webServiceName = webServiceName.substring(0, webServiceName.lastIndexOf("."));
        wsdlGenerator.setName(webServiceName);
        wsdlGenerator.setTargetNamespace(userSuppliedValues.getProperty(TARGETNS, "http://teiid.org"));
        wsdlGenerator.setUrlRootForReferences(userSuppliedValues.getProperty(URLROOT, ""));
        wsdlGenerator.setUrlSuffixForReferences("");
        wsdlGenerator.setUrlForWsdlService(userSuppliedValues.getProperty(SERVICEURL, "http://serverName:port/warName/"));
        IStatus status = wsdlGenerator.generate((IProgressMonitor)new NullProgressMonitor());
        if (status.getSeverity() == 4) {
            throw new RuntimeException("Unable to generate WSDL");
        }
        String fileName = String.valueOf(webServiceName) + "." + WSDLFILE_EXT;
        try {
            String path = wsModel.getResource().getLocation().toOSString();
            FileOutputStream stream = new FileOutputStream(new File(path.substring(0, path.lastIndexOf("/")), fileName));
            wsdlGenerator.write((OutputStream)stream);
            IFile iFile = wsModel.getModelProject().getProject().getFile(fileName);
            iFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (CoreException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean isRestWarVdb(IFile vdbFile) throws Exception {
        if (!WarArchiveUtil.isVdb(vdbFile)) {
            return false;
        }
        boolean result = false;
        try {
            XmiVdb vdb = new XmiVdb(vdbFile);
            Set modelEntrySet = vdb.getModelEntries();
            for (VdbEntry vdbModelEntry : modelEntrySet) {
                ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource(vdbModelEntry.getPath());
                if (!ModelIdentifier.isVirtualModelType((ModelResource)modelResource) || !(result = WarArchiveUtil.hasRestProcedures(modelResource))) {
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            new RuntimeException(ex);
        }
        return result;
    }

    private static boolean isVdb(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IFile)) {
            return false;
        }
        return "vdb".equals(((IFile)obj).getFileExtension());
    }

    private static boolean hasRestProcedures(ModelResource modelResource) throws Exception {
        List eObjectList = modelResource.getEObjects();
        boolean result = false;
        block0: for (EObject eObject : eObjectList) {
            if (!SqlAspectHelper.isProcedure((EObject)eObject)) continue;
            IPath path = ModelerCore.getModelEditor().getModelRelativePathIncludingModel(eObject);
            StringBuffer sb = new StringBuffer();
            String[] segments = path.segments();
            int i = 0;
            while (i < segments.length) {
                if (i != 0) {
                    sb.append('.');
                }
                String segment = segments[i];
                sb.append(segment);
                Procedure procedure = (Procedure)eObject;
                String restMethod = WarArchiveUtil.getRestMethod(procedure);
                String uri = null;
                if (restMethod != null) {
                    uri = WarArchiveUtil.getUri(procedure);
                }
                if (uri != null && restMethod != null) {
                    result = true;
                    continue block0;
                }
                ++i;
            }
        }
        return result;
    }

    public static String getUri(Procedure procedure) {
        String uri = null;
        try {
            ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(RestModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
            uri = assistant.getPropertyValue((Object)procedure, RestModelExtensionConstants.PropertyIds.URI);
            if (CoreStringUtil.isEmpty((String)uri)) {
                uri = (String)ANNOTATION_HELPER.getPropertyValueAnyCase((EObject)procedure, "ext-custom:URI");
            }
        }
        catch (Exception e) {
            DqpUiConstants.UTIL.log((Throwable)e);
        }
        return uri;
    }

    public static String getRestMethod(Procedure procedure) {
        String restMethod = null;
        try {
            ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(RestModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
            restMethod = assistant.getPropertyValue((Object)procedure, RestModelExtensionConstants.PropertyIds.REST_METHOD);
            if (CoreStringUtil.isEmpty((String)restMethod.trim())) {
                restMethod = (String)ANNOTATION_HELPER.getPropertyValueAnyCase((EObject)procedure, "ext-custom:REST-METHOD");
            }
        }
        catch (Exception e) {
            DqpUiConstants.UTIL.log((Throwable)e);
        }
        return restMethod;
    }
}

