/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.webservices;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.DqpUiStringUtil;
import org.teiid.designer.runtime.ui.wizards.webservices.InternalModelerWarUiConstants;
import org.teiid.designer.runtime.ui.wizards.webservices.WarDataserviceModel;
import org.teiid.designer.runtime.ui.wizards.webservices.WarDeploymentInfoDialog;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;

public abstract class WarDeploymentInfoPanel
extends Composite
implements InternalModelerWarUiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(WarDeploymentInfoDialog.class);
    protected static final String INITIAL_MESSAGE = WarDeploymentInfoPanel.getString("initialMessage");
    private static final String SECURITY_OPTIONS_GROUP = WarDeploymentInfoPanel.getString("securityOptionsGroup");
    private static final String GENERAL_OPTIONS_GROUP = WarDeploymentInfoPanel.getString("generalOptionsGroup");
    private static final String BASIC_OPTIONS_GROUP = WarDeploymentInfoPanel.getString("basicOptionsGroup");
    private static final String WS_SECURITY_OPTIONS_GROUP = WarDeploymentInfoPanel.getString("wsSecurityOptionsGroup");
    protected IDialogSettings settings;
    protected WarDeploymentInfoDialog dialog;
    protected Text txfWarFileDeploymentLocation;
    protected Text txfContext;
    protected Text txfNamespace;
    protected Text txfHost;
    protected Text txfPort;
    protected Text txfSecurityRealm;
    protected Text txfSecurityRole;
    protected Text txfSecurityUsername;
    protected Text txfSecurityPassword;
    public static final String NOSECURITY = WarDeploymentInfoPanel.getString("noSecurityButton");
    public static final String BASIC = WarDeploymentInfoPanel.getString("basicButton");
    public static final String WSSE = WarDeploymentInfoPanel.getString("wsSecurityButton");
    public static final String MTOM = WarDeploymentInfoPanel.getString("mtomButton");
    protected Text txfJNDIName;
    protected Button noSecurityButton;
    protected Button basicSecurityButton;
    protected Button wsSecurityButton;
    protected Button mtomButton;
    private Button warBrowseButton;
    private Button restoreDefaultButton;
    private TabItem generalSecurityTab;
    private TabItem httpOptionsTab;
    private TabItem wsSecurityTab;
    protected IFile theVdb;
    protected String WARFILELOCATION;
    protected String NAMESPACE;
    protected String CONTEXTNAME;
    protected String HOST;
    protected String PORT;
    protected String JNDI_NAME;
    protected String SECURITY_TYPE;
    protected String SECURITY_REALM;
    protected String SECURITY_ROLE;
    protected String SECURITY_USERNAME;
    protected String SECURITY_PASSWORD;

    public WarDeploymentInfoPanel(Composite parent, WarDeploymentInfoDialog dialog, IFile theVdb) {
        super(parent, 0);
        this.dialog = dialog;
        this.theVdb = theVdb;
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(1808));
        this.init(this);
    }

    protected static String getString(String id) {
        return DqpUiStringUtil.getString(String.valueOf(I18N_PREFIX) + id);
    }

    protected void loadData() {
        try {
            String text = this.settings.get(this.WARFILELOCATION) == null ? WarDataserviceModel.getInstance().getWarFileLocation() : this.settings.get(this.WARFILELOCATION);
            this.txfWarFileDeploymentLocation.setText(text);
            text = this.settings.get(this.NAMESPACE) == null ? WarDataserviceModel.getInstance().getTns() : this.settings.get(this.NAMESPACE);
            this.txfNamespace.setText(text);
            text = WarDataserviceModel.getInstance().getContextName();
            this.txfContext.setText(text);
            text = this.settings.get(this.HOST) == null ? WarDataserviceModel.getInstance().getHostName() : this.settings.get(this.HOST);
            this.txfHost.setText(text);
            text = this.settings.get(this.PORT) == null ? WarDataserviceModel.getInstance().getPort() : this.settings.get(this.PORT);
            this.txfPort.setText(text);
            text = WarDataserviceModel.getInstance().getJndiName();
            this.txfJNDIName.setText(text);
            text = this.settings.get(this.SECURITY_REALM) == null ? WarDataserviceModel.getInstance().getSecurityRealm() : this.settings.get(this.SECURITY_REALM);
            this.txfSecurityRealm.setText(text);
            text = this.settings.get(this.SECURITY_ROLE) == null ? WarDataserviceModel.getInstance().getSecurityRole() : this.settings.get(this.SECURITY_ROLE);
            this.txfSecurityRole.setText(text);
            text = this.settings.get(this.SECURITY_USERNAME) == null ? WarDataserviceModel.getInstance().getSecurityUsername() : this.settings.get(this.SECURITY_USERNAME);
            this.txfSecurityUsername.setText(text);
            text = this.settings.get(this.SECURITY_PASSWORD) == null ? WarDataserviceModel.getInstance().getSecurityPassword() : this.settings.get(this.SECURITY_PASSWORD);
            this.txfSecurityPassword.setEchoChar('*');
            this.txfSecurityPassword.setText(text);
            String string = text = this.settings.get(this.SECURITY_TYPE) == null ? WarDataserviceModel.getInstance().getSecurityType() : this.settings.get(this.SECURITY_TYPE);
            if (text.equals(NOSECURITY)) {
                this.noSecurityButton.setSelection(true);
            } else if (text.equals(BASIC)) {
                this.basicSecurityButton.setSelection(true);
            } else if (text.equals(WSSE)) {
                this.basicSecurityButton.setSelection(true);
            } else {
                this.noSecurityButton.setSelection(true);
            }
        }
        catch (RuntimeException err) {
            DqpUiConstants.UTIL.log((Throwable)err);
        }
    }

    protected void setDialogMessage(boolean isValid) {
        this.dialog.setMessage(INITIAL_MESSAGE);
        this.dialog.setOkButtonEnable(isValid);
    }

    protected void setDialogMessage(IStatus status) {
        boolean isError = status.getSeverity() == 4;
        int statusCode = status.getSeverity() == 4 ? 3 : status.getSeverity();
        this.dialog.setMessage(INITIAL_MESSAGE);
        if (!status.isOK()) {
            this.dialog.setMessage(status.getMessage(), statusCode);
        }
        this.dialog.setOkButtonEnable(!isError);
    }

    protected abstract void validatePage();

    private void init(Composite parent) {
        this.createDeploymentInfoComposite(parent);
        this.createRestoreDefault(parent);
        this.settings = WidgetUtil.initializeSettings((Object)this, (AbstractUIPlugin)DqpUiPlugin.getDefault());
        this.addListeners();
    }

    private void createDeploymentInfoComposite(Composite parent) {
        String text = WarDeploymentInfoPanel.getString("grpPanelText");
        Group pnlContents = WidgetFactory.createGroup((Composite)parent, (String)text, (int)768, (int)3, (int)3);
        this.CONTEXTNAME = WarDeploymentInfoPanel.getString("contextLabel");
        WidgetFactory.createLabel((Composite)pnlContents, (int)32, (int)1, (String)this.CONTEXTNAME);
        this.txfContext = WidgetFactory.createTextField((Composite)pnlContents, (int)768, (int)2);
        text = WarDeploymentInfoPanel.getString("contextTooltip");
        this.txfContext.setToolTipText(text);
        this.HOST = WarDeploymentInfoPanel.getString("hostLabel");
        WidgetFactory.createLabel((Composite)pnlContents, (int)32, (int)1, (String)this.HOST);
        this.txfHost = WidgetFactory.createTextField((Composite)pnlContents, (int)768, (int)2);
        text = WarDeploymentInfoPanel.getString("hostTooltip");
        this.txfHost.setToolTipText(text);
        this.PORT = WarDeploymentInfoPanel.getString("portLabel");
        WidgetFactory.createLabel((Composite)pnlContents, (int)32, (int)1, (String)this.PORT);
        this.txfPort = WidgetFactory.createTextField((Composite)pnlContents, (int)768, (int)2);
        text = WarDeploymentInfoPanel.getString("portTooltip");
        this.txfPort.setToolTipText(text);
        this.JNDI_NAME = WarDeploymentInfoPanel.getString("jndiLabel");
        WidgetFactory.createLabel((Composite)pnlContents, (int)32, (int)1, (String)this.JNDI_NAME);
        this.txfJNDIName = WidgetFactory.createTextField((Composite)pnlContents, (int)768, (int)2);
        text = WarDeploymentInfoPanel.getString("jndiTooltip");
        this.txfJNDIName.setToolTipText(text);
        TabFolder tabFolder = new TabFolder((Composite)pnlContents, 2176);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)tabFolder);
        Composite generalPropertiesPanel = WidgetFactory.createPanel((Composite)tabFolder);
        CLabel label3 = new CLabel(generalPropertiesPanel, 64);
        label3.setText("When using HTTPBasic security, a local Teiid connection is required using the PassthroughAuthentication property.");
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 1;
        label3.setLayoutData((Object)gridData3);
        this.noSecurityButton = WidgetFactory.createRadioButton((Composite)generalPropertiesPanel, (String)NOSECURITY);
        this.noSecurityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WarDeploymentInfoPanel.this.noSecurityButtonSelected();
            }
        });
        this.noSecurityButton.setSelection(true);
        this.basicSecurityButton = WidgetFactory.createRadioButton((Composite)generalPropertiesPanel, (String)BASIC);
        this.basicSecurityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WarDeploymentInfoPanel.this.basicSecurityButtonSelected();
            }
        });
        this.wsSecurityButton = WidgetFactory.createRadioButton((Composite)generalPropertiesPanel, (String)WSSE);
        this.wsSecurityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WarDeploymentInfoPanel.this.wsSecurityButtonSelected();
            }
        });
        this.generalSecurityTab = new TabItem(tabFolder, 0);
        this.generalSecurityTab.setControl((Control)generalPropertiesPanel);
        this.generalSecurityTab.setText("General");
        Composite httpPropertiesPanel = WidgetFactory.createPanel((Composite)tabFolder);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(httpPropertiesPanel);
        this.SECURITY_REALM = WarDeploymentInfoPanel.getString("securityRealmLabel");
        WidgetFactory.createLabel((Composite)httpPropertiesPanel, (int)32, (int)1, (String)this.SECURITY_REALM);
        this.txfSecurityRealm = WidgetFactory.createTextField((Composite)httpPropertiesPanel, (int)768, (int)2);
        text = WarDeploymentInfoPanel.getString("securityRealmTooltip");
        this.txfSecurityRealm.setToolTipText(text);
        this.txfSecurityRealm.setEnabled(false);
        this.SECURITY_ROLE = WarDeploymentInfoPanel.getString("securityRoleLabel");
        WidgetFactory.createLabel((Composite)httpPropertiesPanel, (int)32, (int)1, (String)this.SECURITY_ROLE);
        this.txfSecurityRole = WidgetFactory.createTextField((Composite)httpPropertiesPanel, (int)768, (int)2);
        text = WarDeploymentInfoPanel.getString("securityRoleTooltip");
        this.txfSecurityRole.setToolTipText(text);
        this.txfSecurityRole.setEnabled(false);
        this.httpOptionsTab = new TabItem(tabFolder, 0);
        this.httpOptionsTab.setControl((Control)httpPropertiesPanel);
        this.httpOptionsTab.setText(BASIC_OPTIONS_GROUP);
        Composite wsSecurityPanel = WidgetFactory.createPanel((Composite)tabFolder);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(wsSecurityPanel);
        this.SECURITY_USERNAME = WarDeploymentInfoPanel.getString("securityUsernameLabel");
        WidgetFactory.createLabel((Composite)wsSecurityPanel, (int)32, (int)1, (String)this.SECURITY_USERNAME);
        this.txfSecurityUsername = WidgetFactory.createTextField((Composite)wsSecurityPanel, (int)768, (int)2);
        text = WarDeploymentInfoPanel.getString("securityUsernameTooltip");
        this.txfSecurityUsername.setToolTipText(text);
        this.txfSecurityUsername.setEnabled(false);
        this.SECURITY_PASSWORD = WarDeploymentInfoPanel.getString("securityPasswordLabel");
        WidgetFactory.createLabel((Composite)wsSecurityPanel, (int)32, (int)1, (String)this.SECURITY_PASSWORD);
        this.txfSecurityPassword = WidgetFactory.createTextField((Composite)wsSecurityPanel, (int)768, (int)2);
        text = WarDeploymentInfoPanel.getString("securityPasswordTooltip");
        this.txfSecurityPassword.setToolTipText(text);
        this.txfSecurityPassword.setEnabled(false);
        this.wsSecurityTab = new TabItem(tabFolder, 0);
        this.wsSecurityTab.setControl((Control)wsSecurityPanel);
        this.wsSecurityTab.setText(WS_SECURITY_OPTIONS_GROUP);
        Group generalOptionsGroup = WidgetFactory.createGroup((Composite)pnlContents, (String)GENERAL_OPTIONS_GROUP, (int)768, (int)3);
        this.mtomButton = WidgetFactory.createCheckBox((Composite)generalOptionsGroup, (String)MTOM, (boolean)false);
        text = WarDeploymentInfoPanel.getString("mtomTooltip");
        this.mtomButton.setToolTipText(text);
        this.mtomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WarDeploymentInfoPanel.this.handleMtomButtonSelected();
            }
        });
        this.NAMESPACE = WarDeploymentInfoPanel.getString("namespaceLabel");
        WidgetFactory.createLabel((Composite)pnlContents, (int)32, (int)1, (String)this.NAMESPACE);
        this.txfNamespace = WidgetFactory.createTextField((Composite)pnlContents, (int)768, (int)2);
        text = WarDeploymentInfoPanel.getString("namespaceTooltip");
        this.txfNamespace.setToolTipText(text);
        this.WARFILELOCATION = WarDeploymentInfoPanel.getString("warFileSaveLocationLabel");
        WidgetFactory.createLabel((Composite)pnlContents, (int)32, (int)1, (String)this.WARFILELOCATION);
        this.txfWarFileDeploymentLocation = WidgetFactory.createTextField((Composite)pnlContents, (int)768, (int)2);
        text = WarDeploymentInfoPanel.getString("warFileSaveLocationTooltip");
        this.txfWarFileDeploymentLocation.setToolTipText(text);
        this.warBrowseButton = WidgetFactory.createButton((Composite)pnlContents, (String)InternalUiConstants.Widgets.BROWSE_BUTTON);
        this.warBrowseButton.setText(WarDeploymentInfoPanel.getString("changeButtonText"));
        this.warBrowseButton.setToolTipText(text);
        this.warBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                WarDeploymentInfoPanel.this.handleWarBrowseSourceSelected();
            }
        });
    }

    void setConnectionTypeModified() {
    }

    private void createRestoreDefault(Composite parent) {
        Composite restoreDefault = WidgetFactory.createPanel((Composite)parent, (int)0, (int)768, (int)1);
        GridLayout layout = new GridLayout();
        restoreDefault.setLayout((Layout)layout);
        layout.numColumns = 2;
        String text = WarDeploymentInfoPanel.getString("restoreDefaultButtonText");
        this.restoreDefaultButton = WidgetFactory.createButton((Composite)restoreDefault, (String)text, (int)3);
        text = WarDeploymentInfoPanel.getString("restoreDefaultTooltip");
        this.restoreDefaultButton.setToolTipText(text);
        this.restoreDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WarDeploymentInfoPanel.this.restoreDefaultButtonPressed();
            }
        });
    }

    private void addListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                WarDeploymentInfoPanel.this.validatePage();
                WarDeploymentInfoPanel.this.setWarFileNameInDialog();
            }
        };
        this.txfWarFileDeploymentLocation.addModifyListener(modifyListener);
        this.txfContext.addModifyListener(modifyListener);
        this.txfHost.addModifyListener(modifyListener);
        this.txfPort.addModifyListener(modifyListener);
        this.txfJNDIName.addModifyListener(modifyListener);
        this.txfNamespace.addModifyListener(modifyListener);
        this.txfSecurityRealm.addModifyListener(modifyListener);
        this.txfSecurityRole.addModifyListener(modifyListener);
        this.txfSecurityUsername.addModifyListener(modifyListener);
        this.txfSecurityPassword.addModifyListener(modifyListener);
    }

    protected void setWarFileNameInDialog() {
        this.dialog.setWarFileName(this.txfContext.getText());
    }

    void restoreDefaultButtonPressed() {
        this.txfWarFileDeploymentLocation.setText(WarDataserviceModel.getInstance().getWarFilenameDefault());
        this.txfContext.setText(WarDataserviceModel.getInstance().getContextNameDefault());
        this.txfHost.setText(WarDataserviceModel.getInstance().getHostNameDefault());
        this.txfPort.setText(WarDataserviceModel.getInstance().getPortDefault());
        this.txfNamespace.setText(WarDataserviceModel.getInstance().getTnsDefault());
        this.txfJNDIName.setText(WarDataserviceModel.getInstance().getJndiNameDefault());
        this.noSecurityButton.setSelection(true);
        this.basicSecurityButton.setSelection(false);
        this.wsSecurityButton.setSelection(false);
        this.mtomButton.setSelection(false);
        this.txfSecurityRealm.setText("");
        this.txfSecurityRealm.setEnabled(false);
        this.txfSecurityRole.setText("");
        this.txfSecurityRole.setEnabled(false);
        this.txfSecurityUsername.setText("");
        this.txfSecurityUsername.setEnabled(false);
        this.txfSecurityPassword.setText("");
        this.txfSecurityPassword.setEnabled(false);
    }

    void handleWarBrowseSourceSelected() {
        DirectoryDialog folderDialog = new DirectoryDialog(this.getShell());
        folderDialog.setText(WarDeploymentInfoPanel.getString("warTitle"));
        folderDialog.setMessage(WarDeploymentInfoPanel.getString("warMessage"));
        folderDialog.setFilterPath(this.txfWarFileDeploymentLocation.getText());
        String selectedUnit = folderDialog.open();
        if (selectedUnit != null) {
            this.txfWarFileDeploymentLocation.setText(selectedUnit);
        }
    }

    void handleMtomButtonSelected() {
        boolean selection = this.mtomButton.getSelection();
        WarDataserviceModel.getInstance().setUseMtom(selection);
        this.validatePage();
    }

    void noSecurityButtonSelected() {
        if (this.noSecurityButton.getSelection()) {
            WarDataserviceModel.getInstance().setSecurityTypeDefault(NOSECURITY);
            this.txfSecurityRealm.setText("");
            this.txfSecurityRealm.setEnabled(false);
            this.txfSecurityRole.setText("");
            this.txfSecurityRole.setEnabled(false);
            this.txfSecurityUsername.setText("");
            this.txfSecurityUsername.setEnabled(false);
            this.txfSecurityPassword.setText("");
            this.txfSecurityPassword.setEnabled(false);
        }
        this.validatePage();
    }

    void basicSecurityButtonSelected() {
        if (this.basicSecurityButton.getSelection()) {
            WarDataserviceModel.getInstance().setSecurityTypeDefault(BASIC);
            this.txfSecurityRealm.setText("teiid-security");
            WarDataserviceModel.getInstance().setSecurityRealmDefault("teiid-security");
            this.txfSecurityRealm.setEnabled(true);
            this.txfSecurityRole.setText("MyRole");
            WarDataserviceModel.getInstance().setSecurityRoleDefault("MyRole");
            this.txfSecurityRole.setEnabled(true);
            this.txfSecurityUsername.setText("");
            this.txfSecurityUsername.setEnabled(false);
            this.txfSecurityPassword.setText("");
            this.txfSecurityPassword.setEnabled(false);
        }
        this.validatePage();
    }

    void wsSecurityButtonSelected() {
        if (this.wsSecurityButton.getSelection()) {
            WarDataserviceModel.getInstance().setSecurityTypeDefault(WSSE);
            this.txfSecurityRealm.setText("");
            this.txfSecurityRealm.setEnabled(false);
            this.txfSecurityRole.setText("");
            this.txfSecurityRole.setEnabled(false);
            this.txfSecurityUsername.setText("");
            this.txfSecurityUsername.setEnabled(true);
            this.txfSecurityPassword.setText("");
            this.txfSecurityPassword.setEnabled(true);
        }
    }
}

