/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.webservices;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.designer.runtime.ui.wizards.webservices.WarDataserviceModel;
import org.teiid.designer.runtime.ui.wizards.webservices.WarDeploymentInfoDialog;
import org.teiid.designer.runtime.ui.wizards.webservices.WarDeploymentInfoPanel;
import org.teiid.designer.runtime.ui.wizards.webservices.util.WebArchiveBuilder;
import org.teiid.designer.runtime.ui.wizards.webservices.util.WebArchiveBuilderFactory;

public class WarDeploymentInfoDataPage
extends WarDeploymentInfoPanel {
    private static final String TEMP_FILE = "delete.me";
    private static final String TEMP_FILE_RENAMED = "delete.me.old";
    private String ERROR_MESSAGE = null;
    private IStatus status;

    public WarDeploymentInfoDataPage(Composite parent, WarDeploymentInfoDialog dialog, IFile theVdb, IStatus initialStatus) {
        super(parent, dialog, theVdb);
    }

    @Override
    protected void validatePage() {
        boolean isValid;
        boolean bl = isValid = this.validateContext() && this.validatePort() && this.validateHost() && this.validateJNDI() && this.validateTNS() && this.validateWARFileFolder() && this.validateSecurityRole() && this.validateSecurityRealm() && this.validateSecurityUsername() && this.validateSecurityPassword();
        if (!isValid) {
            this.setDialogMessage(this.status);
        } else {
            this.setDialogMessage(isValid);
        }
    }

    private void createStatus(int statusCode, String msg, int validationStatusCode) {
        this.status = new Status(statusCode, "org.teiid.designer.dqp.ui", validationStatusCode, msg, null);
    }

    private boolean validateContext() {
        String text = this.txfContext.getText();
        if (text == null || text.length() == 0) {
            this.ERROR_MESSAGE = WarDeploymentInfoDataPage.getString("contextErrorMessage");
            this.createStatus(4, this.ERROR_MESSAGE, 1);
            return false;
        }
        WebArchiveBuilder webArchiveBuilder = WebArchiveBuilderFactory.create();
        this.status = webArchiveBuilder.validateContextName(text);
        if (!this.status.isOK()) {
            return false;
        }
        WarDataserviceModel.getInstance().setContextName(text);
        this.settings.put(this.CONTEXTNAME, text);
        return true;
    }

    private boolean validatePort() {
        String text = this.txfPort.getText();
        if (text == null || text.length() == 0) {
            this.ERROR_MESSAGE = WarDeploymentInfoDataPage.getString("portErrorMessage");
            this.createStatus(4, this.ERROR_MESSAGE, 4);
            return false;
        }
        WarDataserviceModel.getInstance().setPort(text);
        this.settings.put(this.PORT, text);
        return true;
    }

    private boolean validateJNDI() {
        String text = this.txfJNDIName.getText();
        if (text == null || text.length() == 0) {
            this.ERROR_MESSAGE = WarDeploymentInfoDataPage.getString("jndiErrorMessage");
            this.createStatus(4, this.ERROR_MESSAGE, 5);
            return false;
        }
        WarDataserviceModel.getInstance().setJndiNameDefault(text);
        this.settings.put(this.JNDI_NAME, text);
        return true;
    }

    private boolean validateHost() {
        String text = this.txfHost.getText();
        if (text == null || text.length() == 0) {
            this.ERROR_MESSAGE = WarDeploymentInfoDataPage.getString("hostErrorMessage");
            this.createStatus(4, this.ERROR_MESSAGE, 3);
            return false;
        }
        WarDataserviceModel.getInstance().setHostName(text);
        this.settings.put(this.HOST, text);
        return true;
    }

    private boolean validateTNS() {
        String text = this.txfNamespace.getText();
        if (text == null || text.length() == 0) {
            this.ERROR_MESSAGE = WarDeploymentInfoDataPage.getString("tnsErrorMessage");
            this.createStatus(4, this.ERROR_MESSAGE, 0);
            return false;
        }
        WarDataserviceModel.getInstance().setTns(text);
        this.settings.put(this.NAMESPACE, text);
        return true;
    }

    private boolean validateSecurityRealm() {
        String text = this.txfSecurityRealm.getText();
        if (this.basicSecurityButton.getSelection() && (text == null || text.length() == 0)) {
            this.ERROR_MESSAGE = WarDeploymentInfoDataPage.getString("securityRealmMessage");
            this.createStatus(4, this.ERROR_MESSAGE, 6);
            return false;
        }
        WarDataserviceModel.getInstance().setSecurityRealmDefault(text);
        this.settings.put(this.SECURITY_REALM, text);
        return true;
    }

    private boolean validateSecurityUsername() {
        String text = this.txfSecurityUsername.getText();
        if (this.wsSecurityButton.getSelection() && (text == null || text.length() == 0)) {
            this.ERROR_MESSAGE = WarDeploymentInfoDataPage.getString("securityUsernameMessage");
            this.createStatus(4, this.ERROR_MESSAGE, 8);
            return false;
        }
        WarDataserviceModel.getInstance().setSecurityUsernameDefault(text);
        this.settings.put(this.SECURITY_USERNAME, text);
        return true;
    }

    private boolean validateSecurityPassword() {
        String text = this.txfSecurityPassword.getText();
        if (this.wsSecurityButton.getSelection() && (text == null || text.length() == 0)) {
            this.ERROR_MESSAGE = WarDeploymentInfoDataPage.getString("securityPasswordMessage");
            this.createStatus(4, this.ERROR_MESSAGE, 9);
            return false;
        }
        WarDataserviceModel.getInstance().setSecurityPasswordDefault(text);
        this.settings.put(this.SECURITY_PASSWORD, text);
        return true;
    }

    private boolean validateSecurityRole() {
        String text = this.txfSecurityRole.getText();
        if (this.basicSecurityButton.getSelection() && (text == null || text.length() == 0)) {
            this.ERROR_MESSAGE = WarDeploymentInfoDataPage.getString("securityRoleMessage");
            this.createStatus(4, this.ERROR_MESSAGE, 6);
            return false;
        }
        WarDataserviceModel.getInstance().setSecurityRoleDefault(text);
        this.settings.put(this.SECURITY_ROLE, text);
        return true;
    }

    private boolean validateWARFileFolder() {
        String text = this.txfWarFileDeploymentLocation.getText();
        if (text == null || text.length() == 0) {
            this.ERROR_MESSAGE = WarDeploymentInfoDataPage.getString("warFilePleaseEnterFile.message");
            this.createStatus(4, this.ERROR_MESSAGE, 2);
            return false;
        }
        File file = new File(text = text.trim());
        if (file.exists()) {
            try {
                WarDeploymentInfoDataPage.testDirectoryPermissions(text);
            }
            catch (Exception exception) {
                String message = WarDeploymentInfoDataPage.getString("warFileSaveFolderExistsButPermissionProblem.message");
                this.createStatus(4, message, 2);
                return false;
            }
        }
        boolean success = false;
        try {
            success = file.createNewFile();
        }
        catch (IOException iOException) {}
        if (!success) {
            String message = WarDeploymentInfoDataPage.getString("warFileSaveFolderNameProblem.message");
            this.createStatus(4, message, 2);
            return false;
        }
        success = false;
        try {
            success = file.delete();
        }
        catch (Exception exception) {}
        if (!success) {
            String message = WarDeploymentInfoDataPage.getString("warFileSaveFolderExistsButPermissionProblem.message");
            this.createStatus(4, message, 2);
            return false;
        }
        WarDataserviceModel.getInstance().setWarFileLocation(text);
        this.settings.put(this.WARFILELOCATION, text);
        return true;
    }

    public static void testDirectoryPermissions(String dirPath) throws TeiidDesignerException {
        File tmpFile = new File(String.valueOf(dirPath) + File.separatorChar + TEMP_FILE);
        boolean success = false;
        try {
            success = tmpFile.createNewFile();
        }
        catch (IOException iOException) {}
        if (!success) {
            String msg = CoreModelerPlugin.Util.getString("FileUtils.Unable_to_create_file_in", (Object)dirPath);
            throw new TeiidDesignerException(msg);
        }
        if (!tmpFile.canWrite()) {
            String msg = CoreModelerPlugin.Util.getString("FileUtils.Unable_to_write_file_in", (Object)dirPath);
            throw new TeiidDesignerException(msg);
        }
        if (!tmpFile.canRead()) {
            String msg = CoreModelerPlugin.Util.getString("FileUtils.Unable_to_read_file_in", (Object)dirPath);
            throw new TeiidDesignerException(msg);
        }
        File newFile = new File(String.valueOf(dirPath) + File.separatorChar + TEMP_FILE_RENAMED);
        success = false;
        try {
            success = tmpFile.renameTo(newFile);
        }
        catch (Exception exception) {}
        if (!success) {
            String msg = CoreModelerPlugin.Util.getString("FileUtils.Unable_to_rename_file_in", (Object)dirPath);
            throw new TeiidDesignerException(msg);
        }
        success = false;
        try {
            success = newFile.delete();
        }
        catch (Exception exception) {}
        if (!success) {
            String msg = CoreModelerPlugin.Util.getString("FileUtils.Unable_to_delete_file_in", (Object)dirPath);
            throw new TeiidDesignerException(msg);
        }
    }
}

