/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.views.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.wst.server.core.IServer;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.views.TeiidServerContentProvider;
import org.teiid.designer.runtime.ui.views.content.ITeiidContainerNode;
import org.teiid.designer.runtime.ui.views.content.ITeiidContentNode;
import org.teiid.designer.runtime.ui.views.content.ITeiidResourceNode;
import org.teiid.designer.runtime.ui.views.content.TeiidContentNode;
import org.teiid.designer.runtime.ui.views.content.TeiidErrorNode;
import org.teiid.designer.runtime.ui.views.content.TeiidServerContainerNode;

public class TeiidResourceNode
extends TeiidContentNode
implements ITeiidResourceNode {
    private static Map<String, ITeiidResourceNode> nodeCache = new WeakHashMap<String, ITeiidResourceNode>();
    private ArrayList<ITeiidContentNode<? extends ITeiidContainerNode<?>>> children;
    private TeiidServerContentProvider provider;
    private ITeiidServer teiidServer;
    private TeiidErrorNode error;
    private boolean dirty = true;

    public static ITeiidResourceNode getInstance(IServer server, TeiidServerContentProvider provider) {
        String key = String.valueOf(server.toString()) + provider.toString();
        ITeiidResourceNode node = nodeCache.get(key);
        if (node == null) {
            node = new TeiidResourceNode(server, provider);
            nodeCache.put(key, node);
        }
        return node;
    }

    private TeiidResourceNode(IServer server, TeiidServerContentProvider provider) {
        super(server, DqpUiConstants.UTIL.getString(String.valueOf(TeiidResourceNode.class.getSimpleName()) + ".label", new Object[0]));
        this.provider = provider;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public final List<? extends ITeiidContentNode<?>> getChildren() {
        if (this.dirty) {
            return null;
        }
        if (this.error != null) {
            return Collections.singletonList(this.error);
        }
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void load() {
        this.clearChildren();
        if (this.getServer().getServerState() != 2) {
            this.setError(new TeiidErrorNode(this, null, DqpUiConstants.UTIL.getString(String.valueOf(this.getClass().getSimpleName()) + ".labelNotConnected", new Object[0])));
            this.dirty = false;
            return;
        }
        TeiidServerContentProvider teiidServerContentProvider = this.provider;
        synchronized (teiidServerContentProvider) {
            block14: {
                block13: {
                    this.teiidServer = (ITeiidServer)this.getServer().loadAdapter(ITeiidServer.class, null);
                    if (this.teiidServer != null) break block13;
                    this.setError(new TeiidErrorNode(this, this.teiidServer, DqpUiConstants.UTIL.getString(String.valueOf(this.getClass().getSimpleName()) + ".labelNotConnected", new Object[0])));
                    this.dirty = false;
                    return;
                }
                if (!this.teiidServer.isConnecting() || this.teiidServer.isConnected()) break block14;
                this.setError(new TeiidErrorNode(this, this.teiidServer, DqpUiConstants.UTIL.getString(String.valueOf(this.getClass().getSimpleName()) + ".labelConnecting", new Object[0])));
                this.dirty = false;
                return;
            }
            try {
                try {
                    if (this.teiidServer.isConnected()) {
                        if (this.children == null) {
                            this.children = new ArrayList();
                        }
                        this.children.add(new TeiidServerContainerNode<TeiidResourceNode>(this, this.provider));
                        this.clearError();
                    } else {
                        this.setError(new TeiidErrorNode(this, this.teiidServer, DqpUiConstants.UTIL.getString(String.valueOf(this.getClass().getSimpleName()) + ".labelNotConnected", new Object[0])));
                    }
                }
                catch (Exception e) {
                    DqpUiConstants.UTIL.log((Throwable)e);
                    this.setError(new TeiidErrorNode(this, this.teiidServer, DqpUiConstants.UTIL.getString(String.valueOf(this.getClass().getSimpleName()) + ".labelRetrievalError", new Object[0])));
                    this.dirty = false;
                }
            }
            catch (Throwable throwable) {
                this.dirty = false;
                throw throwable;
            }
            this.dirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearChildren() {
        TeiidServerContentProvider teiidServerContentProvider = this.provider;
        synchronized (teiidServerContentProvider) {
            this.clearError();
            if (this.children != null) {
                for (ITeiidContentNode<ITeiidContainerNode<?>> child : this.children) {
                    child.dispose();
                }
                this.children.clear();
                this.children = null;
            }
            this.teiidServer = null;
        }
    }

    private void clearError() {
        if (this.error != null) {
            this.error.dispose();
            this.error = null;
        }
    }

    protected void setError(TeiidErrorNode error) {
        this.clearError();
        this.error = error;
    }

    @Override
    public void dispose() {
        this.clearChildren();
        super.dispose();
    }

    @Override
    public ITeiidServer getTeiidServer() {
        return this.teiidServer;
    }

    @Override
    public boolean hasChildren() {
        if (this.dirty) {
            return false;
        }
        return this.children != null && !this.children.isEmpty();
    }

    public String toString() {
        if (this.teiidServer == null) {
            return DqpUiConstants.UTIL.getString(String.valueOf(TeiidResourceNode.class.getSimpleName()) + ".labelNotConnected", new Object[0]);
        }
        String ttip = this.teiidServer.toString();
        if (this.teiidServer.getConnectionError() != null) {
            ttip = String.valueOf(ttip) + "\n\n" + this.teiidServer.getConnectionError();
        }
        return ttip;
    }
}

